/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.services.acm.model.AcmRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportCertificateRequest
extends AcmRequest
implements ToCopyableBuilder<Builder, ExportCertificateRequest> {
    private final String certificateArn;
    private final SdkBytes passphrase;

    private ExportCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.certificateArn = builder.certificateArn;
        this.passphrase = builder.passphrase;
    }

    public String certificateArn() {
        return this.certificateArn;
    }

    public SdkBytes passphrase() {
        return this.passphrase;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.passphrase());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportCertificateRequest)) {
            return false;
        }
        ExportCertificateRequest other = (ExportCertificateRequest)((Object)obj);
        return Objects.equals(this.certificateArn(), other.certificateArn()) && Objects.equals(this.passphrase(), other.passphrase());
    }

    public String toString() {
        return ToString.builder((String)"ExportCertificateRequest").add("CertificateArn", (Object)this.certificateArn()).add("Passphrase", (Object)this.passphrase()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateArn": {
                return Optional.ofNullable(clazz.cast(this.certificateArn()));
            }
            case "Passphrase": {
                return Optional.ofNullable(clazz.cast(this.passphrase()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AcmRequest.BuilderImpl
    implements Builder {
        private String certificateArn;
        private SdkBytes passphrase;

        private BuilderImpl() {
        }

        private BuilderImpl(ExportCertificateRequest model) {
            super(model);
            this.certificateArn(model.certificateArn);
            this.passphrase(model.passphrase);
        }

        public final String getCertificateArn() {
            return this.certificateArn;
        }

        @Override
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        public final ByteBuffer getPassphrase() {
            return this.passphrase == null ? null : this.passphrase.asByteBuffer();
        }

        @Override
        public final Builder passphrase(SdkBytes passphrase) {
            this.passphrase = StandardMemberCopier.copy((SdkBytes)passphrase);
            return this;
        }

        public final void setPassphrase(ByteBuffer passphrase) {
            this.passphrase(passphrase == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)passphrase));
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ExportCertificateRequest build() {
            return new ExportCertificateRequest(this);
        }
    }

    public static interface Builder
    extends AcmRequest.Builder,
    CopyableBuilder<Builder, ExportCertificateRequest> {
        public Builder certificateArn(String var1);

        public Builder passphrase(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

