/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.acm.model.CertificateStatus;
import software.amazon.awssdk.services.acm.model.CertificateStatusesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCertificatesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, ListCertificatesRequest> {
    private final List<String> certificateStatuses;
    private final String nextToken;
    private final Integer maxItems;

    private ListCertificatesRequest(BuilderImpl builder) {
        this.certificateStatuses = builder.certificateStatuses;
        this.nextToken = builder.nextToken;
        this.maxItems = builder.maxItems;
    }

    public List<String> certificateStatuses() {
        return this.certificateStatuses;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certificateStatuses() == null ? 0 : this.certificateStatuses().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxItems() == null ? 0 : this.maxItems().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCertificatesRequest)) {
            return false;
        }
        ListCertificatesRequest other = (ListCertificatesRequest)((Object)obj);
        if (other.certificateStatuses() == null ^ this.certificateStatuses() == null) {
            return false;
        }
        if (other.certificateStatuses() != null && !other.certificateStatuses().equals(this.certificateStatuses())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxItems() == null ^ this.maxItems() == null) {
            return false;
        }
        return other.maxItems() == null || other.maxItems().equals(this.maxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificateStatuses() != null) {
            sb.append("CertificateStatuses: ").append(this.certificateStatuses()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxItems() != null) {
            sb.append("MaxItems: ").append(this.maxItems()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> certificateStatuses;
        private String nextToken;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCertificatesRequest model) {
            this.setCertificateStatuses(model.certificateStatuses);
            this.setNextToken(model.nextToken);
            this.setMaxItems(model.maxItems);
        }

        public final Collection<String> getCertificateStatuses() {
            return this.certificateStatuses;
        }

        @Override
        public final Builder certificateStatuses(Collection<String> certificateStatuses) {
            this.certificateStatuses = CertificateStatusesCopier.copy(certificateStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateStatuses(String ... certificateStatuses) {
            if (this.certificateStatuses == null) {
                this.certificateStatuses = new ArrayList<String>(certificateStatuses.length);
            }
            for (String e : certificateStatuses) {
                this.certificateStatuses.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateStatuses(CertificateStatus ... certificateStatuses) {
            if (this.certificateStatuses == null) {
                this.certificateStatuses = new ArrayList<String>(certificateStatuses.length);
            }
            for (CertificateStatus ele : certificateStatuses) {
                this.certificateStatuses.add(ele.toString());
            }
            return this;
        }

        public final void setCertificateStatuses(Collection<String> certificateStatuses) {
            this.certificateStatuses = CertificateStatusesCopier.copy(certificateStatuses);
        }

        @SafeVarargs
        public final void setCertificateStatuses(String ... certificateStatuses) {
            if (this.certificateStatuses == null) {
                this.certificateStatuses = new ArrayList<String>(certificateStatuses.length);
            }
            for (String e : certificateStatuses) {
                this.certificateStatuses.add(e);
            }
        }

        @SafeVarargs
        public final void setCertificateStatuses(CertificateStatus ... certificateStatuses) {
            if (this.certificateStatuses == null) {
                this.certificateStatuses = new ArrayList<String>(certificateStatuses.length);
            }
            for (CertificateStatus ele : certificateStatuses) {
                this.certificateStatuses.add(ele.toString());
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        public ListCertificatesRequest build() {
            return new ListCertificatesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListCertificatesRequest> {
        public Builder certificateStatuses(Collection<String> var1);

        public Builder certificateStatuses(String ... var1);

        public Builder certificateStatuses(CertificateStatus ... var1);

        public Builder nextToken(String var1);

        public Builder maxItems(Integer var1);
    }
}

