/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.acm.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.acm.transform.DomainValidationOptionMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DomainValidationOption
implements StructuredPojo,
ToCopyableBuilder<Builder, DomainValidationOption> {
    private final String domainName;
    private final String validationDomain;

    private DomainValidationOption(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.validationDomain = builder.validationDomain;
    }

    public String domainName() {
        return this.domainName;
    }

    public String validationDomain() {
        return this.validationDomain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.domainName() == null ? 0 : this.domainName().hashCode());
        hashCode = 31 * hashCode + (this.validationDomain() == null ? 0 : this.validationDomain().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainValidationOption)) {
            return false;
        }
        DomainValidationOption other = (DomainValidationOption)obj;
        if (other.domainName() == null ^ this.domainName() == null) {
            return false;
        }
        if (other.domainName() != null && !other.domainName().equals(this.domainName())) {
            return false;
        }
        if (other.validationDomain() == null ^ this.validationDomain() == null) {
            return false;
        }
        return other.validationDomain() == null || other.validationDomain().equals(this.validationDomain());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.validationDomain() != null) {
            sb.append("ValidationDomain: ").append(this.validationDomain()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DomainValidationOptionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String validationDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainValidationOption model) {
            this.setDomainName(model.domainName);
            this.setValidationDomain(model.validationDomain);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getValidationDomain() {
            return this.validationDomain;
        }

        @Override
        public final Builder validationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
            return this;
        }

        public final void setValidationDomain(String validationDomain) {
            this.validationDomain = validationDomain;
        }

        public DomainValidationOption build() {
            return new DomainValidationOption(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DomainValidationOption> {
        public Builder domainName(String var1);

        public Builder validationDomain(String var1);
    }
}

