/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.account;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.account.AccountAsyncClient;
import software.amazon.awssdk.services.account.AccountAsyncClientBuilder;
import software.amazon.awssdk.services.account.AccountServiceClientConfiguration;
import software.amazon.awssdk.services.account.DefaultAccountAsyncClient;
import software.amazon.awssdk.services.account.DefaultAccountBaseClientBuilder;
import software.amazon.awssdk.services.account.endpoints.AccountEndpointProvider;

@SdkInternalApi
final class DefaultAccountAsyncClientBuilder
extends DefaultAccountBaseClientBuilder<AccountAsyncClientBuilder, AccountAsyncClient>
implements AccountAsyncClientBuilder {
    DefaultAccountAsyncClientBuilder() {
    }

    @Override
    public DefaultAccountAsyncClientBuilder endpointProvider(AccountEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final AccountAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultAccountAsyncClientBuilder.validateClientOptions(clientConfiguration);
        AccountServiceClientConfiguration serviceClientConfiguration = AccountServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultAccountAsyncClient(serviceClientConfiguration, clientConfiguration);
    }
}

