/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.ExternalAccessDetails;
import software.amazon.awssdk.services.accessanalyzer.model.InternalAccessDetails;
import software.amazon.awssdk.services.accessanalyzer.model.UnusedIamRoleDetails;
import software.amazon.awssdk.services.accessanalyzer.model.UnusedIamUserAccessKeyDetails;
import software.amazon.awssdk.services.accessanalyzer.model.UnusedIamUserPasswordDetails;
import software.amazon.awssdk.services.accessanalyzer.model.UnusedPermissionDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingDetails> {
    private static final SdkField<InternalAccessDetails> INTERNAL_ACCESS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("internalAccessDetails").getter(FindingDetails.getter(FindingDetails::internalAccessDetails)).setter(FindingDetails.setter(Builder::internalAccessDetails)).constructor(InternalAccessDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("internalAccessDetails").build()}).build();
    private static final SdkField<ExternalAccessDetails> EXTERNAL_ACCESS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("externalAccessDetails").getter(FindingDetails.getter(FindingDetails::externalAccessDetails)).setter(FindingDetails.setter(Builder::externalAccessDetails)).constructor(ExternalAccessDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalAccessDetails").build()}).build();
    private static final SdkField<UnusedPermissionDetails> UNUSED_PERMISSION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("unusedPermissionDetails").getter(FindingDetails.getter(FindingDetails::unusedPermissionDetails)).setter(FindingDetails.setter(Builder::unusedPermissionDetails)).constructor(UnusedPermissionDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedPermissionDetails").build()}).build();
    private static final SdkField<UnusedIamUserAccessKeyDetails> UNUSED_IAM_USER_ACCESS_KEY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("unusedIamUserAccessKeyDetails").getter(FindingDetails.getter(FindingDetails::unusedIamUserAccessKeyDetails)).setter(FindingDetails.setter(Builder::unusedIamUserAccessKeyDetails)).constructor(UnusedIamUserAccessKeyDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedIamUserAccessKeyDetails").build()}).build();
    private static final SdkField<UnusedIamRoleDetails> UNUSED_IAM_ROLE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("unusedIamRoleDetails").getter(FindingDetails.getter(FindingDetails::unusedIamRoleDetails)).setter(FindingDetails.setter(Builder::unusedIamRoleDetails)).constructor(UnusedIamRoleDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedIamRoleDetails").build()}).build();
    private static final SdkField<UnusedIamUserPasswordDetails> UNUSED_IAM_USER_PASSWORD_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("unusedIamUserPasswordDetails").getter(FindingDetails.getter(FindingDetails::unusedIamUserPasswordDetails)).setter(FindingDetails.setter(Builder::unusedIamUserPasswordDetails)).constructor(UnusedIamUserPasswordDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedIamUserPasswordDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERNAL_ACCESS_DETAILS_FIELD, EXTERNAL_ACCESS_DETAILS_FIELD, UNUSED_PERMISSION_DETAILS_FIELD, UNUSED_IAM_USER_ACCESS_KEY_DETAILS_FIELD, UNUSED_IAM_ROLE_DETAILS_FIELD, UNUSED_IAM_USER_PASSWORD_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FindingDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final InternalAccessDetails internalAccessDetails;
    private final ExternalAccessDetails externalAccessDetails;
    private final UnusedPermissionDetails unusedPermissionDetails;
    private final UnusedIamUserAccessKeyDetails unusedIamUserAccessKeyDetails;
    private final UnusedIamRoleDetails unusedIamRoleDetails;
    private final UnusedIamUserPasswordDetails unusedIamUserPasswordDetails;
    private final Type type;

    private FindingDetails(BuilderImpl builder) {
        this.internalAccessDetails = builder.internalAccessDetails;
        this.externalAccessDetails = builder.externalAccessDetails;
        this.unusedPermissionDetails = builder.unusedPermissionDetails;
        this.unusedIamUserAccessKeyDetails = builder.unusedIamUserAccessKeyDetails;
        this.unusedIamRoleDetails = builder.unusedIamRoleDetails;
        this.unusedIamUserPasswordDetails = builder.unusedIamUserPasswordDetails;
        this.type = builder.type;
    }

    public final InternalAccessDetails internalAccessDetails() {
        return this.internalAccessDetails;
    }

    public final ExternalAccessDetails externalAccessDetails() {
        return this.externalAccessDetails;
    }

    public final UnusedPermissionDetails unusedPermissionDetails() {
        return this.unusedPermissionDetails;
    }

    public final UnusedIamUserAccessKeyDetails unusedIamUserAccessKeyDetails() {
        return this.unusedIamUserAccessKeyDetails;
    }

    public final UnusedIamRoleDetails unusedIamRoleDetails() {
        return this.unusedIamRoleDetails;
    }

    public final UnusedIamUserPasswordDetails unusedIamUserPasswordDetails() {
        return this.unusedIamUserPasswordDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.internalAccessDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.externalAccessDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.unusedPermissionDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.unusedIamUserAccessKeyDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.unusedIamRoleDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.unusedIamUserPasswordDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingDetails)) {
            return false;
        }
        FindingDetails other = (FindingDetails)obj;
        return Objects.equals(this.internalAccessDetails(), other.internalAccessDetails()) && Objects.equals(this.externalAccessDetails(), other.externalAccessDetails()) && Objects.equals(this.unusedPermissionDetails(), other.unusedPermissionDetails()) && Objects.equals(this.unusedIamUserAccessKeyDetails(), other.unusedIamUserAccessKeyDetails()) && Objects.equals(this.unusedIamRoleDetails(), other.unusedIamRoleDetails()) && Objects.equals(this.unusedIamUserPasswordDetails(), other.unusedIamUserPasswordDetails());
    }

    public final String toString() {
        return ToString.builder((String)"FindingDetails").add("InternalAccessDetails", (Object)this.internalAccessDetails()).add("ExternalAccessDetails", (Object)this.externalAccessDetails()).add("UnusedPermissionDetails", (Object)this.unusedPermissionDetails()).add("UnusedIamUserAccessKeyDetails", (Object)this.unusedIamUserAccessKeyDetails()).add("UnusedIamRoleDetails", (Object)this.unusedIamRoleDetails()).add("UnusedIamUserPasswordDetails", (Object)this.unusedIamUserPasswordDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "internalAccessDetails": {
                return Optional.ofNullable(clazz.cast(this.internalAccessDetails()));
            }
            case "externalAccessDetails": {
                return Optional.ofNullable(clazz.cast(this.externalAccessDetails()));
            }
            case "unusedPermissionDetails": {
                return Optional.ofNullable(clazz.cast(this.unusedPermissionDetails()));
            }
            case "unusedIamUserAccessKeyDetails": {
                return Optional.ofNullable(clazz.cast(this.unusedIamUserAccessKeyDetails()));
            }
            case "unusedIamRoleDetails": {
                return Optional.ofNullable(clazz.cast(this.unusedIamRoleDetails()));
            }
            case "unusedIamUserPasswordDetails": {
                return Optional.ofNullable(clazz.cast(this.unusedIamUserPasswordDetails()));
            }
        }
        return Optional.empty();
    }

    public static FindingDetails fromInternalAccessDetails(InternalAccessDetails internalAccessDetails) {
        return (FindingDetails)FindingDetails.builder().internalAccessDetails(internalAccessDetails).build();
    }

    public static FindingDetails fromInternalAccessDetails(Consumer<InternalAccessDetails.Builder> internalAccessDetails) {
        InternalAccessDetails.Builder builder = InternalAccessDetails.builder();
        internalAccessDetails.accept(builder);
        return FindingDetails.fromInternalAccessDetails((InternalAccessDetails)builder.build());
    }

    public static FindingDetails fromExternalAccessDetails(ExternalAccessDetails externalAccessDetails) {
        return (FindingDetails)FindingDetails.builder().externalAccessDetails(externalAccessDetails).build();
    }

    public static FindingDetails fromExternalAccessDetails(Consumer<ExternalAccessDetails.Builder> externalAccessDetails) {
        ExternalAccessDetails.Builder builder = ExternalAccessDetails.builder();
        externalAccessDetails.accept(builder);
        return FindingDetails.fromExternalAccessDetails((ExternalAccessDetails)builder.build());
    }

    public static FindingDetails fromUnusedPermissionDetails(UnusedPermissionDetails unusedPermissionDetails) {
        return (FindingDetails)FindingDetails.builder().unusedPermissionDetails(unusedPermissionDetails).build();
    }

    public static FindingDetails fromUnusedPermissionDetails(Consumer<UnusedPermissionDetails.Builder> unusedPermissionDetails) {
        UnusedPermissionDetails.Builder builder = UnusedPermissionDetails.builder();
        unusedPermissionDetails.accept(builder);
        return FindingDetails.fromUnusedPermissionDetails((UnusedPermissionDetails)builder.build());
    }

    public static FindingDetails fromUnusedIamUserAccessKeyDetails(UnusedIamUserAccessKeyDetails unusedIamUserAccessKeyDetails) {
        return (FindingDetails)FindingDetails.builder().unusedIamUserAccessKeyDetails(unusedIamUserAccessKeyDetails).build();
    }

    public static FindingDetails fromUnusedIamUserAccessKeyDetails(Consumer<UnusedIamUserAccessKeyDetails.Builder> unusedIamUserAccessKeyDetails) {
        UnusedIamUserAccessKeyDetails.Builder builder = UnusedIamUserAccessKeyDetails.builder();
        unusedIamUserAccessKeyDetails.accept(builder);
        return FindingDetails.fromUnusedIamUserAccessKeyDetails((UnusedIamUserAccessKeyDetails)builder.build());
    }

    public static FindingDetails fromUnusedIamRoleDetails(UnusedIamRoleDetails unusedIamRoleDetails) {
        return (FindingDetails)FindingDetails.builder().unusedIamRoleDetails(unusedIamRoleDetails).build();
    }

    public static FindingDetails fromUnusedIamRoleDetails(Consumer<UnusedIamRoleDetails.Builder> unusedIamRoleDetails) {
        UnusedIamRoleDetails.Builder builder = UnusedIamRoleDetails.builder();
        unusedIamRoleDetails.accept(builder);
        return FindingDetails.fromUnusedIamRoleDetails((UnusedIamRoleDetails)builder.build());
    }

    public static FindingDetails fromUnusedIamUserPasswordDetails(UnusedIamUserPasswordDetails unusedIamUserPasswordDetails) {
        return (FindingDetails)FindingDetails.builder().unusedIamUserPasswordDetails(unusedIamUserPasswordDetails).build();
    }

    public static FindingDetails fromUnusedIamUserPasswordDetails(Consumer<UnusedIamUserPasswordDetails.Builder> unusedIamUserPasswordDetails) {
        UnusedIamUserPasswordDetails.Builder builder = UnusedIamUserPasswordDetails.builder();
        unusedIamUserPasswordDetails.accept(builder);
        return FindingDetails.fromUnusedIamUserPasswordDetails((UnusedIamUserPasswordDetails)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("internalAccessDetails", INTERNAL_ACCESS_DETAILS_FIELD);
        map.put("externalAccessDetails", EXTERNAL_ACCESS_DETAILS_FIELD);
        map.put("unusedPermissionDetails", UNUSED_PERMISSION_DETAILS_FIELD);
        map.put("unusedIamUserAccessKeyDetails", UNUSED_IAM_USER_ACCESS_KEY_DETAILS_FIELD);
        map.put("unusedIamRoleDetails", UNUSED_IAM_ROLE_DETAILS_FIELD);
        map.put("unusedIamUserPasswordDetails", UNUSED_IAM_USER_PASSWORD_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingDetails, T> g) {
        return obj -> g.apply((FindingDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        INTERNAL_ACCESS_DETAILS,
        EXTERNAL_ACCESS_DETAILS,
        UNUSED_PERMISSION_DETAILS,
        UNUSED_IAM_USER_ACCESS_KEY_DETAILS,
        UNUSED_IAM_ROLE_DETAILS,
        UNUSED_IAM_USER_PASSWORD_DETAILS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private InternalAccessDetails internalAccessDetails;
        private ExternalAccessDetails externalAccessDetails;
        private UnusedPermissionDetails unusedPermissionDetails;
        private UnusedIamUserAccessKeyDetails unusedIamUserAccessKeyDetails;
        private UnusedIamRoleDetails unusedIamRoleDetails;
        private UnusedIamUserPasswordDetails unusedIamUserPasswordDetails;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FindingDetails model) {
            this.internalAccessDetails(model.internalAccessDetails);
            this.externalAccessDetails(model.externalAccessDetails);
            this.unusedPermissionDetails(model.unusedPermissionDetails);
            this.unusedIamUserAccessKeyDetails(model.unusedIamUserAccessKeyDetails);
            this.unusedIamRoleDetails(model.unusedIamRoleDetails);
            this.unusedIamUserPasswordDetails(model.unusedIamUserPasswordDetails);
        }

        public final InternalAccessDetails.Builder getInternalAccessDetails() {
            return this.internalAccessDetails != null ? this.internalAccessDetails.toBuilder() : null;
        }

        public final void setInternalAccessDetails(InternalAccessDetails.BuilderImpl internalAccessDetails) {
            InternalAccessDetails oldValue = this.internalAccessDetails;
            this.internalAccessDetails = internalAccessDetails != null ? internalAccessDetails.build() : null;
            this.handleUnionValueChange(Type.INTERNAL_ACCESS_DETAILS, oldValue, this.internalAccessDetails);
        }

        @Override
        public final Builder internalAccessDetails(InternalAccessDetails internalAccessDetails) {
            InternalAccessDetails oldValue = this.internalAccessDetails;
            this.internalAccessDetails = internalAccessDetails;
            this.handleUnionValueChange(Type.INTERNAL_ACCESS_DETAILS, oldValue, this.internalAccessDetails);
            return this;
        }

        public final ExternalAccessDetails.Builder getExternalAccessDetails() {
            return this.externalAccessDetails != null ? this.externalAccessDetails.toBuilder() : null;
        }

        public final void setExternalAccessDetails(ExternalAccessDetails.BuilderImpl externalAccessDetails) {
            ExternalAccessDetails oldValue = this.externalAccessDetails;
            this.externalAccessDetails = externalAccessDetails != null ? externalAccessDetails.build() : null;
            this.handleUnionValueChange(Type.EXTERNAL_ACCESS_DETAILS, oldValue, this.externalAccessDetails);
        }

        @Override
        public final Builder externalAccessDetails(ExternalAccessDetails externalAccessDetails) {
            ExternalAccessDetails oldValue = this.externalAccessDetails;
            this.externalAccessDetails = externalAccessDetails;
            this.handleUnionValueChange(Type.EXTERNAL_ACCESS_DETAILS, oldValue, this.externalAccessDetails);
            return this;
        }

        public final UnusedPermissionDetails.Builder getUnusedPermissionDetails() {
            return this.unusedPermissionDetails != null ? this.unusedPermissionDetails.toBuilder() : null;
        }

        public final void setUnusedPermissionDetails(UnusedPermissionDetails.BuilderImpl unusedPermissionDetails) {
            UnusedPermissionDetails oldValue = this.unusedPermissionDetails;
            this.unusedPermissionDetails = unusedPermissionDetails != null ? unusedPermissionDetails.build() : null;
            this.handleUnionValueChange(Type.UNUSED_PERMISSION_DETAILS, oldValue, this.unusedPermissionDetails);
        }

        @Override
        public final Builder unusedPermissionDetails(UnusedPermissionDetails unusedPermissionDetails) {
            UnusedPermissionDetails oldValue = this.unusedPermissionDetails;
            this.unusedPermissionDetails = unusedPermissionDetails;
            this.handleUnionValueChange(Type.UNUSED_PERMISSION_DETAILS, oldValue, this.unusedPermissionDetails);
            return this;
        }

        public final UnusedIamUserAccessKeyDetails.Builder getUnusedIamUserAccessKeyDetails() {
            return this.unusedIamUserAccessKeyDetails != null ? this.unusedIamUserAccessKeyDetails.toBuilder() : null;
        }

        public final void setUnusedIamUserAccessKeyDetails(UnusedIamUserAccessKeyDetails.BuilderImpl unusedIamUserAccessKeyDetails) {
            UnusedIamUserAccessKeyDetails oldValue = this.unusedIamUserAccessKeyDetails;
            this.unusedIamUserAccessKeyDetails = unusedIamUserAccessKeyDetails != null ? unusedIamUserAccessKeyDetails.build() : null;
            this.handleUnionValueChange(Type.UNUSED_IAM_USER_ACCESS_KEY_DETAILS, oldValue, this.unusedIamUserAccessKeyDetails);
        }

        @Override
        public final Builder unusedIamUserAccessKeyDetails(UnusedIamUserAccessKeyDetails unusedIamUserAccessKeyDetails) {
            UnusedIamUserAccessKeyDetails oldValue = this.unusedIamUserAccessKeyDetails;
            this.unusedIamUserAccessKeyDetails = unusedIamUserAccessKeyDetails;
            this.handleUnionValueChange(Type.UNUSED_IAM_USER_ACCESS_KEY_DETAILS, oldValue, this.unusedIamUserAccessKeyDetails);
            return this;
        }

        public final UnusedIamRoleDetails.Builder getUnusedIamRoleDetails() {
            return this.unusedIamRoleDetails != null ? this.unusedIamRoleDetails.toBuilder() : null;
        }

        public final void setUnusedIamRoleDetails(UnusedIamRoleDetails.BuilderImpl unusedIamRoleDetails) {
            UnusedIamRoleDetails oldValue = this.unusedIamRoleDetails;
            this.unusedIamRoleDetails = unusedIamRoleDetails != null ? unusedIamRoleDetails.build() : null;
            this.handleUnionValueChange(Type.UNUSED_IAM_ROLE_DETAILS, oldValue, this.unusedIamRoleDetails);
        }

        @Override
        public final Builder unusedIamRoleDetails(UnusedIamRoleDetails unusedIamRoleDetails) {
            UnusedIamRoleDetails oldValue = this.unusedIamRoleDetails;
            this.unusedIamRoleDetails = unusedIamRoleDetails;
            this.handleUnionValueChange(Type.UNUSED_IAM_ROLE_DETAILS, oldValue, this.unusedIamRoleDetails);
            return this;
        }

        public final UnusedIamUserPasswordDetails.Builder getUnusedIamUserPasswordDetails() {
            return this.unusedIamUserPasswordDetails != null ? this.unusedIamUserPasswordDetails.toBuilder() : null;
        }

        public final void setUnusedIamUserPasswordDetails(UnusedIamUserPasswordDetails.BuilderImpl unusedIamUserPasswordDetails) {
            UnusedIamUserPasswordDetails oldValue = this.unusedIamUserPasswordDetails;
            this.unusedIamUserPasswordDetails = unusedIamUserPasswordDetails != null ? unusedIamUserPasswordDetails.build() : null;
            this.handleUnionValueChange(Type.UNUSED_IAM_USER_PASSWORD_DETAILS, oldValue, this.unusedIamUserPasswordDetails);
        }

        @Override
        public final Builder unusedIamUserPasswordDetails(UnusedIamUserPasswordDetails unusedIamUserPasswordDetails) {
            UnusedIamUserPasswordDetails oldValue = this.unusedIamUserPasswordDetails;
            this.unusedIamUserPasswordDetails = unusedIamUserPasswordDetails;
            this.handleUnionValueChange(Type.UNUSED_IAM_USER_PASSWORD_DETAILS, oldValue, this.unusedIamUserPasswordDetails);
            return this;
        }

        public FindingDetails build() {
            return new FindingDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingDetails> {
        public Builder internalAccessDetails(InternalAccessDetails var1);

        default public Builder internalAccessDetails(Consumer<InternalAccessDetails.Builder> internalAccessDetails) {
            return this.internalAccessDetails((InternalAccessDetails)((InternalAccessDetails.Builder)InternalAccessDetails.builder().applyMutation(internalAccessDetails)).build());
        }

        public Builder externalAccessDetails(ExternalAccessDetails var1);

        default public Builder externalAccessDetails(Consumer<ExternalAccessDetails.Builder> externalAccessDetails) {
            return this.externalAccessDetails((ExternalAccessDetails)((ExternalAccessDetails.Builder)ExternalAccessDetails.builder().applyMutation(externalAccessDetails)).build());
        }

        public Builder unusedPermissionDetails(UnusedPermissionDetails var1);

        default public Builder unusedPermissionDetails(Consumer<UnusedPermissionDetails.Builder> unusedPermissionDetails) {
            return this.unusedPermissionDetails((UnusedPermissionDetails)((UnusedPermissionDetails.Builder)UnusedPermissionDetails.builder().applyMutation(unusedPermissionDetails)).build());
        }

        public Builder unusedIamUserAccessKeyDetails(UnusedIamUserAccessKeyDetails var1);

        default public Builder unusedIamUserAccessKeyDetails(Consumer<UnusedIamUserAccessKeyDetails.Builder> unusedIamUserAccessKeyDetails) {
            return this.unusedIamUserAccessKeyDetails((UnusedIamUserAccessKeyDetails)((UnusedIamUserAccessKeyDetails.Builder)UnusedIamUserAccessKeyDetails.builder().applyMutation(unusedIamUserAccessKeyDetails)).build());
        }

        public Builder unusedIamRoleDetails(UnusedIamRoleDetails var1);

        default public Builder unusedIamRoleDetails(Consumer<UnusedIamRoleDetails.Builder> unusedIamRoleDetails) {
            return this.unusedIamRoleDetails((UnusedIamRoleDetails)((UnusedIamRoleDetails.Builder)UnusedIamRoleDetails.builder().applyMutation(unusedIamRoleDetails)).build());
        }

        public Builder unusedIamUserPasswordDetails(UnusedIamUserPasswordDetails var1);

        default public Builder unusedIamUserPasswordDetails(Consumer<UnusedIamUserPasswordDetails.Builder> unusedIamUserPasswordDetails) {
            return this.unusedIamUserPasswordDetails((UnusedIamUserPasswordDetails)((UnusedIamUserPasswordDetails.Builder)UnusedIamUserPasswordDetails.builder().applyMutation(unusedIamUserPasswordDetails)).build());
        }
    }
}

