/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Proposed configuration for an access point attached to an Amazon S3 directory bucket. You can propose up to 10 access
 * points per bucket. If the proposed access point configuration is for an existing Amazon S3 directory bucket, the
 * access preview uses the proposed access point configuration in place of the existing access points. To propose an
 * access point without a policy, you can provide an empty string as the access point policy. For more information about
 * access points for Amazon S3 directory buckets, see <a
 * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points-directory-buckets.html">Managing access to
 * directory buckets with access points</a> in the Amazon Simple Storage Service User Guide.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3ExpressDirectoryAccessPointConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<S3ExpressDirectoryAccessPointConfiguration.Builder, S3ExpressDirectoryAccessPointConfiguration> {
    private static final SdkField<String> ACCESS_POINT_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessPointPolicy").getter(getter(S3ExpressDirectoryAccessPointConfiguration::accessPointPolicy))
            .setter(setter(Builder::accessPointPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessPointPolicy").build()).build();

    private static final SdkField<NetworkOriginConfiguration> NETWORK_ORIGIN_FIELD = SdkField
            .<NetworkOriginConfiguration> builder(MarshallingType.SDK_POJO).memberName("networkOrigin")
            .getter(getter(S3ExpressDirectoryAccessPointConfiguration::networkOrigin)).setter(setter(Builder::networkOrigin))
            .constructor(NetworkOriginConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkOrigin").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POINT_POLICY_FIELD,
            NETWORK_ORIGIN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessPointPolicy;

    private final NetworkOriginConfiguration networkOrigin;

    private S3ExpressDirectoryAccessPointConfiguration(BuilderImpl builder) {
        this.accessPointPolicy = builder.accessPointPolicy;
        this.networkOrigin = builder.networkOrigin;
    }

    /**
     * <p>
     * The proposed access point policy for an Amazon S3 directory bucket access point.
     * </p>
     * 
     * @return The proposed access point policy for an Amazon S3 directory bucket access point.
     */
    public final String accessPointPolicy() {
        return accessPointPolicy;
    }

    /**
     * Returns the value of the NetworkOrigin property for this object.
     * 
     * @return The value of the NetworkOrigin property for this object.
     */
    public final NetworkOriginConfiguration networkOrigin() {
        return networkOrigin;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessPointPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(networkOrigin());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ExpressDirectoryAccessPointConfiguration)) {
            return false;
        }
        S3ExpressDirectoryAccessPointConfiguration other = (S3ExpressDirectoryAccessPointConfiguration) obj;
        return Objects.equals(accessPointPolicy(), other.accessPointPolicy())
                && Objects.equals(networkOrigin(), other.networkOrigin());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3ExpressDirectoryAccessPointConfiguration").add("AccessPointPolicy", accessPointPolicy())
                .add("NetworkOrigin", networkOrigin()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessPointPolicy":
            return Optional.ofNullable(clazz.cast(accessPointPolicy()));
        case "networkOrigin":
            return Optional.ofNullable(clazz.cast(networkOrigin()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessPointPolicy", ACCESS_POINT_POLICY_FIELD);
        map.put("networkOrigin", NETWORK_ORIGIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ExpressDirectoryAccessPointConfiguration, T> g) {
        return obj -> g.apply((S3ExpressDirectoryAccessPointConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3ExpressDirectoryAccessPointConfiguration> {
        /**
         * <p>
         * The proposed access point policy for an Amazon S3 directory bucket access point.
         * </p>
         * 
         * @param accessPointPolicy
         *        The proposed access point policy for an Amazon S3 directory bucket access point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPointPolicy(String accessPointPolicy);

        /**
         * Sets the value of the NetworkOrigin property for this object.
         *
         * @param networkOrigin
         *        The new value for the NetworkOrigin property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkOrigin(NetworkOriginConfiguration networkOrigin);

        /**
         * Sets the value of the NetworkOrigin property for this object.
         *
         * This is a convenience method that creates an instance of the {@link NetworkOriginConfiguration.Builder}
         * avoiding the need to create one manually via {@link NetworkOriginConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link NetworkOriginConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #networkOrigin(NetworkOriginConfiguration)}.
         * 
         * @param networkOrigin
         *        a consumer that will call methods on {@link NetworkOriginConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkOrigin(NetworkOriginConfiguration)
         */
        default Builder networkOrigin(Consumer<NetworkOriginConfiguration.Builder> networkOrigin) {
            return networkOrigin(NetworkOriginConfiguration.builder().applyMutation(networkOrigin).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String accessPointPolicy;

        private NetworkOriginConfiguration networkOrigin;

        private BuilderImpl() {
        }

        private BuilderImpl(S3ExpressDirectoryAccessPointConfiguration model) {
            accessPointPolicy(model.accessPointPolicy);
            networkOrigin(model.networkOrigin);
        }

        public final String getAccessPointPolicy() {
            return accessPointPolicy;
        }

        public final void setAccessPointPolicy(String accessPointPolicy) {
            this.accessPointPolicy = accessPointPolicy;
        }

        @Override
        public final Builder accessPointPolicy(String accessPointPolicy) {
            this.accessPointPolicy = accessPointPolicy;
            return this;
        }

        public final NetworkOriginConfiguration.Builder getNetworkOrigin() {
            return networkOrigin != null ? networkOrigin.toBuilder() : null;
        }

        public final void setNetworkOrigin(NetworkOriginConfiguration.BuilderImpl networkOrigin) {
            this.networkOrigin = networkOrigin != null ? networkOrigin.build() : null;
        }

        @Override
        public final Builder networkOrigin(NetworkOriginConfiguration networkOrigin) {
            this.networkOrigin = networkOrigin;
            return this;
        }

        @Override
        public S3ExpressDirectoryAccessPointConfiguration build() {
            return new S3ExpressDirectoryAccessPointConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
