/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class ResourceTypeStatisticsMapCopier {
    static Map<String, ResourceTypeDetails> copy(Map<String, ? extends ResourceTypeDetails> resourceTypeStatisticsMapParam) {
        Map<String, ResourceTypeDetails> map;
        if (resourceTypeStatisticsMapParam == null || resourceTypeStatisticsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ResourceTypeDetails> modifiableMap = new LinkedHashMap<>(resourceTypeStatisticsMapParam.size());
            resourceTypeStatisticsMapParam.forEach((key, value) -> {
                modifiableMap.put(key, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ResourceTypeDetails> copyFromBuilder(
            Map<String, ? extends ResourceTypeDetails.Builder> resourceTypeStatisticsMapParam) {
        Map<String, ResourceTypeDetails> map;
        if (resourceTypeStatisticsMapParam == null || resourceTypeStatisticsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ResourceTypeDetails> modifiableMap = new LinkedHashMap<>(resourceTypeStatisticsMapParam.size());
            resourceTypeStatisticsMapParam.forEach((key, value) -> {
                ResourceTypeDetails member = value == null ? null : value.build();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ResourceTypeDetails.Builder> copyToBuilder(
            Map<String, ? extends ResourceTypeDetails> resourceTypeStatisticsMapParam) {
        Map<String, ResourceTypeDetails.Builder> map;
        if (resourceTypeStatisticsMapParam == null || resourceTypeStatisticsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ResourceTypeDetails.Builder> modifiableMap = new LinkedHashMap<>(resourceTypeStatisticsMapParam.size());
            resourceTypeStatisticsMapParam.forEach((key, value) -> {
                ResourceTypeDetails.Builder member = value == null ? null : value.toBuilder();
                modifiableMap.put(key, member);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<String, ResourceTypeDetails> copyEnumToString(
            Map<ResourceType, ? extends ResourceTypeDetails> resourceTypeStatisticsMapParam) {
        Map<String, ResourceTypeDetails> map;
        if (resourceTypeStatisticsMapParam == null || resourceTypeStatisticsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<String, ResourceTypeDetails> modifiableMap = new LinkedHashMap<>(resourceTypeStatisticsMapParam.size());
            resourceTypeStatisticsMapParam.forEach((key, value) -> {
                String result = key == null ? null : key.toString();
                modifiableMap.put(result, value);
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }

    static Map<ResourceType, ResourceTypeDetails> copyStringToEnum(
            Map<String, ? extends ResourceTypeDetails> resourceTypeStatisticsMapParam) {
        Map<ResourceType, ResourceTypeDetails> map;
        if (resourceTypeStatisticsMapParam == null || resourceTypeStatisticsMapParam instanceof SdkAutoConstructMap) {
            map = DefaultSdkAutoConstructMap.getInstance();
        } else {
            Map<ResourceType, ResourceTypeDetails> modifiableMap = new LinkedHashMap<>(resourceTypeStatisticsMapParam.size());
            resourceTypeStatisticsMapParam.forEach((key, value) -> {
                ResourceType result = ResourceType.fromValue(key);
                if (result != ResourceType.UNKNOWN_TO_SDK_VERSION) {
                    modifiableMap.put(result, value);
                }
            });
            map = Collections.unmodifiableMap(modifiableMap);
        }
        return map;
    }
}
