/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an internal access finding. This includes details about the access that was identified
 * within your Amazon Web Services organization or account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InternalAccessDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<InternalAccessDetails.Builder, InternalAccessDetails> {
    private static final SdkField<List<String>> ACTION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("action")
            .getter(getter(InternalAccessDetails::action))
            .setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> CONDITION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("condition")
            .getter(getter(InternalAccessDetails::condition))
            .setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> PRINCIPAL_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("principal")
            .getter(getter(InternalAccessDetails::principal))
            .setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> PRINCIPAL_OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalOwnerAccount").getter(getter(InternalAccessDetails::principalOwnerAccount))
            .setter(setter(Builder::principalOwnerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalOwnerAccount").build())
            .build();

    private static final SdkField<String> ACCESS_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessType").getter(getter(InternalAccessDetails::accessTypeAsString))
            .setter(setter(Builder::accessType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessType").build()).build();

    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalType").getter(getter(InternalAccessDetails::principalTypeAsString))
            .setter(setter(Builder::principalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalType").build()).build();

    private static final SdkField<List<FindingSource>> SOURCES_FIELD = SdkField
            .<List<FindingSource>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(InternalAccessDetails::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_CONTROL_POLICY_RESTRICTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("resourceControlPolicyRestriction")
            .getter(getter(InternalAccessDetails::resourceControlPolicyRestrictionAsString))
            .setter(setter(Builder::resourceControlPolicyRestriction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceControlPolicyRestriction")
                    .build()).build();

    private static final SdkField<String> SERVICE_CONTROL_POLICY_RESTRICTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("serviceControlPolicyRestriction")
            .getter(getter(InternalAccessDetails::serviceControlPolicyRestrictionAsString))
            .setter(setter(Builder::serviceControlPolicyRestriction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceControlPolicyRestriction")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, CONDITION_FIELD,
            PRINCIPAL_FIELD, PRINCIPAL_OWNER_ACCOUNT_FIELD, ACCESS_TYPE_FIELD, PRINCIPAL_TYPE_FIELD, SOURCES_FIELD,
            RESOURCE_CONTROL_POLICY_RESTRICTION_FIELD, SERVICE_CONTROL_POLICY_RESTRICTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> action;

    private final Map<String, String> condition;

    private final Map<String, String> principal;

    private final String principalOwnerAccount;

    private final String accessType;

    private final String principalType;

    private final List<FindingSource> sources;

    private final String resourceControlPolicyRestriction;

    private final String serviceControlPolicyRestriction;

    private InternalAccessDetails(BuilderImpl builder) {
        this.action = builder.action;
        this.condition = builder.condition;
        this.principal = builder.principal;
        this.principalOwnerAccount = builder.principalOwnerAccount;
        this.accessType = builder.accessType;
        this.principalType = builder.principalType;
        this.sources = builder.sources;
        this.resourceControlPolicyRestriction = builder.resourceControlPolicyRestriction;
        this.serviceControlPolicyRestriction = builder.serviceControlPolicyRestriction;
    }

    /**
     * For responses, this returns true if the service returned a value for the Action property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAction() {
        return action != null && !(action instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The action in the analyzed policy statement that has internal access permission to use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAction} method.
     * </p>
     * 
     * @return The action in the analyzed policy statement that has internal access permission to use.
     */
    public final List<String> action() {
        return action;
    }

    /**
     * For responses, this returns true if the service returned a value for the Condition property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCondition() {
        return condition != null && !(condition instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The condition in the analyzed policy statement that resulted in an internal access finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCondition} method.
     * </p>
     * 
     * @return The condition in the analyzed policy statement that resulted in an internal access finding.
     */
    public final Map<String, String> condition() {
        return condition;
    }

    /**
     * For responses, this returns true if the service returned a value for the Principal property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPrincipal() {
        return principal != null && !(principal instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The principal that has access to a resource within the internal environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrincipal} method.
     * </p>
     * 
     * @return The principal that has access to a resource within the internal environment.
     */
    public final Map<String, String> principal() {
        return principal;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the principal identified in the internal access finding.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the principal identified in the internal access finding.
     */
    public final String principalOwnerAccount() {
        return principalOwnerAccount;
    }

    /**
     * <p>
     * The type of internal access identified in the finding. This indicates how the access is granted within your
     * Amazon Web Services environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessType} will
     * return {@link InternalAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessTypeAsString}.
     * </p>
     * 
     * @return The type of internal access identified in the finding. This indicates how the access is granted within
     *         your Amazon Web Services environment.
     * @see InternalAccessType
     */
    public final InternalAccessType accessType() {
        return InternalAccessType.fromValue(accessType);
    }

    /**
     * <p>
     * The type of internal access identified in the finding. This indicates how the access is granted within your
     * Amazon Web Services environment.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accessType} will
     * return {@link InternalAccessType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #accessTypeAsString}.
     * </p>
     * 
     * @return The type of internal access identified in the finding. This indicates how the access is granted within
     *         your Amazon Web Services environment.
     * @see InternalAccessType
     */
    public final String accessTypeAsString() {
        return accessType;
    }

    /**
     * <p>
     * The type of principal identified in the internal access finding, such as IAM role or IAM user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return The type of principal identified in the internal access finding, such as IAM role or IAM user.
     * @see PrincipalType
     */
    public final PrincipalType principalType() {
        return PrincipalType.fromValue(principalType);
    }

    /**
     * <p>
     * The type of principal identified in the internal access finding, such as IAM role or IAM user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return The type of principal identified in the internal access finding, such as IAM role or IAM user.
     * @see PrincipalType
     */
    public final String principalTypeAsString() {
        return principalType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sources of the internal access finding. This indicates how the access that generated the finding is granted
     * within your Amazon Web Services environment.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return The sources of the internal access finding. This indicates how the access that generated the finding is
     *         granted within your Amazon Web Services environment.
     */
    public final List<FindingSource> sources() {
        return sources;
    }

    /**
     * <p>
     * The type of restriction applied to the finding by the resource owner with an Organizations resource control
     * policy (RCP).
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>APPLICABLE</code>: There is an RCP present in the organization but IAM Access Analyzer does not include it
     * in the evaluation of effective permissions. For example, if <code>s3:DeleteObject</code> is blocked by the RCP
     * and the restriction is <code>APPLICABLE</code>, then <code>s3:DeleteObject</code> would still be included in the
     * list of actions for the finding. Only applicable to internal access findings with the account as the zone of
     * trust.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED_TO_EVALUATE_RCP</code>: There was an error evaluating the RCP.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_APPLICABLE</code>: There was no RCP present in the organization. For internal access findings with the
     * account as the zone of trust, <code>NOT_APPLICABLE</code> could also indicate that there was no RCP applicable to
     * the resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPLIED</code>: An RCP is present in the organization and IAM Access Analyzer included it in the evaluation
     * of effective permissions. For example, if <code>s3:DeleteObject</code> is blocked by the RCP and the restriction
     * is <code>APPLIED</code>, then <code>s3:DeleteObject</code> would not be included in the list of actions for the
     * finding. Only applicable to internal access findings with the organization as the zone of trust.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceControlPolicyRestriction} will return
     * {@link ResourceControlPolicyRestriction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceControlPolicyRestrictionAsString}.
     * </p>
     * 
     * @return The type of restriction applied to the finding by the resource owner with an Organizations resource
     *         control policy (RCP).</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>APPLICABLE</code>: There is an RCP present in the organization but IAM Access Analyzer does not
     *         include it in the evaluation of effective permissions. For example, if <code>s3:DeleteObject</code> is
     *         blocked by the RCP and the restriction is <code>APPLICABLE</code>, then <code>s3:DeleteObject</code>
     *         would still be included in the list of actions for the finding. Only applicable to internal access
     *         findings with the account as the zone of trust.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED_TO_EVALUATE_RCP</code>: There was an error evaluating the RCP.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_APPLICABLE</code>: There was no RCP present in the organization. For internal access findings
     *         with the account as the zone of trust, <code>NOT_APPLICABLE</code> could also indicate that there was no
     *         RCP applicable to the resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPLIED</code>: An RCP is present in the organization and IAM Access Analyzer included it in the
     *         evaluation of effective permissions. For example, if <code>s3:DeleteObject</code> is blocked by the RCP
     *         and the restriction is <code>APPLIED</code>, then <code>s3:DeleteObject</code> would not be included in
     *         the list of actions for the finding. Only applicable to internal access findings with the organization as
     *         the zone of trust.
     *         </p>
     *         </li>
     * @see ResourceControlPolicyRestriction
     */
    public final ResourceControlPolicyRestriction resourceControlPolicyRestriction() {
        return ResourceControlPolicyRestriction.fromValue(resourceControlPolicyRestriction);
    }

    /**
     * <p>
     * The type of restriction applied to the finding by the resource owner with an Organizations resource control
     * policy (RCP).
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>APPLICABLE</code>: There is an RCP present in the organization but IAM Access Analyzer does not include it
     * in the evaluation of effective permissions. For example, if <code>s3:DeleteObject</code> is blocked by the RCP
     * and the restriction is <code>APPLICABLE</code>, then <code>s3:DeleteObject</code> would still be included in the
     * list of actions for the finding. Only applicable to internal access findings with the account as the zone of
     * trust.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED_TO_EVALUATE_RCP</code>: There was an error evaluating the RCP.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_APPLICABLE</code>: There was no RCP present in the organization. For internal access findings with the
     * account as the zone of trust, <code>NOT_APPLICABLE</code> could also indicate that there was no RCP applicable to
     * the resource.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPLIED</code>: An RCP is present in the organization and IAM Access Analyzer included it in the evaluation
     * of effective permissions. For example, if <code>s3:DeleteObject</code> is blocked by the RCP and the restriction
     * is <code>APPLIED</code>, then <code>s3:DeleteObject</code> would not be included in the list of actions for the
     * finding. Only applicable to internal access findings with the organization as the zone of trust.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #resourceControlPolicyRestriction} will return
     * {@link ResourceControlPolicyRestriction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #resourceControlPolicyRestrictionAsString}.
     * </p>
     * 
     * @return The type of restriction applied to the finding by the resource owner with an Organizations resource
     *         control policy (RCP).</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>APPLICABLE</code>: There is an RCP present in the organization but IAM Access Analyzer does not
     *         include it in the evaluation of effective permissions. For example, if <code>s3:DeleteObject</code> is
     *         blocked by the RCP and the restriction is <code>APPLICABLE</code>, then <code>s3:DeleteObject</code>
     *         would still be included in the list of actions for the finding. Only applicable to internal access
     *         findings with the account as the zone of trust.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED_TO_EVALUATE_RCP</code>: There was an error evaluating the RCP.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_APPLICABLE</code>: There was no RCP present in the organization. For internal access findings
     *         with the account as the zone of trust, <code>NOT_APPLICABLE</code> could also indicate that there was no
     *         RCP applicable to the resource.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPLIED</code>: An RCP is present in the organization and IAM Access Analyzer included it in the
     *         evaluation of effective permissions. For example, if <code>s3:DeleteObject</code> is blocked by the RCP
     *         and the restriction is <code>APPLIED</code>, then <code>s3:DeleteObject</code> would not be included in
     *         the list of actions for the finding. Only applicable to internal access findings with the organization as
     *         the zone of trust.
     *         </p>
     *         </li>
     * @see ResourceControlPolicyRestriction
     */
    public final String resourceControlPolicyRestrictionAsString() {
        return resourceControlPolicyRestriction;
    }

    /**
     * <p>
     * The type of restriction applied to the finding by an Organizations service control policy (SCP).
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>APPLICABLE</code>: There is an SCP present in the organization but IAM Access Analyzer does not include it
     * in the evaluation of effective permissions. Only applicable to internal access findings with the account as the
     * zone of trust.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED_TO_EVALUATE_SCP</code>: There was an error evaluating the SCP.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_APPLICABLE</code>: There was no SCP present in the organization. For internal access findings with the
     * account as the zone of trust, <code>NOT_APPLICABLE</code> could also indicate that there was no SCP applicable to
     * the principal.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPLIED</code>: An SCP is present in the organization and IAM Access Analyzer included it in the evaluation
     * of effective permissions. Only applicable to internal access findings with the organization as the zone of trust.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serviceControlPolicyRestriction} will return
     * {@link ServiceControlPolicyRestriction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serviceControlPolicyRestrictionAsString}.
     * </p>
     * 
     * @return The type of restriction applied to the finding by an Organizations service control policy (SCP).</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>APPLICABLE</code>: There is an SCP present in the organization but IAM Access Analyzer does not
     *         include it in the evaluation of effective permissions. Only applicable to internal access findings with
     *         the account as the zone of trust.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED_TO_EVALUATE_SCP</code>: There was an error evaluating the SCP.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_APPLICABLE</code>: There was no SCP present in the organization. For internal access findings
     *         with the account as the zone of trust, <code>NOT_APPLICABLE</code> could also indicate that there was no
     *         SCP applicable to the principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPLIED</code>: An SCP is present in the organization and IAM Access Analyzer included it in the
     *         evaluation of effective permissions. Only applicable to internal access findings with the organization as
     *         the zone of trust.
     *         </p>
     *         </li>
     * @see ServiceControlPolicyRestriction
     */
    public final ServiceControlPolicyRestriction serviceControlPolicyRestriction() {
        return ServiceControlPolicyRestriction.fromValue(serviceControlPolicyRestriction);
    }

    /**
     * <p>
     * The type of restriction applied to the finding by an Organizations service control policy (SCP).
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>APPLICABLE</code>: There is an SCP present in the organization but IAM Access Analyzer does not include it
     * in the evaluation of effective permissions. Only applicable to internal access findings with the account as the
     * zone of trust.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED_TO_EVALUATE_SCP</code>: There was an error evaluating the SCP.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NOT_APPLICABLE</code>: There was no SCP present in the organization. For internal access findings with the
     * account as the zone of trust, <code>NOT_APPLICABLE</code> could also indicate that there was no SCP applicable to
     * the principal.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPLIED</code>: An SCP is present in the organization and IAM Access Analyzer included it in the evaluation
     * of effective permissions. Only applicable to internal access findings with the organization as the zone of trust.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serviceControlPolicyRestriction} will return
     * {@link ServiceControlPolicyRestriction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serviceControlPolicyRestrictionAsString}.
     * </p>
     * 
     * @return The type of restriction applied to the finding by an Organizations service control policy (SCP).</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>APPLICABLE</code>: There is an SCP present in the organization but IAM Access Analyzer does not
     *         include it in the evaluation of effective permissions. Only applicable to internal access findings with
     *         the account as the zone of trust.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED_TO_EVALUATE_SCP</code>: There was an error evaluating the SCP.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NOT_APPLICABLE</code>: There was no SCP present in the organization. For internal access findings
     *         with the account as the zone of trust, <code>NOT_APPLICABLE</code> could also indicate that there was no
     *         SCP applicable to the principal.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPLIED</code>: An SCP is present in the organization and IAM Access Analyzer included it in the
     *         evaluation of effective permissions. Only applicable to internal access findings with the organization as
     *         the zone of trust.
     *         </p>
     *         </li>
     * @see ServiceControlPolicyRestriction
     */
    public final String serviceControlPolicyRestrictionAsString() {
        return serviceControlPolicyRestriction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAction() ? action() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCondition() ? condition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipal() ? principal() : null);
        hashCode = 31 * hashCode + Objects.hashCode(principalOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(accessTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(principalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resourceControlPolicyRestrictionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(serviceControlPolicyRestrictionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InternalAccessDetails)) {
            return false;
        }
        InternalAccessDetails other = (InternalAccessDetails) obj;
        return hasAction() == other.hasAction() && Objects.equals(action(), other.action())
                && hasCondition() == other.hasCondition() && Objects.equals(condition(), other.condition())
                && hasPrincipal() == other.hasPrincipal() && Objects.equals(principal(), other.principal())
                && Objects.equals(principalOwnerAccount(), other.principalOwnerAccount())
                && Objects.equals(accessTypeAsString(), other.accessTypeAsString())
                && Objects.equals(principalTypeAsString(), other.principalTypeAsString()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources())
                && Objects.equals(resourceControlPolicyRestrictionAsString(), other.resourceControlPolicyRestrictionAsString())
                && Objects.equals(serviceControlPolicyRestrictionAsString(), other.serviceControlPolicyRestrictionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InternalAccessDetails").add("Action", hasAction() ? action() : null)
                .add("Condition", hasCondition() ? condition() : null).add("Principal", hasPrincipal() ? principal() : null)
                .add("PrincipalOwnerAccount", principalOwnerAccount()).add("AccessType", accessTypeAsString())
                .add("PrincipalType", principalTypeAsString()).add("Sources", hasSources() ? sources() : null)
                .add("ResourceControlPolicyRestriction", resourceControlPolicyRestrictionAsString())
                .add("ServiceControlPolicyRestriction", serviceControlPolicyRestrictionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "principalOwnerAccount":
            return Optional.ofNullable(clazz.cast(principalOwnerAccount()));
        case "accessType":
            return Optional.ofNullable(clazz.cast(accessTypeAsString()));
        case "principalType":
            return Optional.ofNullable(clazz.cast(principalTypeAsString()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "resourceControlPolicyRestriction":
            return Optional.ofNullable(clazz.cast(resourceControlPolicyRestrictionAsString()));
        case "serviceControlPolicyRestriction":
            return Optional.ofNullable(clazz.cast(serviceControlPolicyRestrictionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("action", ACTION_FIELD);
        map.put("condition", CONDITION_FIELD);
        map.put("principal", PRINCIPAL_FIELD);
        map.put("principalOwnerAccount", PRINCIPAL_OWNER_ACCOUNT_FIELD);
        map.put("accessType", ACCESS_TYPE_FIELD);
        map.put("principalType", PRINCIPAL_TYPE_FIELD);
        map.put("sources", SOURCES_FIELD);
        map.put("resourceControlPolicyRestriction", RESOURCE_CONTROL_POLICY_RESTRICTION_FIELD);
        map.put("serviceControlPolicyRestriction", SERVICE_CONTROL_POLICY_RESTRICTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InternalAccessDetails, T> g) {
        return obj -> g.apply((InternalAccessDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InternalAccessDetails> {
        /**
         * <p>
         * The action in the analyzed policy statement that has internal access permission to use.
         * </p>
         * 
         * @param action
         *        The action in the analyzed policy statement that has internal access permission to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(Collection<String> action);

        /**
         * <p>
         * The action in the analyzed policy statement that has internal access permission to use.
         * </p>
         * 
         * @param action
         *        The action in the analyzed policy statement that has internal access permission to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String... action);

        /**
         * <p>
         * The condition in the analyzed policy statement that resulted in an internal access finding.
         * </p>
         * 
         * @param condition
         *        The condition in the analyzed policy statement that resulted in an internal access finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(Map<String, String> condition);

        /**
         * <p>
         * The principal that has access to a resource within the internal environment.
         * </p>
         * 
         * @param principal
         *        The principal that has access to a resource within the internal environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(Map<String, String> principal);

        /**
         * <p>
         * The Amazon Web Services account ID that owns the principal identified in the internal access finding.
         * </p>
         * 
         * @param principalOwnerAccount
         *        The Amazon Web Services account ID that owns the principal identified in the internal access finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalOwnerAccount(String principalOwnerAccount);

        /**
         * <p>
         * The type of internal access identified in the finding. This indicates how the access is granted within your
         * Amazon Web Services environment.
         * </p>
         * 
         * @param accessType
         *        The type of internal access identified in the finding. This indicates how the access is granted within
         *        your Amazon Web Services environment.
         * @see InternalAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InternalAccessType
         */
        Builder accessType(String accessType);

        /**
         * <p>
         * The type of internal access identified in the finding. This indicates how the access is granted within your
         * Amazon Web Services environment.
         * </p>
         * 
         * @param accessType
         *        The type of internal access identified in the finding. This indicates how the access is granted within
         *        your Amazon Web Services environment.
         * @see InternalAccessType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InternalAccessType
         */
        Builder accessType(InternalAccessType accessType);

        /**
         * <p>
         * The type of principal identified in the internal access finding, such as IAM role or IAM user.
         * </p>
         * 
         * @param principalType
         *        The type of principal identified in the internal access finding, such as IAM role or IAM user.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(String principalType);

        /**
         * <p>
         * The type of principal identified in the internal access finding, such as IAM role or IAM user.
         * </p>
         * 
         * @param principalType
         *        The type of principal identified in the internal access finding, such as IAM role or IAM user.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(PrincipalType principalType);

        /**
         * <p>
         * The sources of the internal access finding. This indicates how the access that generated the finding is
         * granted within your Amazon Web Services environment.
         * </p>
         * 
         * @param sources
         *        The sources of the internal access finding. This indicates how the access that generated the finding
         *        is granted within your Amazon Web Services environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<FindingSource> sources);

        /**
         * <p>
         * The sources of the internal access finding. This indicates how the access that generated the finding is
         * granted within your Amazon Web Services environment.
         * </p>
         * 
         * @param sources
         *        The sources of the internal access finding. This indicates how the access that generated the finding
         *        is granted within your Amazon Web Services environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(FindingSource... sources);

        /**
         * <p>
         * The sources of the internal access finding. This indicates how the access that generated the finding is
         * granted within your Amazon Web Services environment.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.accessanalyzer.model.FindingSource.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.accessanalyzer.model.FindingSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.accessanalyzer.model.FindingSource.Builder#build()} is called
         * immediately and its result is passed to {@link #sources(List<FindingSource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.accessanalyzer.model.FindingSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(java.util.Collection<FindingSource>)
         */
        Builder sources(Consumer<FindingSource.Builder>... sources);

        /**
         * <p>
         * The type of restriction applied to the finding by the resource owner with an Organizations resource control
         * policy (RCP).
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>APPLICABLE</code>: There is an RCP present in the organization but IAM Access Analyzer does not include
         * it in the evaluation of effective permissions. For example, if <code>s3:DeleteObject</code> is blocked by the
         * RCP and the restriction is <code>APPLICABLE</code>, then <code>s3:DeleteObject</code> would still be included
         * in the list of actions for the finding. Only applicable to internal access findings with the account as the
         * zone of trust.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED_TO_EVALUATE_RCP</code>: There was an error evaluating the RCP.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_APPLICABLE</code>: There was no RCP present in the organization. For internal access findings with
         * the account as the zone of trust, <code>NOT_APPLICABLE</code> could also indicate that there was no RCP
         * applicable to the resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPLIED</code>: An RCP is present in the organization and IAM Access Analyzer included it in the
         * evaluation of effective permissions. For example, if <code>s3:DeleteObject</code> is blocked by the RCP and
         * the restriction is <code>APPLIED</code>, then <code>s3:DeleteObject</code> would not be included in the list
         * of actions for the finding. Only applicable to internal access findings with the organization as the zone of
         * trust.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceControlPolicyRestriction
         *        The type of restriction applied to the finding by the resource owner with an Organizations resource
         *        control policy (RCP).</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>APPLICABLE</code>: There is an RCP present in the organization but IAM Access Analyzer does not
         *        include it in the evaluation of effective permissions. For example, if <code>s3:DeleteObject</code> is
         *        blocked by the RCP and the restriction is <code>APPLICABLE</code>, then <code>s3:DeleteObject</code>
         *        would still be included in the list of actions for the finding. Only applicable to internal access
         *        findings with the account as the zone of trust.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED_TO_EVALUATE_RCP</code>: There was an error evaluating the RCP.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_APPLICABLE</code>: There was no RCP present in the organization. For internal access
         *        findings with the account as the zone of trust, <code>NOT_APPLICABLE</code> could also indicate that
         *        there was no RCP applicable to the resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPLIED</code>: An RCP is present in the organization and IAM Access Analyzer included it in the
         *        evaluation of effective permissions. For example, if <code>s3:DeleteObject</code> is blocked by the
         *        RCP and the restriction is <code>APPLIED</code>, then <code>s3:DeleteObject</code> would not be
         *        included in the list of actions for the finding. Only applicable to internal access findings with the
         *        organization as the zone of trust.
         *        </p>
         *        </li>
         * @see ResourceControlPolicyRestriction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceControlPolicyRestriction
         */
        Builder resourceControlPolicyRestriction(String resourceControlPolicyRestriction);

        /**
         * <p>
         * The type of restriction applied to the finding by the resource owner with an Organizations resource control
         * policy (RCP).
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>APPLICABLE</code>: There is an RCP present in the organization but IAM Access Analyzer does not include
         * it in the evaluation of effective permissions. For example, if <code>s3:DeleteObject</code> is blocked by the
         * RCP and the restriction is <code>APPLICABLE</code>, then <code>s3:DeleteObject</code> would still be included
         * in the list of actions for the finding. Only applicable to internal access findings with the account as the
         * zone of trust.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED_TO_EVALUATE_RCP</code>: There was an error evaluating the RCP.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_APPLICABLE</code>: There was no RCP present in the organization. For internal access findings with
         * the account as the zone of trust, <code>NOT_APPLICABLE</code> could also indicate that there was no RCP
         * applicable to the resource.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPLIED</code>: An RCP is present in the organization and IAM Access Analyzer included it in the
         * evaluation of effective permissions. For example, if <code>s3:DeleteObject</code> is blocked by the RCP and
         * the restriction is <code>APPLIED</code>, then <code>s3:DeleteObject</code> would not be included in the list
         * of actions for the finding. Only applicable to internal access findings with the organization as the zone of
         * trust.
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceControlPolicyRestriction
         *        The type of restriction applied to the finding by the resource owner with an Organizations resource
         *        control policy (RCP).</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>APPLICABLE</code>: There is an RCP present in the organization but IAM Access Analyzer does not
         *        include it in the evaluation of effective permissions. For example, if <code>s3:DeleteObject</code> is
         *        blocked by the RCP and the restriction is <code>APPLICABLE</code>, then <code>s3:DeleteObject</code>
         *        would still be included in the list of actions for the finding. Only applicable to internal access
         *        findings with the account as the zone of trust.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED_TO_EVALUATE_RCP</code>: There was an error evaluating the RCP.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_APPLICABLE</code>: There was no RCP present in the organization. For internal access
         *        findings with the account as the zone of trust, <code>NOT_APPLICABLE</code> could also indicate that
         *        there was no RCP applicable to the resource.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPLIED</code>: An RCP is present in the organization and IAM Access Analyzer included it in the
         *        evaluation of effective permissions. For example, if <code>s3:DeleteObject</code> is blocked by the
         *        RCP and the restriction is <code>APPLIED</code>, then <code>s3:DeleteObject</code> would not be
         *        included in the list of actions for the finding. Only applicable to internal access findings with the
         *        organization as the zone of trust.
         *        </p>
         *        </li>
         * @see ResourceControlPolicyRestriction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceControlPolicyRestriction
         */
        Builder resourceControlPolicyRestriction(ResourceControlPolicyRestriction resourceControlPolicyRestriction);

        /**
         * <p>
         * The type of restriction applied to the finding by an Organizations service control policy (SCP).
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>APPLICABLE</code>: There is an SCP present in the organization but IAM Access Analyzer does not include
         * it in the evaluation of effective permissions. Only applicable to internal access findings with the account
         * as the zone of trust.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED_TO_EVALUATE_SCP</code>: There was an error evaluating the SCP.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_APPLICABLE</code>: There was no SCP present in the organization. For internal access findings with
         * the account as the zone of trust, <code>NOT_APPLICABLE</code> could also indicate that there was no SCP
         * applicable to the principal.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPLIED</code>: An SCP is present in the organization and IAM Access Analyzer included it in the
         * evaluation of effective permissions. Only applicable to internal access findings with the organization as the
         * zone of trust.
         * </p>
         * </li>
         * </ul>
         * 
         * @param serviceControlPolicyRestriction
         *        The type of restriction applied to the finding by an Organizations service control policy (SCP).</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>APPLICABLE</code>: There is an SCP present in the organization but IAM Access Analyzer does not
         *        include it in the evaluation of effective permissions. Only applicable to internal access findings
         *        with the account as the zone of trust.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED_TO_EVALUATE_SCP</code>: There was an error evaluating the SCP.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_APPLICABLE</code>: There was no SCP present in the organization. For internal access
         *        findings with the account as the zone of trust, <code>NOT_APPLICABLE</code> could also indicate that
         *        there was no SCP applicable to the principal.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPLIED</code>: An SCP is present in the organization and IAM Access Analyzer included it in the
         *        evaluation of effective permissions. Only applicable to internal access findings with the organization
         *        as the zone of trust.
         *        </p>
         *        </li>
         * @see ServiceControlPolicyRestriction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceControlPolicyRestriction
         */
        Builder serviceControlPolicyRestriction(String serviceControlPolicyRestriction);

        /**
         * <p>
         * The type of restriction applied to the finding by an Organizations service control policy (SCP).
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>APPLICABLE</code>: There is an SCP present in the organization but IAM Access Analyzer does not include
         * it in the evaluation of effective permissions. Only applicable to internal access findings with the account
         * as the zone of trust.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED_TO_EVALUATE_SCP</code>: There was an error evaluating the SCP.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NOT_APPLICABLE</code>: There was no SCP present in the organization. For internal access findings with
         * the account as the zone of trust, <code>NOT_APPLICABLE</code> could also indicate that there was no SCP
         * applicable to the principal.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPLIED</code>: An SCP is present in the organization and IAM Access Analyzer included it in the
         * evaluation of effective permissions. Only applicable to internal access findings with the organization as the
         * zone of trust.
         * </p>
         * </li>
         * </ul>
         * 
         * @param serviceControlPolicyRestriction
         *        The type of restriction applied to the finding by an Organizations service control policy (SCP).</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>APPLICABLE</code>: There is an SCP present in the organization but IAM Access Analyzer does not
         *        include it in the evaluation of effective permissions. Only applicable to internal access findings
         *        with the account as the zone of trust.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED_TO_EVALUATE_SCP</code>: There was an error evaluating the SCP.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NOT_APPLICABLE</code>: There was no SCP present in the organization. For internal access
         *        findings with the account as the zone of trust, <code>NOT_APPLICABLE</code> could also indicate that
         *        there was no SCP applicable to the principal.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPLIED</code>: An SCP is present in the organization and IAM Access Analyzer included it in the
         *        evaluation of effective permissions. Only applicable to internal access findings with the organization
         *        as the zone of trust.
         *        </p>
         *        </li>
         * @see ServiceControlPolicyRestriction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceControlPolicyRestriction
         */
        Builder serviceControlPolicyRestriction(ServiceControlPolicyRestriction serviceControlPolicyRestriction);
    }

    static final class BuilderImpl implements Builder {
        private List<String> action = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> condition = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> principal = DefaultSdkAutoConstructMap.getInstance();

        private String principalOwnerAccount;

        private String accessType;

        private String principalType;

        private List<FindingSource> sources = DefaultSdkAutoConstructList.getInstance();

        private String resourceControlPolicyRestriction;

        private String serviceControlPolicyRestriction;

        private BuilderImpl() {
        }

        private BuilderImpl(InternalAccessDetails model) {
            action(model.action);
            condition(model.condition);
            principal(model.principal);
            principalOwnerAccount(model.principalOwnerAccount);
            accessType(model.accessType);
            principalType(model.principalType);
            sources(model.sources);
            resourceControlPolicyRestriction(model.resourceControlPolicyRestriction);
            serviceControlPolicyRestriction(model.serviceControlPolicyRestriction);
        }

        public final Collection<String> getAction() {
            if (action instanceof SdkAutoConstructList) {
                return null;
            }
            return action;
        }

        public final void setAction(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
        }

        @Override
        public final Builder action(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder action(String... action) {
            action(Arrays.asList(action));
            return this;
        }

        public final Map<String, String> getCondition() {
            if (condition instanceof SdkAutoConstructMap) {
                return null;
            }
            return condition;
        }

        public final void setCondition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
        }

        @Override
        public final Builder condition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
            return this;
        }

        public final Map<String, String> getPrincipal() {
            if (principal instanceof SdkAutoConstructMap) {
                return null;
            }
            return principal;
        }

        public final void setPrincipal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
        }

        @Override
        public final Builder principal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
            return this;
        }

        public final String getPrincipalOwnerAccount() {
            return principalOwnerAccount;
        }

        public final void setPrincipalOwnerAccount(String principalOwnerAccount) {
            this.principalOwnerAccount = principalOwnerAccount;
        }

        @Override
        public final Builder principalOwnerAccount(String principalOwnerAccount) {
            this.principalOwnerAccount = principalOwnerAccount;
            return this;
        }

        public final String getAccessType() {
            return accessType;
        }

        public final void setAccessType(String accessType) {
            this.accessType = accessType;
        }

        @Override
        public final Builder accessType(String accessType) {
            this.accessType = accessType;
            return this;
        }

        @Override
        public final Builder accessType(InternalAccessType accessType) {
            this.accessType(accessType == null ? null : accessType.toString());
            return this;
        }

        public final String getPrincipalType() {
            return principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        public final List<FindingSource.Builder> getSources() {
            List<FindingSource.Builder> result = FindingSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<FindingSource.BuilderImpl> sources) {
            this.sources = FindingSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<FindingSource> sources) {
            this.sources = FindingSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(FindingSource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<FindingSource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> FindingSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getResourceControlPolicyRestriction() {
            return resourceControlPolicyRestriction;
        }

        public final void setResourceControlPolicyRestriction(String resourceControlPolicyRestriction) {
            this.resourceControlPolicyRestriction = resourceControlPolicyRestriction;
        }

        @Override
        public final Builder resourceControlPolicyRestriction(String resourceControlPolicyRestriction) {
            this.resourceControlPolicyRestriction = resourceControlPolicyRestriction;
            return this;
        }

        @Override
        public final Builder resourceControlPolicyRestriction(ResourceControlPolicyRestriction resourceControlPolicyRestriction) {
            this.resourceControlPolicyRestriction(resourceControlPolicyRestriction == null ? null
                    : resourceControlPolicyRestriction.toString());
            return this;
        }

        public final String getServiceControlPolicyRestriction() {
            return serviceControlPolicyRestriction;
        }

        public final void setServiceControlPolicyRestriction(String serviceControlPolicyRestriction) {
            this.serviceControlPolicyRestriction = serviceControlPolicyRestriction;
        }

        @Override
        public final Builder serviceControlPolicyRestriction(String serviceControlPolicyRestriction) {
            this.serviceControlPolicyRestriction = serviceControlPolicyRestriction;
            return this;
        }

        @Override
        public final Builder serviceControlPolicyRestriction(ServiceControlPolicyRestriction serviceControlPolicyRestriction) {
            this.serviceControlPolicyRestriction(serviceControlPolicyRestriction == null ? null : serviceControlPolicyRestriction
                    .toString());
            return this;
        }

        @Override
        public InternalAccessDetails build() {
            return new InternalAccessDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
