/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the aggregate statistics for an external or unused access analyzer. Only one parameter can
 * be used in a <code>FindingsStatistics</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingsStatistics implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingsStatistics.Builder, FindingsStatistics> {
    private static final SdkField<ExternalAccessFindingsStatistics> EXTERNAL_ACCESS_FINDINGS_STATISTICS_FIELD = SdkField
            .<ExternalAccessFindingsStatistics> builder(MarshallingType.SDK_POJO)
            .memberName("externalAccessFindingsStatistics")
            .getter(getter(FindingsStatistics::externalAccessFindingsStatistics))
            .setter(setter(Builder::externalAccessFindingsStatistics))
            .constructor(ExternalAccessFindingsStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalAccessFindingsStatistics")
                    .build()).build();

    private static final SdkField<InternalAccessFindingsStatistics> INTERNAL_ACCESS_FINDINGS_STATISTICS_FIELD = SdkField
            .<InternalAccessFindingsStatistics> builder(MarshallingType.SDK_POJO)
            .memberName("internalAccessFindingsStatistics")
            .getter(getter(FindingsStatistics::internalAccessFindingsStatistics))
            .setter(setter(Builder::internalAccessFindingsStatistics))
            .constructor(InternalAccessFindingsStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("internalAccessFindingsStatistics")
                    .build()).build();

    private static final SdkField<UnusedAccessFindingsStatistics> UNUSED_ACCESS_FINDINGS_STATISTICS_FIELD = SdkField
            .<UnusedAccessFindingsStatistics> builder(MarshallingType.SDK_POJO)
            .memberName("unusedAccessFindingsStatistics")
            .getter(getter(FindingsStatistics::unusedAccessFindingsStatistics))
            .setter(setter(Builder::unusedAccessFindingsStatistics))
            .constructor(UnusedAccessFindingsStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedAccessFindingsStatistics")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXTERNAL_ACCESS_FINDINGS_STATISTICS_FIELD, INTERNAL_ACCESS_FINDINGS_STATISTICS_FIELD,
            UNUSED_ACCESS_FINDINGS_STATISTICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ExternalAccessFindingsStatistics externalAccessFindingsStatistics;

    private final InternalAccessFindingsStatistics internalAccessFindingsStatistics;

    private final UnusedAccessFindingsStatistics unusedAccessFindingsStatistics;

    private final Type type;

    private FindingsStatistics(BuilderImpl builder) {
        this.externalAccessFindingsStatistics = builder.externalAccessFindingsStatistics;
        this.internalAccessFindingsStatistics = builder.internalAccessFindingsStatistics;
        this.unusedAccessFindingsStatistics = builder.unusedAccessFindingsStatistics;
        this.type = builder.type;
    }

    /**
     * <p>
     * The aggregate statistics for an external access analyzer.
     * </p>
     * 
     * @return The aggregate statistics for an external access analyzer.
     */
    public final ExternalAccessFindingsStatistics externalAccessFindingsStatistics() {
        return externalAccessFindingsStatistics;
    }

    /**
     * <p>
     * The aggregate statistics for an internal access analyzer. This includes information about active, archived, and
     * resolved findings related to internal access within your Amazon Web Services organization or account.
     * </p>
     * 
     * @return The aggregate statistics for an internal access analyzer. This includes information about active,
     *         archived, and resolved findings related to internal access within your Amazon Web Services organization
     *         or account.
     */
    public final InternalAccessFindingsStatistics internalAccessFindingsStatistics() {
        return internalAccessFindingsStatistics;
    }

    /**
     * <p>
     * The aggregate statistics for an unused access analyzer.
     * </p>
     * 
     * @return The aggregate statistics for an unused access analyzer.
     */
    public final UnusedAccessFindingsStatistics unusedAccessFindingsStatistics() {
        return unusedAccessFindingsStatistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(externalAccessFindingsStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(internalAccessFindingsStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(unusedAccessFindingsStatistics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingsStatistics)) {
            return false;
        }
        FindingsStatistics other = (FindingsStatistics) obj;
        return Objects.equals(externalAccessFindingsStatistics(), other.externalAccessFindingsStatistics())
                && Objects.equals(internalAccessFindingsStatistics(), other.internalAccessFindingsStatistics())
                && Objects.equals(unusedAccessFindingsStatistics(), other.unusedAccessFindingsStatistics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingsStatistics").add("ExternalAccessFindingsStatistics", externalAccessFindingsStatistics())
                .add("InternalAccessFindingsStatistics", internalAccessFindingsStatistics())
                .add("UnusedAccessFindingsStatistics", unusedAccessFindingsStatistics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "externalAccessFindingsStatistics":
            return Optional.ofNullable(clazz.cast(externalAccessFindingsStatistics()));
        case "internalAccessFindingsStatistics":
            return Optional.ofNullable(clazz.cast(internalAccessFindingsStatistics()));
        case "unusedAccessFindingsStatistics":
            return Optional.ofNullable(clazz.cast(unusedAccessFindingsStatistics()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #externalAccessFindingsStatistics()} initialized to the given value.
     *
     * <p>
     * The aggregate statistics for an external access analyzer.
     * </p>
     * 
     * @param externalAccessFindingsStatistics
     *        The aggregate statistics for an external access analyzer.
     */
    public static FindingsStatistics fromExternalAccessFindingsStatistics(
            ExternalAccessFindingsStatistics externalAccessFindingsStatistics) {
        return builder().externalAccessFindingsStatistics(externalAccessFindingsStatistics).build();
    }

    /**
     * Create an instance of this class with {@link #externalAccessFindingsStatistics()} initialized to the given value.
     *
     * <p>
     * The aggregate statistics for an external access analyzer.
     * </p>
     * 
     * @param externalAccessFindingsStatistics
     *        The aggregate statistics for an external access analyzer.
     */
    public static FindingsStatistics fromExternalAccessFindingsStatistics(
            Consumer<ExternalAccessFindingsStatistics.Builder> externalAccessFindingsStatistics) {
        ExternalAccessFindingsStatistics.Builder builder = ExternalAccessFindingsStatistics.builder();
        externalAccessFindingsStatistics.accept(builder);
        return fromExternalAccessFindingsStatistics(builder.build());
    }

    /**
     * Create an instance of this class with {@link #internalAccessFindingsStatistics()} initialized to the given value.
     *
     * <p>
     * The aggregate statistics for an internal access analyzer. This includes information about active, archived, and
     * resolved findings related to internal access within your Amazon Web Services organization or account.
     * </p>
     * 
     * @param internalAccessFindingsStatistics
     *        The aggregate statistics for an internal access analyzer. This includes information about active,
     *        archived, and resolved findings related to internal access within your Amazon Web Services organization or
     *        account.
     */
    public static FindingsStatistics fromInternalAccessFindingsStatistics(
            InternalAccessFindingsStatistics internalAccessFindingsStatistics) {
        return builder().internalAccessFindingsStatistics(internalAccessFindingsStatistics).build();
    }

    /**
     * Create an instance of this class with {@link #internalAccessFindingsStatistics()} initialized to the given value.
     *
     * <p>
     * The aggregate statistics for an internal access analyzer. This includes information about active, archived, and
     * resolved findings related to internal access within your Amazon Web Services organization or account.
     * </p>
     * 
     * @param internalAccessFindingsStatistics
     *        The aggregate statistics for an internal access analyzer. This includes information about active,
     *        archived, and resolved findings related to internal access within your Amazon Web Services organization or
     *        account.
     */
    public static FindingsStatistics fromInternalAccessFindingsStatistics(
            Consumer<InternalAccessFindingsStatistics.Builder> internalAccessFindingsStatistics) {
        InternalAccessFindingsStatistics.Builder builder = InternalAccessFindingsStatistics.builder();
        internalAccessFindingsStatistics.accept(builder);
        return fromInternalAccessFindingsStatistics(builder.build());
    }

    /**
     * Create an instance of this class with {@link #unusedAccessFindingsStatistics()} initialized to the given value.
     *
     * <p>
     * The aggregate statistics for an unused access analyzer.
     * </p>
     * 
     * @param unusedAccessFindingsStatistics
     *        The aggregate statistics for an unused access analyzer.
     */
    public static FindingsStatistics fromUnusedAccessFindingsStatistics(
            UnusedAccessFindingsStatistics unusedAccessFindingsStatistics) {
        return builder().unusedAccessFindingsStatistics(unusedAccessFindingsStatistics).build();
    }

    /**
     * Create an instance of this class with {@link #unusedAccessFindingsStatistics()} initialized to the given value.
     *
     * <p>
     * The aggregate statistics for an unused access analyzer.
     * </p>
     * 
     * @param unusedAccessFindingsStatistics
     *        The aggregate statistics for an unused access analyzer.
     */
    public static FindingsStatistics fromUnusedAccessFindingsStatistics(
            Consumer<UnusedAccessFindingsStatistics.Builder> unusedAccessFindingsStatistics) {
        UnusedAccessFindingsStatistics.Builder builder = UnusedAccessFindingsStatistics.builder();
        unusedAccessFindingsStatistics.accept(builder);
        return fromUnusedAccessFindingsStatistics(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("externalAccessFindingsStatistics", EXTERNAL_ACCESS_FINDINGS_STATISTICS_FIELD);
        map.put("internalAccessFindingsStatistics", INTERNAL_ACCESS_FINDINGS_STATISTICS_FIELD);
        map.put("unusedAccessFindingsStatistics", UNUSED_ACCESS_FINDINGS_STATISTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingsStatistics, T> g) {
        return obj -> g.apply((FindingsStatistics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingsStatistics> {
        /**
         * <p>
         * The aggregate statistics for an external access analyzer.
         * </p>
         * 
         * @param externalAccessFindingsStatistics
         *        The aggregate statistics for an external access analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalAccessFindingsStatistics(ExternalAccessFindingsStatistics externalAccessFindingsStatistics);

        /**
         * <p>
         * The aggregate statistics for an external access analyzer.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExternalAccessFindingsStatistics.Builder}
         * avoiding the need to create one manually via {@link ExternalAccessFindingsStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExternalAccessFindingsStatistics.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #externalAccessFindingsStatistics(ExternalAccessFindingsStatistics)}.
         * 
         * @param externalAccessFindingsStatistics
         *        a consumer that will call methods on {@link ExternalAccessFindingsStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #externalAccessFindingsStatistics(ExternalAccessFindingsStatistics)
         */
        default Builder externalAccessFindingsStatistics(
                Consumer<ExternalAccessFindingsStatistics.Builder> externalAccessFindingsStatistics) {
            return externalAccessFindingsStatistics(ExternalAccessFindingsStatistics.builder()
                    .applyMutation(externalAccessFindingsStatistics).build());
        }

        /**
         * <p>
         * The aggregate statistics for an internal access analyzer. This includes information about active, archived,
         * and resolved findings related to internal access within your Amazon Web Services organization or account.
         * </p>
         * 
         * @param internalAccessFindingsStatistics
         *        The aggregate statistics for an internal access analyzer. This includes information about active,
         *        archived, and resolved findings related to internal access within your Amazon Web Services
         *        organization or account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internalAccessFindingsStatistics(InternalAccessFindingsStatistics internalAccessFindingsStatistics);

        /**
         * <p>
         * The aggregate statistics for an internal access analyzer. This includes information about active, archived,
         * and resolved findings related to internal access within your Amazon Web Services organization or account.
         * </p>
         * This is a convenience method that creates an instance of the {@link InternalAccessFindingsStatistics.Builder}
         * avoiding the need to create one manually via {@link InternalAccessFindingsStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InternalAccessFindingsStatistics.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #internalAccessFindingsStatistics(InternalAccessFindingsStatistics)}.
         * 
         * @param internalAccessFindingsStatistics
         *        a consumer that will call methods on {@link InternalAccessFindingsStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #internalAccessFindingsStatistics(InternalAccessFindingsStatistics)
         */
        default Builder internalAccessFindingsStatistics(
                Consumer<InternalAccessFindingsStatistics.Builder> internalAccessFindingsStatistics) {
            return internalAccessFindingsStatistics(InternalAccessFindingsStatistics.builder()
                    .applyMutation(internalAccessFindingsStatistics).build());
        }

        /**
         * <p>
         * The aggregate statistics for an unused access analyzer.
         * </p>
         * 
         * @param unusedAccessFindingsStatistics
         *        The aggregate statistics for an unused access analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedAccessFindingsStatistics(UnusedAccessFindingsStatistics unusedAccessFindingsStatistics);

        /**
         * <p>
         * The aggregate statistics for an unused access analyzer.
         * </p>
         * This is a convenience method that creates an instance of the {@link UnusedAccessFindingsStatistics.Builder}
         * avoiding the need to create one manually via {@link UnusedAccessFindingsStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnusedAccessFindingsStatistics.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #unusedAccessFindingsStatistics(UnusedAccessFindingsStatistics)}.
         * 
         * @param unusedAccessFindingsStatistics
         *        a consumer that will call methods on {@link UnusedAccessFindingsStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unusedAccessFindingsStatistics(UnusedAccessFindingsStatistics)
         */
        default Builder unusedAccessFindingsStatistics(
                Consumer<UnusedAccessFindingsStatistics.Builder> unusedAccessFindingsStatistics) {
            return unusedAccessFindingsStatistics(UnusedAccessFindingsStatistics.builder()
                    .applyMutation(unusedAccessFindingsStatistics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ExternalAccessFindingsStatistics externalAccessFindingsStatistics;

        private InternalAccessFindingsStatistics internalAccessFindingsStatistics;

        private UnusedAccessFindingsStatistics unusedAccessFindingsStatistics;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FindingsStatistics model) {
            externalAccessFindingsStatistics(model.externalAccessFindingsStatistics);
            internalAccessFindingsStatistics(model.internalAccessFindingsStatistics);
            unusedAccessFindingsStatistics(model.unusedAccessFindingsStatistics);
        }

        public final ExternalAccessFindingsStatistics.Builder getExternalAccessFindingsStatistics() {
            return externalAccessFindingsStatistics != null ? externalAccessFindingsStatistics.toBuilder() : null;
        }

        public final void setExternalAccessFindingsStatistics(
                ExternalAccessFindingsStatistics.BuilderImpl externalAccessFindingsStatistics) {
            Object oldValue = this.externalAccessFindingsStatistics;
            this.externalAccessFindingsStatistics = externalAccessFindingsStatistics != null ? externalAccessFindingsStatistics
                    .build() : null;
            handleUnionValueChange(Type.EXTERNAL_ACCESS_FINDINGS_STATISTICS, oldValue, this.externalAccessFindingsStatistics);
        }

        @Override
        public final Builder externalAccessFindingsStatistics(ExternalAccessFindingsStatistics externalAccessFindingsStatistics) {
            Object oldValue = this.externalAccessFindingsStatistics;
            this.externalAccessFindingsStatistics = externalAccessFindingsStatistics;
            handleUnionValueChange(Type.EXTERNAL_ACCESS_FINDINGS_STATISTICS, oldValue, this.externalAccessFindingsStatistics);
            return this;
        }

        public final InternalAccessFindingsStatistics.Builder getInternalAccessFindingsStatistics() {
            return internalAccessFindingsStatistics != null ? internalAccessFindingsStatistics.toBuilder() : null;
        }

        public final void setInternalAccessFindingsStatistics(
                InternalAccessFindingsStatistics.BuilderImpl internalAccessFindingsStatistics) {
            Object oldValue = this.internalAccessFindingsStatistics;
            this.internalAccessFindingsStatistics = internalAccessFindingsStatistics != null ? internalAccessFindingsStatistics
                    .build() : null;
            handleUnionValueChange(Type.INTERNAL_ACCESS_FINDINGS_STATISTICS, oldValue, this.internalAccessFindingsStatistics);
        }

        @Override
        public final Builder internalAccessFindingsStatistics(InternalAccessFindingsStatistics internalAccessFindingsStatistics) {
            Object oldValue = this.internalAccessFindingsStatistics;
            this.internalAccessFindingsStatistics = internalAccessFindingsStatistics;
            handleUnionValueChange(Type.INTERNAL_ACCESS_FINDINGS_STATISTICS, oldValue, this.internalAccessFindingsStatistics);
            return this;
        }

        public final UnusedAccessFindingsStatistics.Builder getUnusedAccessFindingsStatistics() {
            return unusedAccessFindingsStatistics != null ? unusedAccessFindingsStatistics.toBuilder() : null;
        }

        public final void setUnusedAccessFindingsStatistics(
                UnusedAccessFindingsStatistics.BuilderImpl unusedAccessFindingsStatistics) {
            Object oldValue = this.unusedAccessFindingsStatistics;
            this.unusedAccessFindingsStatistics = unusedAccessFindingsStatistics != null ? unusedAccessFindingsStatistics.build()
                    : null;
            handleUnionValueChange(Type.UNUSED_ACCESS_FINDINGS_STATISTICS, oldValue, this.unusedAccessFindingsStatistics);
        }

        @Override
        public final Builder unusedAccessFindingsStatistics(UnusedAccessFindingsStatistics unusedAccessFindingsStatistics) {
            Object oldValue = this.unusedAccessFindingsStatistics;
            this.unusedAccessFindingsStatistics = unusedAccessFindingsStatistics;
            handleUnionValueChange(Type.UNUSED_ACCESS_FINDINGS_STATISTICS, oldValue, this.unusedAccessFindingsStatistics);
            return this;
        }

        @Override
        public FindingsStatistics build() {
            return new FindingsStatistics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FindingsStatistics#type()
     */
    public enum Type {
        EXTERNAL_ACCESS_FINDINGS_STATISTICS,

        INTERNAL_ACCESS_FINDINGS_STATISTICS,

        UNUSED_ACCESS_FINDINGS_STATISTICS,

        UNKNOWN_TO_SDK_VERSION
    }
}
