/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingSummaryV2 implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingSummaryV2.Builder, FindingSummaryV2> {
    private static final SdkField<Instant> ANALYZED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("analyzedAt")
            .getter(getter(FindingSummaryV2::analyzedAt))
            .setter(setter(Builder::analyzedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(FindingSummaryV2::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(FindingSummaryV2::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(FindingSummaryV2::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resource").getter(getter(FindingSummaryV2::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(FindingSummaryV2::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceOwnerAccount").getter(getter(FindingSummaryV2::resourceOwnerAccount))
            .setter(setter(Builder::resourceOwnerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwnerAccount").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(FindingSummaryV2::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(FindingSummaryV2::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> FINDING_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("findingType").getter(getter(FindingSummaryV2::findingTypeAsString)).setter(setter(Builder::findingType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZED_AT_FIELD,
            CREATED_AT_FIELD, ERROR_FIELD, ID_FIELD, RESOURCE_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_OWNER_ACCOUNT_FIELD,
            STATUS_FIELD, UPDATED_AT_FIELD, FINDING_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant analyzedAt;

    private final Instant createdAt;

    private final String error;

    private final String id;

    private final String resource;

    private final String resourceType;

    private final String resourceOwnerAccount;

    private final String status;

    private final Instant updatedAt;

    private final String findingType;

    private FindingSummaryV2(BuilderImpl builder) {
        this.analyzedAt = builder.analyzedAt;
        this.createdAt = builder.createdAt;
        this.error = builder.error;
        this.id = builder.id;
        this.resource = builder.resource;
        this.resourceType = builder.resourceType;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
        this.findingType = builder.findingType;
    }

    /**
     * <p>
     * The time at which the resource-based policy or IAM entity that generated the finding was analyzed.
     * </p>
     * 
     * @return The time at which the resource-based policy or IAM entity that generated the finding was analyzed.
     */
    public final Instant analyzedAt() {
        return analyzedAt;
    }

    /**
     * <p>
     * The time at which the finding was created.
     * </p>
     * 
     * @return The time at which the finding was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The error that resulted in an Error finding.
     * </p>
     * 
     * @return The error that resulted in an Error finding.
     */
    public final String error() {
        return error;
    }

    /**
     * <p>
     * The ID of the finding.
     * </p>
     * 
     * @return The ID of the finding.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The resource that the external principal has access to.
     * </p>
     * 
     * @return The resource that the external principal has access to.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * The type of the resource that the external principal has access to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource that the external principal has access to.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the resource that the external principal has access to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource that the external principal has access to.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The Amazon Web Services account ID that owns the resource.
     * </p>
     * 
     * @return The Amazon Web Services account ID that owns the resource.
     */
    public final String resourceOwnerAccount() {
        return resourceOwnerAccount;
    }

    /**
     * <p>
     * The status of the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FindingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the finding.
     * @see FindingStatus
     */
    public final FindingStatus status() {
        return FindingStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FindingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the finding.
     * @see FindingStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time at which the finding was most recently updated.
     * </p>
     * 
     * @return The time at which the finding was most recently updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The type of the access finding. For external access analyzers, the type is <code>ExternalAccess</code>. For
     * unused access analyzers, the type can be <code>UnusedIAMRole</code>, <code>UnusedIAMUserAccessKey</code>,
     * <code>UnusedIAMUserPassword</code>, or <code>UnusedPermission</code>. For internal access analyzers, the type is
     * <code>InternalAccess</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #findingType} will
     * return {@link FindingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #findingTypeAsString}.
     * </p>
     * 
     * @return The type of the access finding. For external access analyzers, the type is <code>ExternalAccess</code>.
     *         For unused access analyzers, the type can be <code>UnusedIAMRole</code>,
     *         <code>UnusedIAMUserAccessKey</code>, <code>UnusedIAMUserPassword</code>, or <code>UnusedPermission</code>
     *         . For internal access analyzers, the type is <code>InternalAccess</code>.
     * @see FindingType
     */
    public final FindingType findingType() {
        return FindingType.fromValue(findingType);
    }

    /**
     * <p>
     * The type of the access finding. For external access analyzers, the type is <code>ExternalAccess</code>. For
     * unused access analyzers, the type can be <code>UnusedIAMRole</code>, <code>UnusedIAMUserAccessKey</code>,
     * <code>UnusedIAMUserPassword</code>, or <code>UnusedPermission</code>. For internal access analyzers, the type is
     * <code>InternalAccess</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #findingType} will
     * return {@link FindingType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #findingTypeAsString}.
     * </p>
     * 
     * @return The type of the access finding. For external access analyzers, the type is <code>ExternalAccess</code>.
     *         For unused access analyzers, the type can be <code>UnusedIAMRole</code>,
     *         <code>UnusedIAMUserAccessKey</code>, <code>UnusedIAMUserPassword</code>, or <code>UnusedPermission</code>
     *         . For internal access analyzers, the type is <code>InternalAccess</code>.
     * @see FindingType
     */
    public final String findingTypeAsString() {
        return findingType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(analyzedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(findingTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingSummaryV2)) {
            return false;
        }
        FindingSummaryV2 other = (FindingSummaryV2) obj;
        return Objects.equals(analyzedAt(), other.analyzedAt()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(error(), other.error()) && Objects.equals(id(), other.id())
                && Objects.equals(resource(), other.resource())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceOwnerAccount(), other.resourceOwnerAccount())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(findingTypeAsString(), other.findingTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingSummaryV2").add("AnalyzedAt", analyzedAt()).add("CreatedAt", createdAt())
                .add("Error", error()).add("Id", id()).add("Resource", resource()).add("ResourceType", resourceTypeAsString())
                .add("ResourceOwnerAccount", resourceOwnerAccount()).add("Status", statusAsString())
                .add("UpdatedAt", updatedAt()).add("FindingType", findingTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analyzedAt":
            return Optional.ofNullable(clazz.cast(analyzedAt()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "resourceOwnerAccount":
            return Optional.ofNullable(clazz.cast(resourceOwnerAccount()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "findingType":
            return Optional.ofNullable(clazz.cast(findingTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("analyzedAt", ANALYZED_AT_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("id", ID_FIELD);
        map.put("resource", RESOURCE_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("resourceOwnerAccount", RESOURCE_OWNER_ACCOUNT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("findingType", FINDING_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingSummaryV2, T> g) {
        return obj -> g.apply((FindingSummaryV2) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingSummaryV2> {
        /**
         * <p>
         * The time at which the resource-based policy or IAM entity that generated the finding was analyzed.
         * </p>
         * 
         * @param analyzedAt
         *        The time at which the resource-based policy or IAM entity that generated the finding was analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzedAt(Instant analyzedAt);

        /**
         * <p>
         * The time at which the finding was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the finding was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The error that resulted in an Error finding.
         * </p>
         * 
         * @param error
         *        The error that resulted in an Error finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * The ID of the finding.
         * </p>
         * 
         * @param id
         *        The ID of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The resource that the external principal has access to.
         * </p>
         * 
         * @param resource
         *        The resource that the external principal has access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * The type of the resource that the external principal has access to.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource that the external principal has access to.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the resource that the external principal has access to.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource that the external principal has access to.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The Amazon Web Services account ID that owns the resource.
         * </p>
         * 
         * @param resourceOwnerAccount
         *        The Amazon Web Services account ID that owns the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwnerAccount(String resourceOwnerAccount);

        /**
         * <p>
         * The status of the finding.
         * </p>
         * 
         * @param status
         *        The status of the finding.
         * @see FindingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the finding.
         * </p>
         * 
         * @param status
         *        The status of the finding.
         * @see FindingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingStatus
         */
        Builder status(FindingStatus status);

        /**
         * <p>
         * The time at which the finding was most recently updated.
         * </p>
         * 
         * @param updatedAt
         *        The time at which the finding was most recently updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The type of the access finding. For external access analyzers, the type is <code>ExternalAccess</code>. For
         * unused access analyzers, the type can be <code>UnusedIAMRole</code>, <code>UnusedIAMUserAccessKey</code>,
         * <code>UnusedIAMUserPassword</code>, or <code>UnusedPermission</code>. For internal access analyzers, the type
         * is <code>InternalAccess</code>.
         * </p>
         * 
         * @param findingType
         *        The type of the access finding. For external access analyzers, the type is <code>ExternalAccess</code>
         *        . For unused access analyzers, the type can be <code>UnusedIAMRole</code>,
         *        <code>UnusedIAMUserAccessKey</code>, <code>UnusedIAMUserPassword</code>, or
         *        <code>UnusedPermission</code>. For internal access analyzers, the type is <code>InternalAccess</code>.
         * @see FindingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingType
         */
        Builder findingType(String findingType);

        /**
         * <p>
         * The type of the access finding. For external access analyzers, the type is <code>ExternalAccess</code>. For
         * unused access analyzers, the type can be <code>UnusedIAMRole</code>, <code>UnusedIAMUserAccessKey</code>,
         * <code>UnusedIAMUserPassword</code>, or <code>UnusedPermission</code>. For internal access analyzers, the type
         * is <code>InternalAccess</code>.
         * </p>
         * 
         * @param findingType
         *        The type of the access finding. For external access analyzers, the type is <code>ExternalAccess</code>
         *        . For unused access analyzers, the type can be <code>UnusedIAMRole</code>,
         *        <code>UnusedIAMUserAccessKey</code>, <code>UnusedIAMUserPassword</code>, or
         *        <code>UnusedPermission</code>. For internal access analyzers, the type is <code>InternalAccess</code>.
         * @see FindingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingType
         */
        Builder findingType(FindingType findingType);
    }

    static final class BuilderImpl implements Builder {
        private Instant analyzedAt;

        private Instant createdAt;

        private String error;

        private String id;

        private String resource;

        private String resourceType;

        private String resourceOwnerAccount;

        private String status;

        private Instant updatedAt;

        private String findingType;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingSummaryV2 model) {
            analyzedAt(model.analyzedAt);
            createdAt(model.createdAt);
            error(model.error);
            id(model.id);
            resource(model.resource);
            resourceType(model.resourceType);
            resourceOwnerAccount(model.resourceOwnerAccount);
            status(model.status);
            updatedAt(model.updatedAt);
            findingType(model.findingType);
        }

        public final Instant getAnalyzedAt() {
            return analyzedAt;
        }

        public final void setAnalyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
        }

        @Override
        public final Builder analyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceOwnerAccount() {
            return resourceOwnerAccount;
        }

        public final void setResourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
        }

        @Override
        public final Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FindingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getFindingType() {
            return findingType;
        }

        public final void setFindingType(String findingType) {
            this.findingType = findingType;
        }

        @Override
        public final Builder findingType(String findingType) {
            this.findingType = findingType;
            return this;
        }

        @Override
        public final Builder findingType(FindingType findingType) {
            this.findingType(findingType == null ? null : findingType.toString());
            return this;
        }

        @Override
        public FindingSummaryV2 build() {
            return new FindingSummaryV2(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
