/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the findings for an Amazon Web Services account in an organization unused access analyzer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FindingAggregationAccountDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<FindingAggregationAccountDetails.Builder, FindingAggregationAccountDetails> {
    private static final SdkField<String> ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("account")
            .getter(getter(FindingAggregationAccountDetails::account)).setter(setter(Builder::account))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("account").build()).build();

    private static final SdkField<Integer> NUMBER_OF_ACTIVE_FINDINGS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("numberOfActiveFindings").getter(getter(FindingAggregationAccountDetails::numberOfActiveFindings))
            .setter(setter(Builder::numberOfActiveFindings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfActiveFindings").build())
            .build();

    private static final SdkField<Map<String, Integer>> DETAILS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("details")
            .getter(getter(FindingAggregationAccountDetails::details))
            .setter(setter(Builder::details))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD,
            NUMBER_OF_ACTIVE_FINDINGS_FIELD, DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String account;

    private final Integer numberOfActiveFindings;

    private final Map<String, Integer> details;

    private FindingAggregationAccountDetails(BuilderImpl builder) {
        this.account = builder.account;
        this.numberOfActiveFindings = builder.numberOfActiveFindings;
        this.details = builder.details;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account for which unused access finding details are provided.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account for which unused access finding details are provided.
     */
    public final String account() {
        return account;
    }

    /**
     * <p>
     * The number of active unused access findings for the specified Amazon Web Services account.
     * </p>
     * 
     * @return The number of active unused access findings for the specified Amazon Web Services account.
     */
    public final Integer numberOfActiveFindings() {
        return numberOfActiveFindings;
    }

    /**
     * For responses, this returns true if the service returned a value for the Details property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDetails() {
        return details != null && !(details instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Provides the number of active findings for each type of unused access for the specified Amazon Web Services
     * account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDetails} method.
     * </p>
     * 
     * @return Provides the number of active findings for each type of unused access for the specified Amazon Web
     *         Services account.
     */
    public final Map<String, Integer> details() {
        return details;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(account());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfActiveFindings());
        hashCode = 31 * hashCode + Objects.hashCode(hasDetails() ? details() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingAggregationAccountDetails)) {
            return false;
        }
        FindingAggregationAccountDetails other = (FindingAggregationAccountDetails) obj;
        return Objects.equals(account(), other.account())
                && Objects.equals(numberOfActiveFindings(), other.numberOfActiveFindings()) && hasDetails() == other.hasDetails()
                && Objects.equals(details(), other.details());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FindingAggregationAccountDetails").add("Account", account())
                .add("NumberOfActiveFindings", numberOfActiveFindings()).add("Details", hasDetails() ? details() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "account":
            return Optional.ofNullable(clazz.cast(account()));
        case "numberOfActiveFindings":
            return Optional.ofNullable(clazz.cast(numberOfActiveFindings()));
        case "details":
            return Optional.ofNullable(clazz.cast(details()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("account", ACCOUNT_FIELD);
        map.put("numberOfActiveFindings", NUMBER_OF_ACTIVE_FINDINGS_FIELD);
        map.put("details", DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingAggregationAccountDetails, T> g) {
        return obj -> g.apply((FindingAggregationAccountDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FindingAggregationAccountDetails> {
        /**
         * <p>
         * The ID of the Amazon Web Services account for which unused access finding details are provided.
         * </p>
         * 
         * @param account
         *        The ID of the Amazon Web Services account for which unused access finding details are provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(String account);

        /**
         * <p>
         * The number of active unused access findings for the specified Amazon Web Services account.
         * </p>
         * 
         * @param numberOfActiveFindings
         *        The number of active unused access findings for the specified Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfActiveFindings(Integer numberOfActiveFindings);

        /**
         * <p>
         * Provides the number of active findings for each type of unused access for the specified Amazon Web Services
         * account.
         * </p>
         * 
         * @param details
         *        Provides the number of active findings for each type of unused access for the specified Amazon Web
         *        Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder details(Map<String, Integer> details);
    }

    static final class BuilderImpl implements Builder {
        private String account;

        private Integer numberOfActiveFindings;

        private Map<String, Integer> details = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FindingAggregationAccountDetails model) {
            account(model.account);
            numberOfActiveFindings(model.numberOfActiveFindings);
            details(model.details);
        }

        public final String getAccount() {
            return account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final Integer getNumberOfActiveFindings() {
            return numberOfActiveFindings;
        }

        public final void setNumberOfActiveFindings(Integer numberOfActiveFindings) {
            this.numberOfActiveFindings = numberOfActiveFindings;
        }

        @Override
        public final Builder numberOfActiveFindings(Integer numberOfActiveFindings) {
            this.numberOfActiveFindings = numberOfActiveFindings;
            return this;
        }

        public final Map<String, Integer> getDetails() {
            if (details instanceof SdkAutoConstructMap) {
                return null;
            }
            return details;
        }

        public final void setDetails(Map<String, Integer> details) {
            this.details = FindingAggregationAccountDetailsMapCopier.copy(details);
        }

        @Override
        public final Builder details(Map<String, Integer> details) {
            this.details = FindingAggregationAccountDetailsMapCopier.copy(details);
            return this;
        }

        @Override
        public FindingAggregationAccountDetails build() {
            return new FindingAggregationAccountDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
