/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the configuration of an analyzer for an Amazon Web Services organization or account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyzerConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyzerConfiguration.Builder, AnalyzerConfiguration> {
    private static final SdkField<UnusedAccessConfiguration> UNUSED_ACCESS_FIELD = SdkField
            .<UnusedAccessConfiguration> builder(MarshallingType.SDK_POJO).memberName("unusedAccess")
            .getter(getter(AnalyzerConfiguration::unusedAccess)).setter(setter(Builder::unusedAccess))
            .constructor(UnusedAccessConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("unusedAccess").build()).build();

    private static final SdkField<InternalAccessConfiguration> INTERNAL_ACCESS_FIELD = SdkField
            .<InternalAccessConfiguration> builder(MarshallingType.SDK_POJO).memberName("internalAccess")
            .getter(getter(AnalyzerConfiguration::internalAccess)).setter(setter(Builder::internalAccess))
            .constructor(InternalAccessConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("internalAccess").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNUSED_ACCESS_FIELD,
            INTERNAL_ACCESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final UnusedAccessConfiguration unusedAccess;

    private final InternalAccessConfiguration internalAccess;

    private final Type type;

    private AnalyzerConfiguration(BuilderImpl builder) {
        this.unusedAccess = builder.unusedAccess;
        this.internalAccess = builder.internalAccess;
        this.type = builder.type;
    }

    /**
     * <p>
     * Specifies the configuration of an unused access analyzer for an Amazon Web Services organization or account.
     * </p>
     * 
     * @return Specifies the configuration of an unused access analyzer for an Amazon Web Services organization or
     *         account.
     */
    public final UnusedAccessConfiguration unusedAccess() {
        return unusedAccess;
    }

    /**
     * <p>
     * Specifies the configuration of an internal access analyzer for an Amazon Web Services organization or account.
     * This configuration determines how the analyzer evaluates access within your Amazon Web Services environment.
     * </p>
     * 
     * @return Specifies the configuration of an internal access analyzer for an Amazon Web Services organization or
     *         account. This configuration determines how the analyzer evaluates access within your Amazon Web Services
     *         environment.
     */
    public final InternalAccessConfiguration internalAccess() {
        return internalAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(unusedAccess());
        hashCode = 31 * hashCode + Objects.hashCode(internalAccess());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzerConfiguration)) {
            return false;
        }
        AnalyzerConfiguration other = (AnalyzerConfiguration) obj;
        return Objects.equals(unusedAccess(), other.unusedAccess()) && Objects.equals(internalAccess(), other.internalAccess());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyzerConfiguration").add("UnusedAccess", unusedAccess())
                .add("InternalAccess", internalAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "unusedAccess":
            return Optional.ofNullable(clazz.cast(unusedAccess()));
        case "internalAccess":
            return Optional.ofNullable(clazz.cast(internalAccess()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #unusedAccess()} initialized to the given value.
     *
     * <p>
     * Specifies the configuration of an unused access analyzer for an Amazon Web Services organization or account.
     * </p>
     * 
     * @param unusedAccess
     *        Specifies the configuration of an unused access analyzer for an Amazon Web Services organization or
     *        account.
     */
    public static AnalyzerConfiguration fromUnusedAccess(UnusedAccessConfiguration unusedAccess) {
        return builder().unusedAccess(unusedAccess).build();
    }

    /**
     * Create an instance of this class with {@link #unusedAccess()} initialized to the given value.
     *
     * <p>
     * Specifies the configuration of an unused access analyzer for an Amazon Web Services organization or account.
     * </p>
     * 
     * @param unusedAccess
     *        Specifies the configuration of an unused access analyzer for an Amazon Web Services organization or
     *        account.
     */
    public static AnalyzerConfiguration fromUnusedAccess(Consumer<UnusedAccessConfiguration.Builder> unusedAccess) {
        UnusedAccessConfiguration.Builder builder = UnusedAccessConfiguration.builder();
        unusedAccess.accept(builder);
        return fromUnusedAccess(builder.build());
    }

    /**
     * Create an instance of this class with {@link #internalAccess()} initialized to the given value.
     *
     * <p>
     * Specifies the configuration of an internal access analyzer for an Amazon Web Services organization or account.
     * This configuration determines how the analyzer evaluates access within your Amazon Web Services environment.
     * </p>
     * 
     * @param internalAccess
     *        Specifies the configuration of an internal access analyzer for an Amazon Web Services organization or
     *        account. This configuration determines how the analyzer evaluates access within your Amazon Web Services
     *        environment.
     */
    public static AnalyzerConfiguration fromInternalAccess(InternalAccessConfiguration internalAccess) {
        return builder().internalAccess(internalAccess).build();
    }

    /**
     * Create an instance of this class with {@link #internalAccess()} initialized to the given value.
     *
     * <p>
     * Specifies the configuration of an internal access analyzer for an Amazon Web Services organization or account.
     * This configuration determines how the analyzer evaluates access within your Amazon Web Services environment.
     * </p>
     * 
     * @param internalAccess
     *        Specifies the configuration of an internal access analyzer for an Amazon Web Services organization or
     *        account. This configuration determines how the analyzer evaluates access within your Amazon Web Services
     *        environment.
     */
    public static AnalyzerConfiguration fromInternalAccess(Consumer<InternalAccessConfiguration.Builder> internalAccess) {
        InternalAccessConfiguration.Builder builder = InternalAccessConfiguration.builder();
        internalAccess.accept(builder);
        return fromInternalAccess(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("unusedAccess", UNUSED_ACCESS_FIELD);
        map.put("internalAccess", INTERNAL_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyzerConfiguration, T> g) {
        return obj -> g.apply((AnalyzerConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyzerConfiguration> {
        /**
         * <p>
         * Specifies the configuration of an unused access analyzer for an Amazon Web Services organization or account.
         * </p>
         * 
         * @param unusedAccess
         *        Specifies the configuration of an unused access analyzer for an Amazon Web Services organization or
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unusedAccess(UnusedAccessConfiguration unusedAccess);

        /**
         * <p>
         * Specifies the configuration of an unused access analyzer for an Amazon Web Services organization or account.
         * </p>
         * This is a convenience method that creates an instance of the {@link UnusedAccessConfiguration.Builder}
         * avoiding the need to create one manually via {@link UnusedAccessConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UnusedAccessConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #unusedAccess(UnusedAccessConfiguration)}.
         * 
         * @param unusedAccess
         *        a consumer that will call methods on {@link UnusedAccessConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #unusedAccess(UnusedAccessConfiguration)
         */
        default Builder unusedAccess(Consumer<UnusedAccessConfiguration.Builder> unusedAccess) {
            return unusedAccess(UnusedAccessConfiguration.builder().applyMutation(unusedAccess).build());
        }

        /**
         * <p>
         * Specifies the configuration of an internal access analyzer for an Amazon Web Services organization or
         * account. This configuration determines how the analyzer evaluates access within your Amazon Web Services
         * environment.
         * </p>
         * 
         * @param internalAccess
         *        Specifies the configuration of an internal access analyzer for an Amazon Web Services organization or
         *        account. This configuration determines how the analyzer evaluates access within your Amazon Web
         *        Services environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internalAccess(InternalAccessConfiguration internalAccess);

        /**
         * <p>
         * Specifies the configuration of an internal access analyzer for an Amazon Web Services organization or
         * account. This configuration determines how the analyzer evaluates access within your Amazon Web Services
         * environment.
         * </p>
         * This is a convenience method that creates an instance of the {@link InternalAccessConfiguration.Builder}
         * avoiding the need to create one manually via {@link InternalAccessConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InternalAccessConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #internalAccess(InternalAccessConfiguration)}.
         * 
         * @param internalAccess
         *        a consumer that will call methods on {@link InternalAccessConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #internalAccess(InternalAccessConfiguration)
         */
        default Builder internalAccess(Consumer<InternalAccessConfiguration.Builder> internalAccess) {
            return internalAccess(InternalAccessConfiguration.builder().applyMutation(internalAccess).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private UnusedAccessConfiguration unusedAccess;

        private InternalAccessConfiguration internalAccess;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzerConfiguration model) {
            unusedAccess(model.unusedAccess);
            internalAccess(model.internalAccess);
        }

        public final UnusedAccessConfiguration.Builder getUnusedAccess() {
            return unusedAccess != null ? unusedAccess.toBuilder() : null;
        }

        public final void setUnusedAccess(UnusedAccessConfiguration.BuilderImpl unusedAccess) {
            Object oldValue = this.unusedAccess;
            this.unusedAccess = unusedAccess != null ? unusedAccess.build() : null;
            handleUnionValueChange(Type.UNUSED_ACCESS, oldValue, this.unusedAccess);
        }

        @Override
        public final Builder unusedAccess(UnusedAccessConfiguration unusedAccess) {
            Object oldValue = this.unusedAccess;
            this.unusedAccess = unusedAccess;
            handleUnionValueChange(Type.UNUSED_ACCESS, oldValue, this.unusedAccess);
            return this;
        }

        public final InternalAccessConfiguration.Builder getInternalAccess() {
            return internalAccess != null ? internalAccess.toBuilder() : null;
        }

        public final void setInternalAccess(InternalAccessConfiguration.BuilderImpl internalAccess) {
            Object oldValue = this.internalAccess;
            this.internalAccess = internalAccess != null ? internalAccess.build() : null;
            handleUnionValueChange(Type.INTERNAL_ACCESS, oldValue, this.internalAccess);
        }

        @Override
        public final Builder internalAccess(InternalAccessConfiguration internalAccess) {
            Object oldValue = this.internalAccess;
            this.internalAccess = internalAccess;
            handleUnionValueChange(Type.INTERNAL_ACCESS, oldValue, this.internalAccess);
            return this;
        }

        @Override
        public AnalyzerConfiguration build() {
            return new AnalyzerConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see AnalyzerConfiguration#type()
     */
    public enum Type {
        UNUSED_ACCESS,

        INTERNAL_ACCESS,

        UNKNOWN_TO_SDK_VERSION
    }
}
