/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.RecommendationError;
import software.amazon.awssdk.services.accessanalyzer.model.RecommendationType;
import software.amazon.awssdk.services.accessanalyzer.model.RecommendedStep;
import software.amazon.awssdk.services.accessanalyzer.model.RecommendedStepListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFindingRecommendationResponse
extends AccessAnalyzerResponse
implements ToCopyableBuilder<Builder, GetFindingRecommendationResponse> {
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(GetFindingRecommendationResponse.getter(GetFindingRecommendationResponse::startedAt)).setter(GetFindingRecommendationResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completedAt").getter(GetFindingRecommendationResponse.getter(GetFindingRecommendationResponse::completedAt)).setter(GetFindingRecommendationResponse.setter(Builder::completedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetFindingRecommendationResponse.getter(GetFindingRecommendationResponse::nextToken)).setter(GetFindingRecommendationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<RecommendationError> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("error").getter(GetFindingRecommendationResponse.getter(GetFindingRecommendationResponse::error)).setter(GetFindingRecommendationResponse.setter(Builder::error)).constructor(RecommendationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(GetFindingRecommendationResponse.getter(GetFindingRecommendationResponse::resourceArn)).setter(GetFindingRecommendationResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<List<RecommendedStep>> RECOMMENDED_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("recommendedSteps").getter(GetFindingRecommendationResponse.getter(GetFindingRecommendationResponse::recommendedSteps)).setter(GetFindingRecommendationResponse.setter(Builder::recommendedSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendedSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RecommendedStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECOMMENDATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recommendationType").getter(GetFindingRecommendationResponse.getter(GetFindingRecommendationResponse::recommendationTypeAsString)).setter(GetFindingRecommendationResponse.setter(Builder::recommendationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendationType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetFindingRecommendationResponse.getter(GetFindingRecommendationResponse::statusAsString)).setter(GetFindingRecommendationResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STARTED_AT_FIELD, COMPLETED_AT_FIELD, NEXT_TOKEN_FIELD, ERROR_FIELD, RESOURCE_ARN_FIELD, RECOMMENDED_STEPS_FIELD, RECOMMENDATION_TYPE_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFindingRecommendationResponse.memberNameToFieldInitializer();
    private final Instant startedAt;
    private final Instant completedAt;
    private final String nextToken;
    private final RecommendationError error;
    private final String resourceArn;
    private final List<RecommendedStep> recommendedSteps;
    private final String recommendationType;
    private final String status;

    private GetFindingRecommendationResponse(BuilderImpl builder) {
        super(builder);
        this.startedAt = builder.startedAt;
        this.completedAt = builder.completedAt;
        this.nextToken = builder.nextToken;
        this.error = builder.error;
        this.resourceArn = builder.resourceArn;
        this.recommendedSteps = builder.recommendedSteps;
        this.recommendationType = builder.recommendationType;
        this.status = builder.status;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant completedAt() {
        return this.completedAt;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final RecommendationError error() {
        return this.error;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final boolean hasRecommendedSteps() {
        return this.recommendedSteps != null && !(this.recommendedSteps instanceof SdkAutoConstructList);
    }

    public final List<RecommendedStep> recommendedSteps() {
        return this.recommendedSteps;
    }

    public final RecommendationType recommendationType() {
        return RecommendationType.fromValue(this.recommendationType);
    }

    public final String recommendationTypeAsString() {
        return this.recommendationType;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.completedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRecommendedSteps() ? this.recommendedSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingRecommendationResponse)) {
            return false;
        }
        GetFindingRecommendationResponse other = (GetFindingRecommendationResponse)((Object)obj);
        return Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.completedAt(), other.completedAt()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.resourceArn(), other.resourceArn()) && this.hasRecommendedSteps() == other.hasRecommendedSteps() && Objects.equals(this.recommendedSteps(), other.recommendedSteps()) && Objects.equals(this.recommendationTypeAsString(), other.recommendationTypeAsString()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetFindingRecommendationResponse").add("StartedAt", (Object)this.startedAt()).add("CompletedAt", (Object)this.completedAt()).add("NextToken", (Object)this.nextToken()).add("Error", (Object)this.error()).add("ResourceArn", (Object)this.resourceArn()).add("RecommendedSteps", this.hasRecommendedSteps() ? this.recommendedSteps() : null).add("RecommendationType", (Object)this.recommendationTypeAsString()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "completedAt": {
                return Optional.ofNullable(clazz.cast(this.completedAt()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "recommendedSteps": {
                return Optional.ofNullable(clazz.cast(this.recommendedSteps()));
            }
            case "recommendationType": {
                return Optional.ofNullable(clazz.cast(this.recommendationTypeAsString()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("completedAt", COMPLETED_AT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("recommendedSteps", RECOMMENDED_STEPS_FIELD);
        map.put("recommendationType", RECOMMENDATION_TYPE_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFindingRecommendationResponse, T> g) {
        return obj -> g.apply((GetFindingRecommendationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerResponse.BuilderImpl
    implements Builder {
        private Instant startedAt;
        private Instant completedAt;
        private String nextToken;
        private RecommendationError error;
        private String resourceArn;
        private List<RecommendedStep> recommendedSteps = DefaultSdkAutoConstructList.getInstance();
        private String recommendationType;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingRecommendationResponse model) {
            super(model);
            this.startedAt(model.startedAt);
            this.completedAt(model.completedAt);
            this.nextToken(model.nextToken);
            this.error(model.error);
            this.resourceArn(model.resourceArn);
            this.recommendedSteps(model.recommendedSteps);
            this.recommendationType(model.recommendationType);
            this.status(model.status);
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getCompletedAt() {
            return this.completedAt;
        }

        public final void setCompletedAt(Instant completedAt) {
            this.completedAt = completedAt;
        }

        @Override
        public final Builder completedAt(Instant completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final RecommendationError.Builder getError() {
            return this.error != null ? this.error.toBuilder() : null;
        }

        public final void setError(RecommendationError.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(RecommendationError error) {
            this.error = error;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final List<RecommendedStep.Builder> getRecommendedSteps() {
            List<RecommendedStep.Builder> result = RecommendedStepListCopier.copyToBuilder(this.recommendedSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecommendedSteps(Collection<RecommendedStep.BuilderImpl> recommendedSteps) {
            this.recommendedSteps = RecommendedStepListCopier.copyFromBuilder(recommendedSteps);
        }

        @Override
        public final Builder recommendedSteps(Collection<RecommendedStep> recommendedSteps) {
            this.recommendedSteps = RecommendedStepListCopier.copy(recommendedSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedSteps(RecommendedStep ... recommendedSteps) {
            this.recommendedSteps(Arrays.asList(recommendedSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recommendedSteps(Consumer<RecommendedStep.Builder> ... recommendedSteps) {
            this.recommendedSteps(Stream.of(recommendedSteps).map(c -> (RecommendedStep)((RecommendedStep.Builder)RecommendedStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRecommendationType() {
            return this.recommendationType;
        }

        public final void setRecommendationType(String recommendationType) {
            this.recommendationType = recommendationType;
        }

        @Override
        public final Builder recommendationType(String recommendationType) {
            this.recommendationType = recommendationType;
            return this;
        }

        @Override
        public final Builder recommendationType(RecommendationType recommendationType) {
            this.recommendationType(recommendationType == null ? null : recommendationType.toString());
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetFindingRecommendationResponse build() {
            return new GetFindingRecommendationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AccessAnalyzerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFindingRecommendationResponse> {
        public Builder startedAt(Instant var1);

        public Builder completedAt(Instant var1);

        public Builder nextToken(String var1);

        public Builder error(RecommendationError var1);

        default public Builder error(Consumer<RecommendationError.Builder> error) {
            return this.error((RecommendationError)((RecommendationError.Builder)RecommendationError.builder().applyMutation(error)).build());
        }

        public Builder resourceArn(String var1);

        public Builder recommendedSteps(Collection<RecommendedStep> var1);

        public Builder recommendedSteps(RecommendedStep ... var1);

        public Builder recommendedSteps(Consumer<RecommendedStep.Builder> ... var1);

        public Builder recommendationType(String var1);

        public Builder recommendationType(RecommendationType var1);

        public Builder status(String var1);

        public Builder status(Status var1);
    }
}

