/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.FindingAggregationAccountDetailsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingAggregationAccountDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingAggregationAccountDetails> {
    private static final SdkField<String> ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("account").getter(FindingAggregationAccountDetails.getter(FindingAggregationAccountDetails::account)).setter(FindingAggregationAccountDetails.setter(Builder::account)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("account").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_ACTIVE_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfActiveFindings").getter(FindingAggregationAccountDetails.getter(FindingAggregationAccountDetails::numberOfActiveFindings)).setter(FindingAggregationAccountDetails.setter(Builder::numberOfActiveFindings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfActiveFindings").build()}).build();
    private static final SdkField<Map<String, Integer>> DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("details").getter(FindingAggregationAccountDetails.getter(FindingAggregationAccountDetails::details)).setter(FindingAggregationAccountDetails.setter(Builder::details)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("details").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD, NUMBER_OF_ACTIVE_FINDINGS_FIELD, DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = FindingAggregationAccountDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String account;
    private final Integer numberOfActiveFindings;
    private final Map<String, Integer> details;

    private FindingAggregationAccountDetails(BuilderImpl builder) {
        this.account = builder.account;
        this.numberOfActiveFindings = builder.numberOfActiveFindings;
        this.details = builder.details;
    }

    public final String account() {
        return this.account;
    }

    public final Integer numberOfActiveFindings() {
        return this.numberOfActiveFindings;
    }

    public final boolean hasDetails() {
        return this.details != null && !(this.details instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> details() {
        return this.details;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.account());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfActiveFindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDetails() ? this.details() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingAggregationAccountDetails)) {
            return false;
        }
        FindingAggregationAccountDetails other = (FindingAggregationAccountDetails)obj;
        return Objects.equals(this.account(), other.account()) && Objects.equals(this.numberOfActiveFindings(), other.numberOfActiveFindings()) && this.hasDetails() == other.hasDetails() && Objects.equals(this.details(), other.details());
    }

    public final String toString() {
        return ToString.builder((String)"FindingAggregationAccountDetails").add("Account", (Object)this.account()).add("NumberOfActiveFindings", (Object)this.numberOfActiveFindings()).add("Details", this.hasDetails() ? this.details() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "account": {
                return Optional.ofNullable(clazz.cast(this.account()));
            }
            case "numberOfActiveFindings": {
                return Optional.ofNullable(clazz.cast(this.numberOfActiveFindings()));
            }
            case "details": {
                return Optional.ofNullable(clazz.cast(this.details()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("account", ACCOUNT_FIELD);
        map.put("numberOfActiveFindings", NUMBER_OF_ACTIVE_FINDINGS_FIELD);
        map.put("details", DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FindingAggregationAccountDetails, T> g) {
        return obj -> g.apply((FindingAggregationAccountDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String account;
        private Integer numberOfActiveFindings;
        private Map<String, Integer> details = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FindingAggregationAccountDetails model) {
            this.account(model.account);
            this.numberOfActiveFindings(model.numberOfActiveFindings);
            this.details(model.details);
        }

        public final String getAccount() {
            return this.account;
        }

        public final void setAccount(String account) {
            this.account = account;
        }

        @Override
        public final Builder account(String account) {
            this.account = account;
            return this;
        }

        public final Integer getNumberOfActiveFindings() {
            return this.numberOfActiveFindings;
        }

        public final void setNumberOfActiveFindings(Integer numberOfActiveFindings) {
            this.numberOfActiveFindings = numberOfActiveFindings;
        }

        @Override
        public final Builder numberOfActiveFindings(Integer numberOfActiveFindings) {
            this.numberOfActiveFindings = numberOfActiveFindings;
            return this;
        }

        public final Map<String, Integer> getDetails() {
            if (this.details instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.details;
        }

        public final void setDetails(Map<String, Integer> details) {
            this.details = FindingAggregationAccountDetailsMapCopier.copy(details);
        }

        @Override
        public final Builder details(Map<String, Integer> details) {
            this.details = FindingAggregationAccountDetailsMapCopier.copy(details);
            return this;
        }

        public FindingAggregationAccountDetails build() {
            return new FindingAggregationAccountDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingAggregationAccountDetails> {
        public Builder account(String var1);

        public Builder numberOfActiveFindings(Integer var1);

        public Builder details(Map<String, Integer> var1);
    }
}

