/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetArchiveRuleRequest
extends AccessAnalyzerRequest
implements ToCopyableBuilder<Builder, GetArchiveRuleRequest> {
    private static final SdkField<String> ANALYZER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analyzerName").getter(GetArchiveRuleRequest.getter(GetArchiveRuleRequest::analyzerName)).setter(GetArchiveRuleRequest.setter(Builder::analyzerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("analyzerName").build()}).build();
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleName").getter(GetArchiveRuleRequest.getter(GetArchiveRuleRequest::ruleName)).setter(GetArchiveRuleRequest.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("ruleName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_NAME_FIELD, RULE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetArchiveRuleRequest.memberNameToFieldInitializer();
    private final String analyzerName;
    private final String ruleName;

    private GetArchiveRuleRequest(BuilderImpl builder) {
        super(builder);
        this.analyzerName = builder.analyzerName;
        this.ruleName = builder.ruleName;
    }

    public final String analyzerName() {
        return this.analyzerName;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetArchiveRuleRequest)) {
            return false;
        }
        GetArchiveRuleRequest other = (GetArchiveRuleRequest)((Object)obj);
        return Objects.equals(this.analyzerName(), other.analyzerName()) && Objects.equals(this.ruleName(), other.ruleName());
    }

    public final String toString() {
        return ToString.builder((String)"GetArchiveRuleRequest").add("AnalyzerName", (Object)this.analyzerName()).add("RuleName", (Object)this.ruleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analyzerName": {
                return Optional.ofNullable(clazz.cast(this.analyzerName()));
            }
            case "ruleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("analyzerName", ANALYZER_NAME_FIELD);
        map.put("ruleName", RULE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetArchiveRuleRequest, T> g) {
        return obj -> g.apply((GetArchiveRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerRequest.BuilderImpl
    implements Builder {
        private String analyzerName;
        private String ruleName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetArchiveRuleRequest model) {
            super(model);
            this.analyzerName(model.analyzerName);
            this.ruleName(model.ruleName);
        }

        public final String getAnalyzerName() {
            return this.analyzerName;
        }

        public final void setAnalyzerName(String analyzerName) {
            this.analyzerName = analyzerName;
        }

        @Override
        public final Builder analyzerName(String analyzerName) {
            this.analyzerName = analyzerName;
            return this;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetArchiveRuleRequest build() {
            return new GetArchiveRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AccessAnalyzerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetArchiveRuleRequest> {
        public Builder analyzerName(String var1);

        public Builder ruleName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

