/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.AnalyzerConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.InlineArchiveRule;
import software.amazon.awssdk.services.accessanalyzer.model.InlineArchiveRulesListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.TagsMapCopier;
import software.amazon.awssdk.services.accessanalyzer.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAnalyzerRequest
extends AccessAnalyzerRequest
implements ToCopyableBuilder<Builder, CreateAnalyzerRequest> {
    private static final SdkField<String> ANALYZER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analyzerName").getter(CreateAnalyzerRequest.getter(CreateAnalyzerRequest::analyzerName)).setter(CreateAnalyzerRequest.setter(Builder::analyzerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzerName").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateAnalyzerRequest.getter(CreateAnalyzerRequest::typeAsString)).setter(CreateAnalyzerRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<List<InlineArchiveRule>> ARCHIVE_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("archiveRules").getter(CreateAnalyzerRequest.getter(CreateAnalyzerRequest::archiveRules)).setter(CreateAnalyzerRequest.setter(Builder::archiveRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveRules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InlineArchiveRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAnalyzerRequest.getter(CreateAnalyzerRequest::tags)).setter(CreateAnalyzerRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAnalyzerRequest.getter(CreateAnalyzerRequest::clientToken)).setter(CreateAnalyzerRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<AnalyzerConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(CreateAnalyzerRequest.getter(CreateAnalyzerRequest::configuration)).setter(CreateAnalyzerRequest.setter(Builder::configuration)).constructor(AnalyzerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_NAME_FIELD, TYPE_FIELD, ARCHIVE_RULES_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD, CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAnalyzerRequest.memberNameToFieldInitializer();
    private final String analyzerName;
    private final String type;
    private final List<InlineArchiveRule> archiveRules;
    private final Map<String, String> tags;
    private final String clientToken;
    private final AnalyzerConfiguration configuration;

    private CreateAnalyzerRequest(BuilderImpl builder) {
        super(builder);
        this.analyzerName = builder.analyzerName;
        this.type = builder.type;
        this.archiveRules = builder.archiveRules;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
        this.configuration = builder.configuration;
    }

    public final String analyzerName() {
        return this.analyzerName;
    }

    public final Type type() {
        return Type.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasArchiveRules() {
        return this.archiveRules != null && !(this.archiveRules instanceof SdkAutoConstructList);
    }

    public final List<InlineArchiveRule> archiveRules() {
        return this.archiveRules;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final AnalyzerConfiguration configuration() {
        return this.configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArchiveRules() ? this.archiveRules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnalyzerRequest)) {
            return false;
        }
        CreateAnalyzerRequest other = (CreateAnalyzerRequest)((Object)obj);
        return Objects.equals(this.analyzerName(), other.analyzerName()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasArchiveRules() == other.hasArchiveRules() && Objects.equals(this.archiveRules(), other.archiveRules()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.configuration(), other.configuration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAnalyzerRequest").add("AnalyzerName", (Object)this.analyzerName()).add("Type", (Object)this.typeAsString()).add("ArchiveRules", this.hasArchiveRules() ? this.archiveRules() : null).add("Tags", this.hasTags() ? this.tags() : null).add("ClientToken", (Object)this.clientToken()).add("Configuration", (Object)this.configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analyzerName": {
                return Optional.ofNullable(clazz.cast(this.analyzerName()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "archiveRules": {
                return Optional.ofNullable(clazz.cast(this.archiveRules()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("analyzerName", ANALYZER_NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("archiveRules", ARCHIVE_RULES_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAnalyzerRequest, T> g) {
        return obj -> g.apply((CreateAnalyzerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerRequest.BuilderImpl
    implements Builder {
        private String analyzerName;
        private String type;
        private List<InlineArchiveRule> archiveRules = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;
        private AnalyzerConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnalyzerRequest model) {
            super(model);
            this.analyzerName(model.analyzerName);
            this.type(model.type);
            this.archiveRules(model.archiveRules);
            this.tags(model.tags);
            this.clientToken(model.clientToken);
            this.configuration(model.configuration);
        }

        public final String getAnalyzerName() {
            return this.analyzerName;
        }

        public final void setAnalyzerName(String analyzerName) {
            this.analyzerName = analyzerName;
        }

        @Override
        public final Builder analyzerName(String analyzerName) {
            this.analyzerName = analyzerName;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final List<InlineArchiveRule.Builder> getArchiveRules() {
            List<InlineArchiveRule.Builder> result = InlineArchiveRulesListCopier.copyToBuilder(this.archiveRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArchiveRules(Collection<InlineArchiveRule.BuilderImpl> archiveRules) {
            this.archiveRules = InlineArchiveRulesListCopier.copyFromBuilder(archiveRules);
        }

        @Override
        public final Builder archiveRules(Collection<InlineArchiveRule> archiveRules) {
            this.archiveRules = InlineArchiveRulesListCopier.copy(archiveRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder archiveRules(InlineArchiveRule ... archiveRules) {
            this.archiveRules(Arrays.asList(archiveRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder archiveRules(Consumer<InlineArchiveRule.Builder> ... archiveRules) {
            this.archiveRules(Stream.of(archiveRules).map(c -> (InlineArchiveRule)((InlineArchiveRule.Builder)InlineArchiveRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final AnalyzerConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(AnalyzerConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AnalyzerConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnalyzerRequest build() {
            return new CreateAnalyzerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AccessAnalyzerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAnalyzerRequest> {
        public Builder analyzerName(String var1);

        public Builder type(String var1);

        public Builder type(Type var1);

        public Builder archiveRules(Collection<InlineArchiveRule> var1);

        public Builder archiveRules(InlineArchiveRule ... var1);

        public Builder archiveRules(Consumer<InlineArchiveRule.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder configuration(AnalyzerConfiguration var1);

        default public Builder configuration(Consumer<AnalyzerConfiguration.Builder> configuration) {
            return this.configuration((AnalyzerConfiguration)((AnalyzerConfiguration.Builder)AnalyzerConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

