/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.AccessCheckPolicyType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CheckNoNewAccessRequest
extends AccessAnalyzerRequest
implements ToCopyableBuilder<Builder, CheckNoNewAccessRequest> {
    private static final SdkField<String> NEW_POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("newPolicyDocument").getter(CheckNoNewAccessRequest.getter(CheckNoNewAccessRequest::newPolicyDocument)).setter(CheckNoNewAccessRequest.setter(Builder::newPolicyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newPolicyDocument").build()}).build();
    private static final SdkField<String> EXISTING_POLICY_DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("existingPolicyDocument").getter(CheckNoNewAccessRequest.getter(CheckNoNewAccessRequest::existingPolicyDocument)).setter(CheckNoNewAccessRequest.setter(Builder::existingPolicyDocument)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("existingPolicyDocument").build()}).build();
    private static final SdkField<String> POLICY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("policyType").getter(CheckNoNewAccessRequest.getter(CheckNoNewAccessRequest::policyTypeAsString)).setter(CheckNoNewAccessRequest.setter(Builder::policyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEW_POLICY_DOCUMENT_FIELD, EXISTING_POLICY_DOCUMENT_FIELD, POLICY_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("newPolicyDocument", NEW_POLICY_DOCUMENT_FIELD);
            this.put("existingPolicyDocument", EXISTING_POLICY_DOCUMENT_FIELD);
            this.put("policyType", POLICY_TYPE_FIELD);
        }
    });
    private final String newPolicyDocument;
    private final String existingPolicyDocument;
    private final String policyType;

    private CheckNoNewAccessRequest(BuilderImpl builder) {
        super(builder);
        this.newPolicyDocument = builder.newPolicyDocument;
        this.existingPolicyDocument = builder.existingPolicyDocument;
        this.policyType = builder.policyType;
    }

    public final String newPolicyDocument() {
        return this.newPolicyDocument;
    }

    public final String existingPolicyDocument() {
        return this.existingPolicyDocument;
    }

    public final AccessCheckPolicyType policyType() {
        return AccessCheckPolicyType.fromValue(this.policyType);
    }

    public final String policyTypeAsString() {
        return this.policyType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.newPolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.existingPolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CheckNoNewAccessRequest)) {
            return false;
        }
        CheckNoNewAccessRequest other = (CheckNoNewAccessRequest)((Object)obj);
        return Objects.equals(this.newPolicyDocument(), other.newPolicyDocument()) && Objects.equals(this.existingPolicyDocument(), other.existingPolicyDocument()) && Objects.equals(this.policyTypeAsString(), other.policyTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CheckNoNewAccessRequest").add("NewPolicyDocument", (Object)(this.newPolicyDocument() == null ? null : "*** Sensitive Data Redacted ***")).add("ExistingPolicyDocument", (Object)(this.existingPolicyDocument() == null ? null : "*** Sensitive Data Redacted ***")).add("PolicyType", (Object)this.policyTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "newPolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.newPolicyDocument()));
            }
            case "existingPolicyDocument": {
                return Optional.ofNullable(clazz.cast(this.existingPolicyDocument()));
            }
            case "policyType": {
                return Optional.ofNullable(clazz.cast(this.policyTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CheckNoNewAccessRequest, T> g) {
        return obj -> g.apply((CheckNoNewAccessRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerRequest.BuilderImpl
    implements Builder {
        private String newPolicyDocument;
        private String existingPolicyDocument;
        private String policyType;

        private BuilderImpl() {
        }

        private BuilderImpl(CheckNoNewAccessRequest model) {
            super(model);
            this.newPolicyDocument(model.newPolicyDocument);
            this.existingPolicyDocument(model.existingPolicyDocument);
            this.policyType(model.policyType);
        }

        public final String getNewPolicyDocument() {
            return this.newPolicyDocument;
        }

        public final void setNewPolicyDocument(String newPolicyDocument) {
            this.newPolicyDocument = newPolicyDocument;
        }

        @Override
        public final Builder newPolicyDocument(String newPolicyDocument) {
            this.newPolicyDocument = newPolicyDocument;
            return this;
        }

        public final String getExistingPolicyDocument() {
            return this.existingPolicyDocument;
        }

        public final void setExistingPolicyDocument(String existingPolicyDocument) {
            this.existingPolicyDocument = existingPolicyDocument;
        }

        @Override
        public final Builder existingPolicyDocument(String existingPolicyDocument) {
            this.existingPolicyDocument = existingPolicyDocument;
            return this;
        }

        public final String getPolicyType() {
            return this.policyType;
        }

        public final void setPolicyType(String policyType) {
            this.policyType = policyType;
        }

        @Override
        public final Builder policyType(String policyType) {
            this.policyType = policyType;
            return this;
        }

        @Override
        public final Builder policyType(AccessCheckPolicyType policyType) {
            this.policyType(policyType == null ? null : policyType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CheckNoNewAccessRequest build() {
            return new CheckNoNewAccessRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends AccessAnalyzerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CheckNoNewAccessRequest> {
        public Builder newPolicyDocument(String var1);

        public Builder existingPolicyDocument(String var1);

        public Builder policyType(String var1);

        public Builder policyType(AccessCheckPolicyType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

