/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetGeneratedPolicyRequest
extends AccessAnalyzerRequest
implements ToCopyableBuilder<Builder, GetGeneratedPolicyRequest> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(GetGeneratedPolicyRequest.getter(GetGeneratedPolicyRequest::jobId)).setter(GetGeneratedPolicyRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final SdkField<Boolean> INCLUDE_RESOURCE_PLACEHOLDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeResourcePlaceholders").getter(GetGeneratedPolicyRequest.getter(GetGeneratedPolicyRequest::includeResourcePlaceholders)).setter(GetGeneratedPolicyRequest.setter(Builder::includeResourcePlaceholders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeResourcePlaceholders").build()}).build();
    private static final SdkField<Boolean> INCLUDE_SERVICE_LEVEL_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("includeServiceLevelTemplate").getter(GetGeneratedPolicyRequest.getter(GetGeneratedPolicyRequest::includeServiceLevelTemplate)).setter(GetGeneratedPolicyRequest.setter(Builder::includeServiceLevelTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("includeServiceLevelTemplate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, INCLUDE_RESOURCE_PLACEHOLDERS_FIELD, INCLUDE_SERVICE_LEVEL_TEMPLATE_FIELD));
    private final String jobId;
    private final Boolean includeResourcePlaceholders;
    private final Boolean includeServiceLevelTemplate;

    private GetGeneratedPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.jobId = builder.jobId;
        this.includeResourcePlaceholders = builder.includeResourcePlaceholders;
        this.includeServiceLevelTemplate = builder.includeServiceLevelTemplate;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final Boolean includeResourcePlaceholders() {
        return this.includeResourcePlaceholders;
    }

    public final Boolean includeServiceLevelTemplate() {
        return this.includeServiceLevelTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeResourcePlaceholders());
        hashCode = 31 * hashCode + Objects.hashCode(this.includeServiceLevelTemplate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGeneratedPolicyRequest)) {
            return false;
        }
        GetGeneratedPolicyRequest other = (GetGeneratedPolicyRequest)((Object)obj);
        return Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.includeResourcePlaceholders(), other.includeResourcePlaceholders()) && Objects.equals(this.includeServiceLevelTemplate(), other.includeServiceLevelTemplate());
    }

    public final String toString() {
        return ToString.builder((String)"GetGeneratedPolicyRequest").add("JobId", (Object)this.jobId()).add("IncludeResourcePlaceholders", (Object)this.includeResourcePlaceholders()).add("IncludeServiceLevelTemplate", (Object)this.includeServiceLevelTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "includeResourcePlaceholders": {
                return Optional.ofNullable(clazz.cast(this.includeResourcePlaceholders()));
            }
            case "includeServiceLevelTemplate": {
                return Optional.ofNullable(clazz.cast(this.includeServiceLevelTemplate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGeneratedPolicyRequest, T> g) {
        return obj -> g.apply((GetGeneratedPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerRequest.BuilderImpl
    implements Builder {
        private String jobId;
        private Boolean includeResourcePlaceholders;
        private Boolean includeServiceLevelTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGeneratedPolicyRequest model) {
            super(model);
            this.jobId(model.jobId);
            this.includeResourcePlaceholders(model.includeResourcePlaceholders);
            this.includeServiceLevelTemplate(model.includeServiceLevelTemplate);
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Boolean getIncludeResourcePlaceholders() {
            return this.includeResourcePlaceholders;
        }

        public final void setIncludeResourcePlaceholders(Boolean includeResourcePlaceholders) {
            this.includeResourcePlaceholders = includeResourcePlaceholders;
        }

        @Override
        public final Builder includeResourcePlaceholders(Boolean includeResourcePlaceholders) {
            this.includeResourcePlaceholders = includeResourcePlaceholders;
            return this;
        }

        public final Boolean getIncludeServiceLevelTemplate() {
            return this.includeServiceLevelTemplate;
        }

        public final void setIncludeServiceLevelTemplate(Boolean includeServiceLevelTemplate) {
            this.includeServiceLevelTemplate = includeServiceLevelTemplate;
        }

        @Override
        public final Builder includeServiceLevelTemplate(Boolean includeServiceLevelTemplate) {
            this.includeServiceLevelTemplate = includeServiceLevelTemplate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetGeneratedPolicyRequest build() {
            return new GetGeneratedPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AccessAnalyzerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetGeneratedPolicyRequest> {
        public Builder jobId(String var1);

        public Builder includeResourcePlaceholders(Boolean var1);

        public Builder includeServiceLevelTemplate(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

