/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AclPermission {
    READ("READ"),
    WRITE("WRITE"),
    READ_ACP("READ_ACP"),
    WRITE_ACP("WRITE_ACP"),
    FULL_CONTROL("FULL_CONTROL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AclPermission> VALUE_MAP;
    private final String value;

    private AclPermission(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AclPermission fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AclPermission> knownValues() {
        EnumSet<AclPermission> knownValues = EnumSet.allOf(AclPermission.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AclPermission.class, AclPermission::toString);
    }
}

