/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerAsyncClient;
import software.amazon.awssdk.services.accessanalyzer.internal.UserAgentUtils;
import software.amazon.awssdk.services.accessanalyzer.model.FindingSummaryV2;
import software.amazon.awssdk.services.accessanalyzer.model.ListFindingsV2Request;
import software.amazon.awssdk.services.accessanalyzer.model.ListFindingsV2Response;

public class ListFindingsV2Publisher
implements SdkPublisher<ListFindingsV2Response> {
    private final AccessAnalyzerAsyncClient client;
    private final ListFindingsV2Request firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListFindingsV2Publisher(AccessAnalyzerAsyncClient client, ListFindingsV2Request firstRequest) {
        this(client, firstRequest, false);
    }

    private ListFindingsV2Publisher(AccessAnalyzerAsyncClient client, ListFindingsV2Request firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListFindingsV2ResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListFindingsV2Response> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<FindingSummaryV2> findings() {
        Function<ListFindingsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListFindingsV2ResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListFindingsV2ResponseFetcher
    implements AsyncPageFetcher<ListFindingsV2Response> {
        private ListFindingsV2ResponseFetcher() {
        }

        public boolean hasNextPage(ListFindingsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListFindingsV2Response> nextPage(ListFindingsV2Response previousPage) {
            if (previousPage == null) {
                return ListFindingsV2Publisher.this.client.listFindingsV2(ListFindingsV2Publisher.this.firstRequest);
            }
            return ListFindingsV2Publisher.this.client.listFindingsV2((ListFindingsV2Request)((Object)ListFindingsV2Publisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

