/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceType {
    AWS_S3_BUCKET("AWS::S3::Bucket"),
    AWS_IAM_ROLE("AWS::IAM::Role"),
    AWS_SQS_QUEUE("AWS::SQS::Queue"),
    AWS_LAMBDA_FUNCTION("AWS::Lambda::Function"),
    AWS_LAMBDA_LAYER_VERSION("AWS::Lambda::LayerVersion"),
    AWS_KMS_KEY("AWS::KMS::Key"),
    AWS_SECRETS_MANAGER_SECRET("AWS::SecretsManager::Secret"),
    AWS_EFS_FILE_SYSTEM("AWS::EFS::FileSystem"),
    AWS_EC2_SNAPSHOT("AWS::EC2::Snapshot"),
    AWS_ECR_REPOSITORY("AWS::ECR::Repository"),
    AWS_RDS_DB_SNAPSHOT("AWS::RDS::DBSnapshot"),
    AWS_RDS_DB_CLUSTER_SNAPSHOT("AWS::RDS::DBClusterSnapshot"),
    AWS_SNS_TOPIC("AWS::SNS::Topic"),
    AWS_S3_EXPRESS_DIRECTORY_BUCKET("AWS::S3Express::DirectoryBucket"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceType> VALUE_MAP;
    private final String value;

    private ResourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceType> knownValues() {
        EnumSet<ResourceType> knownValues = EnumSet.allOf(ResourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceType.class, ResourceType::toString);
    }
}

