/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum JobErrorCode {
    AUTHORIZATION_ERROR("AUTHORIZATION_ERROR"),
    RESOURCE_NOT_FOUND_ERROR("RESOURCE_NOT_FOUND_ERROR"),
    SERVICE_QUOTA_EXCEEDED_ERROR("SERVICE_QUOTA_EXCEEDED_ERROR"),
    SERVICE_ERROR("SERVICE_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, JobErrorCode> VALUE_MAP;
    private final String value;

    private JobErrorCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static JobErrorCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<JobErrorCode> knownValues() {
        EnumSet<JobErrorCode> knownValues = EnumSet.allOf(JobErrorCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(JobErrorCode.class, JobErrorCode::toString);
    }
}

