/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.EbsSnapshotConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.EcrRepositoryConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.EfsFileSystemConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.IamRoleConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.KmsKeyConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.RdsDbClusterSnapshotConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.RdsDbSnapshotConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.S3BucketConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.SecretsManagerSecretConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.SnsTopicConfiguration;
import software.amazon.awssdk.services.accessanalyzer.model.SqsQueueConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Configuration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Configuration> {
    private static final SdkField<EbsSnapshotConfiguration> EBS_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ebsSnapshot").getter(Configuration.getter(Configuration::ebsSnapshot)).setter(Configuration.setter(Builder::ebsSnapshot)).constructor(EbsSnapshotConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ebsSnapshot").build()}).build();
    private static final SdkField<EcrRepositoryConfiguration> ECR_REPOSITORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ecrRepository").getter(Configuration.getter(Configuration::ecrRepository)).setter(Configuration.setter(Builder::ecrRepository)).constructor(EcrRepositoryConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepository").build()}).build();
    private static final SdkField<IamRoleConfiguration> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iamRole").getter(Configuration.getter(Configuration::iamRole)).setter(Configuration.setter(Builder::iamRole)).constructor(IamRoleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamRole").build()}).build();
    private static final SdkField<EfsFileSystemConfiguration> EFS_FILE_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("efsFileSystem").getter(Configuration.getter(Configuration::efsFileSystem)).setter(Configuration.setter(Builder::efsFileSystem)).constructor(EfsFileSystemConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("efsFileSystem").build()}).build();
    private static final SdkField<KmsKeyConfiguration> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("kmsKey").getter(Configuration.getter(Configuration::kmsKey)).setter(Configuration.setter(Builder::kmsKey)).constructor(KmsKeyConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKey").build()}).build();
    private static final SdkField<RdsDbClusterSnapshotConfiguration> RDS_DB_CLUSTER_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rdsDbClusterSnapshot").getter(Configuration.getter(Configuration::rdsDbClusterSnapshot)).setter(Configuration.setter(Builder::rdsDbClusterSnapshot)).constructor(RdsDbClusterSnapshotConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsDbClusterSnapshot").build()}).build();
    private static final SdkField<RdsDbSnapshotConfiguration> RDS_DB_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rdsDbSnapshot").getter(Configuration.getter(Configuration::rdsDbSnapshot)).setter(Configuration.setter(Builder::rdsDbSnapshot)).constructor(RdsDbSnapshotConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rdsDbSnapshot").build()}).build();
    private static final SdkField<SecretsManagerSecretConfiguration> SECRETS_MANAGER_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("secretsManagerSecret").getter(Configuration.getter(Configuration::secretsManagerSecret)).setter(Configuration.setter(Builder::secretsManagerSecret)).constructor(SecretsManagerSecretConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secretsManagerSecret").build()}).build();
    private static final SdkField<S3BucketConfiguration> S3_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Bucket").getter(Configuration.getter(Configuration::s3Bucket)).setter(Configuration.setter(Builder::s3Bucket)).constructor(S3BucketConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Bucket").build()}).build();
    private static final SdkField<SnsTopicConfiguration> SNS_TOPIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("snsTopic").getter(Configuration.getter(Configuration::snsTopic)).setter(Configuration.setter(Builder::snsTopic)).constructor(SnsTopicConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snsTopic").build()}).build();
    private static final SdkField<SqsQueueConfiguration> SQS_QUEUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sqsQueue").getter(Configuration.getter(Configuration::sqsQueue)).setter(Configuration.setter(Builder::sqsQueue)).constructor(SqsQueueConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sqsQueue").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EBS_SNAPSHOT_FIELD, ECR_REPOSITORY_FIELD, IAM_ROLE_FIELD, EFS_FILE_SYSTEM_FIELD, KMS_KEY_FIELD, RDS_DB_CLUSTER_SNAPSHOT_FIELD, RDS_DB_SNAPSHOT_FIELD, SECRETS_MANAGER_SECRET_FIELD, S3_BUCKET_FIELD, SNS_TOPIC_FIELD, SQS_QUEUE_FIELD));
    private static final long serialVersionUID = 1L;
    private final EbsSnapshotConfiguration ebsSnapshot;
    private final EcrRepositoryConfiguration ecrRepository;
    private final IamRoleConfiguration iamRole;
    private final EfsFileSystemConfiguration efsFileSystem;
    private final KmsKeyConfiguration kmsKey;
    private final RdsDbClusterSnapshotConfiguration rdsDbClusterSnapshot;
    private final RdsDbSnapshotConfiguration rdsDbSnapshot;
    private final SecretsManagerSecretConfiguration secretsManagerSecret;
    private final S3BucketConfiguration s3Bucket;
    private final SnsTopicConfiguration snsTopic;
    private final SqsQueueConfiguration sqsQueue;
    private final Type type;

    private Configuration(BuilderImpl builder) {
        this.ebsSnapshot = builder.ebsSnapshot;
        this.ecrRepository = builder.ecrRepository;
        this.iamRole = builder.iamRole;
        this.efsFileSystem = builder.efsFileSystem;
        this.kmsKey = builder.kmsKey;
        this.rdsDbClusterSnapshot = builder.rdsDbClusterSnapshot;
        this.rdsDbSnapshot = builder.rdsDbSnapshot;
        this.secretsManagerSecret = builder.secretsManagerSecret;
        this.s3Bucket = builder.s3Bucket;
        this.snsTopic = builder.snsTopic;
        this.sqsQueue = builder.sqsQueue;
        this.type = builder.type;
    }

    public final EbsSnapshotConfiguration ebsSnapshot() {
        return this.ebsSnapshot;
    }

    public final EcrRepositoryConfiguration ecrRepository() {
        return this.ecrRepository;
    }

    public final IamRoleConfiguration iamRole() {
        return this.iamRole;
    }

    public final EfsFileSystemConfiguration efsFileSystem() {
        return this.efsFileSystem;
    }

    public final KmsKeyConfiguration kmsKey() {
        return this.kmsKey;
    }

    public final RdsDbClusterSnapshotConfiguration rdsDbClusterSnapshot() {
        return this.rdsDbClusterSnapshot;
    }

    public final RdsDbSnapshotConfiguration rdsDbSnapshot() {
        return this.rdsDbSnapshot;
    }

    public final SecretsManagerSecretConfiguration secretsManagerSecret() {
        return this.secretsManagerSecret;
    }

    public final S3BucketConfiguration s3Bucket() {
        return this.s3Bucket;
    }

    public final SnsTopicConfiguration snsTopic() {
        return this.snsTopic;
    }

    public final SqsQueueConfiguration sqsQueue() {
        return this.sqsQueue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecrRepository());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.efsFileSystem());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsDbClusterSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.rdsDbSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.secretsManagerSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Bucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopic());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqsQueue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Configuration)) {
            return false;
        }
        Configuration other = (Configuration)obj;
        return Objects.equals(this.ebsSnapshot(), other.ebsSnapshot()) && Objects.equals(this.ecrRepository(), other.ecrRepository()) && Objects.equals(this.iamRole(), other.iamRole()) && Objects.equals(this.efsFileSystem(), other.efsFileSystem()) && Objects.equals(this.kmsKey(), other.kmsKey()) && Objects.equals(this.rdsDbClusterSnapshot(), other.rdsDbClusterSnapshot()) && Objects.equals(this.rdsDbSnapshot(), other.rdsDbSnapshot()) && Objects.equals(this.secretsManagerSecret(), other.secretsManagerSecret()) && Objects.equals(this.s3Bucket(), other.s3Bucket()) && Objects.equals(this.snsTopic(), other.snsTopic()) && Objects.equals(this.sqsQueue(), other.sqsQueue());
    }

    public final String toString() {
        return ToString.builder((String)"Configuration").add("EbsSnapshot", (Object)this.ebsSnapshot()).add("EcrRepository", (Object)this.ecrRepository()).add("IamRole", (Object)this.iamRole()).add("EfsFileSystem", (Object)this.efsFileSystem()).add("KmsKey", (Object)this.kmsKey()).add("RdsDbClusterSnapshot", (Object)this.rdsDbClusterSnapshot()).add("RdsDbSnapshot", (Object)this.rdsDbSnapshot()).add("SecretsManagerSecret", (Object)this.secretsManagerSecret()).add("S3Bucket", (Object)this.s3Bucket()).add("SnsTopic", (Object)this.snsTopic()).add("SqsQueue", (Object)this.sqsQueue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ebsSnapshot": {
                return Optional.ofNullable(clazz.cast(this.ebsSnapshot()));
            }
            case "ecrRepository": {
                return Optional.ofNullable(clazz.cast(this.ecrRepository()));
            }
            case "iamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "efsFileSystem": {
                return Optional.ofNullable(clazz.cast(this.efsFileSystem()));
            }
            case "kmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
            case "rdsDbClusterSnapshot": {
                return Optional.ofNullable(clazz.cast(this.rdsDbClusterSnapshot()));
            }
            case "rdsDbSnapshot": {
                return Optional.ofNullable(clazz.cast(this.rdsDbSnapshot()));
            }
            case "secretsManagerSecret": {
                return Optional.ofNullable(clazz.cast(this.secretsManagerSecret()));
            }
            case "s3Bucket": {
                return Optional.ofNullable(clazz.cast(this.s3Bucket()));
            }
            case "snsTopic": {
                return Optional.ofNullable(clazz.cast(this.snsTopic()));
            }
            case "sqsQueue": {
                return Optional.ofNullable(clazz.cast(this.sqsQueue()));
            }
        }
        return Optional.empty();
    }

    public static Configuration fromEbsSnapshot(EbsSnapshotConfiguration ebsSnapshot) {
        return (Configuration)Configuration.builder().ebsSnapshot(ebsSnapshot).build();
    }

    public static Configuration fromEbsSnapshot(Consumer<EbsSnapshotConfiguration.Builder> ebsSnapshot) {
        EbsSnapshotConfiguration.Builder builder = EbsSnapshotConfiguration.builder();
        ebsSnapshot.accept(builder);
        return Configuration.fromEbsSnapshot((EbsSnapshotConfiguration)builder.build());
    }

    public static Configuration fromEcrRepository(EcrRepositoryConfiguration ecrRepository) {
        return (Configuration)Configuration.builder().ecrRepository(ecrRepository).build();
    }

    public static Configuration fromEcrRepository(Consumer<EcrRepositoryConfiguration.Builder> ecrRepository) {
        EcrRepositoryConfiguration.Builder builder = EcrRepositoryConfiguration.builder();
        ecrRepository.accept(builder);
        return Configuration.fromEcrRepository((EcrRepositoryConfiguration)builder.build());
    }

    public static Configuration fromIamRole(IamRoleConfiguration iamRole) {
        return (Configuration)Configuration.builder().iamRole(iamRole).build();
    }

    public static Configuration fromIamRole(Consumer<IamRoleConfiguration.Builder> iamRole) {
        IamRoleConfiguration.Builder builder = IamRoleConfiguration.builder();
        iamRole.accept(builder);
        return Configuration.fromIamRole((IamRoleConfiguration)builder.build());
    }

    public static Configuration fromEfsFileSystem(EfsFileSystemConfiguration efsFileSystem) {
        return (Configuration)Configuration.builder().efsFileSystem(efsFileSystem).build();
    }

    public static Configuration fromEfsFileSystem(Consumer<EfsFileSystemConfiguration.Builder> efsFileSystem) {
        EfsFileSystemConfiguration.Builder builder = EfsFileSystemConfiguration.builder();
        efsFileSystem.accept(builder);
        return Configuration.fromEfsFileSystem((EfsFileSystemConfiguration)builder.build());
    }

    public static Configuration fromKmsKey(KmsKeyConfiguration kmsKey) {
        return (Configuration)Configuration.builder().kmsKey(kmsKey).build();
    }

    public static Configuration fromKmsKey(Consumer<KmsKeyConfiguration.Builder> kmsKey) {
        KmsKeyConfiguration.Builder builder = KmsKeyConfiguration.builder();
        kmsKey.accept(builder);
        return Configuration.fromKmsKey((KmsKeyConfiguration)builder.build());
    }

    public static Configuration fromRdsDbClusterSnapshot(RdsDbClusterSnapshotConfiguration rdsDbClusterSnapshot) {
        return (Configuration)Configuration.builder().rdsDbClusterSnapshot(rdsDbClusterSnapshot).build();
    }

    public static Configuration fromRdsDbClusterSnapshot(Consumer<RdsDbClusterSnapshotConfiguration.Builder> rdsDbClusterSnapshot) {
        RdsDbClusterSnapshotConfiguration.Builder builder = RdsDbClusterSnapshotConfiguration.builder();
        rdsDbClusterSnapshot.accept(builder);
        return Configuration.fromRdsDbClusterSnapshot((RdsDbClusterSnapshotConfiguration)builder.build());
    }

    public static Configuration fromRdsDbSnapshot(RdsDbSnapshotConfiguration rdsDbSnapshot) {
        return (Configuration)Configuration.builder().rdsDbSnapshot(rdsDbSnapshot).build();
    }

    public static Configuration fromRdsDbSnapshot(Consumer<RdsDbSnapshotConfiguration.Builder> rdsDbSnapshot) {
        RdsDbSnapshotConfiguration.Builder builder = RdsDbSnapshotConfiguration.builder();
        rdsDbSnapshot.accept(builder);
        return Configuration.fromRdsDbSnapshot((RdsDbSnapshotConfiguration)builder.build());
    }

    public static Configuration fromSecretsManagerSecret(SecretsManagerSecretConfiguration secretsManagerSecret) {
        return (Configuration)Configuration.builder().secretsManagerSecret(secretsManagerSecret).build();
    }

    public static Configuration fromSecretsManagerSecret(Consumer<SecretsManagerSecretConfiguration.Builder> secretsManagerSecret) {
        SecretsManagerSecretConfiguration.Builder builder = SecretsManagerSecretConfiguration.builder();
        secretsManagerSecret.accept(builder);
        return Configuration.fromSecretsManagerSecret((SecretsManagerSecretConfiguration)builder.build());
    }

    public static Configuration fromS3Bucket(S3BucketConfiguration s3Bucket) {
        return (Configuration)Configuration.builder().s3Bucket(s3Bucket).build();
    }

    public static Configuration fromS3Bucket(Consumer<S3BucketConfiguration.Builder> s3Bucket) {
        S3BucketConfiguration.Builder builder = S3BucketConfiguration.builder();
        s3Bucket.accept(builder);
        return Configuration.fromS3Bucket((S3BucketConfiguration)builder.build());
    }

    public static Configuration fromSnsTopic(SnsTopicConfiguration snsTopic) {
        return (Configuration)Configuration.builder().snsTopic(snsTopic).build();
    }

    public static Configuration fromSnsTopic(Consumer<SnsTopicConfiguration.Builder> snsTopic) {
        SnsTopicConfiguration.Builder builder = SnsTopicConfiguration.builder();
        snsTopic.accept(builder);
        return Configuration.fromSnsTopic((SnsTopicConfiguration)builder.build());
    }

    public static Configuration fromSqsQueue(SqsQueueConfiguration sqsQueue) {
        return (Configuration)Configuration.builder().sqsQueue(sqsQueue).build();
    }

    public static Configuration fromSqsQueue(Consumer<SqsQueueConfiguration.Builder> sqsQueue) {
        SqsQueueConfiguration.Builder builder = SqsQueueConfiguration.builder();
        sqsQueue.accept(builder);
        return Configuration.fromSqsQueue((SqsQueueConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Configuration, T> g) {
        return obj -> g.apply((Configuration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EBS_SNAPSHOT,
        ECR_REPOSITORY,
        IAM_ROLE,
        EFS_FILE_SYSTEM,
        KMS_KEY,
        RDS_DB_CLUSTER_SNAPSHOT,
        RDS_DB_SNAPSHOT,
        SECRETS_MANAGER_SECRET,
        S3_BUCKET,
        SNS_TOPIC,
        SQS_QUEUE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EbsSnapshotConfiguration ebsSnapshot;
        private EcrRepositoryConfiguration ecrRepository;
        private IamRoleConfiguration iamRole;
        private EfsFileSystemConfiguration efsFileSystem;
        private KmsKeyConfiguration kmsKey;
        private RdsDbClusterSnapshotConfiguration rdsDbClusterSnapshot;
        private RdsDbSnapshotConfiguration rdsDbSnapshot;
        private SecretsManagerSecretConfiguration secretsManagerSecret;
        private S3BucketConfiguration s3Bucket;
        private SnsTopicConfiguration snsTopic;
        private SqsQueueConfiguration sqsQueue;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Configuration model) {
            this.ebsSnapshot(model.ebsSnapshot);
            this.ecrRepository(model.ecrRepository);
            this.iamRole(model.iamRole);
            this.efsFileSystem(model.efsFileSystem);
            this.kmsKey(model.kmsKey);
            this.rdsDbClusterSnapshot(model.rdsDbClusterSnapshot);
            this.rdsDbSnapshot(model.rdsDbSnapshot);
            this.secretsManagerSecret(model.secretsManagerSecret);
            this.s3Bucket(model.s3Bucket);
            this.snsTopic(model.snsTopic);
            this.sqsQueue(model.sqsQueue);
        }

        public final EbsSnapshotConfiguration.Builder getEbsSnapshot() {
            return this.ebsSnapshot != null ? this.ebsSnapshot.toBuilder() : null;
        }

        public final void setEbsSnapshot(EbsSnapshotConfiguration.BuilderImpl ebsSnapshot) {
            EbsSnapshotConfiguration oldValue = this.ebsSnapshot;
            this.ebsSnapshot = ebsSnapshot != null ? ebsSnapshot.build() : null;
            this.handleUnionValueChange(Type.EBS_SNAPSHOT, oldValue, this.ebsSnapshot);
        }

        @Override
        public final Builder ebsSnapshot(EbsSnapshotConfiguration ebsSnapshot) {
            EbsSnapshotConfiguration oldValue = this.ebsSnapshot;
            this.ebsSnapshot = ebsSnapshot;
            this.handleUnionValueChange(Type.EBS_SNAPSHOT, oldValue, this.ebsSnapshot);
            return this;
        }

        public final EcrRepositoryConfiguration.Builder getEcrRepository() {
            return this.ecrRepository != null ? this.ecrRepository.toBuilder() : null;
        }

        public final void setEcrRepository(EcrRepositoryConfiguration.BuilderImpl ecrRepository) {
            EcrRepositoryConfiguration oldValue = this.ecrRepository;
            this.ecrRepository = ecrRepository != null ? ecrRepository.build() : null;
            this.handleUnionValueChange(Type.ECR_REPOSITORY, oldValue, this.ecrRepository);
        }

        @Override
        public final Builder ecrRepository(EcrRepositoryConfiguration ecrRepository) {
            EcrRepositoryConfiguration oldValue = this.ecrRepository;
            this.ecrRepository = ecrRepository;
            this.handleUnionValueChange(Type.ECR_REPOSITORY, oldValue, this.ecrRepository);
            return this;
        }

        public final IamRoleConfiguration.Builder getIamRole() {
            return this.iamRole != null ? this.iamRole.toBuilder() : null;
        }

        public final void setIamRole(IamRoleConfiguration.BuilderImpl iamRole) {
            IamRoleConfiguration oldValue = this.iamRole;
            this.iamRole = iamRole != null ? iamRole.build() : null;
            this.handleUnionValueChange(Type.IAM_ROLE, oldValue, this.iamRole);
        }

        @Override
        public final Builder iamRole(IamRoleConfiguration iamRole) {
            IamRoleConfiguration oldValue = this.iamRole;
            this.iamRole = iamRole;
            this.handleUnionValueChange(Type.IAM_ROLE, oldValue, this.iamRole);
            return this;
        }

        public final EfsFileSystemConfiguration.Builder getEfsFileSystem() {
            return this.efsFileSystem != null ? this.efsFileSystem.toBuilder() : null;
        }

        public final void setEfsFileSystem(EfsFileSystemConfiguration.BuilderImpl efsFileSystem) {
            EfsFileSystemConfiguration oldValue = this.efsFileSystem;
            this.efsFileSystem = efsFileSystem != null ? efsFileSystem.build() : null;
            this.handleUnionValueChange(Type.EFS_FILE_SYSTEM, oldValue, this.efsFileSystem);
        }

        @Override
        public final Builder efsFileSystem(EfsFileSystemConfiguration efsFileSystem) {
            EfsFileSystemConfiguration oldValue = this.efsFileSystem;
            this.efsFileSystem = efsFileSystem;
            this.handleUnionValueChange(Type.EFS_FILE_SYSTEM, oldValue, this.efsFileSystem);
            return this;
        }

        public final KmsKeyConfiguration.Builder getKmsKey() {
            return this.kmsKey != null ? this.kmsKey.toBuilder() : null;
        }

        public final void setKmsKey(KmsKeyConfiguration.BuilderImpl kmsKey) {
            KmsKeyConfiguration oldValue = this.kmsKey;
            this.kmsKey = kmsKey != null ? kmsKey.build() : null;
            this.handleUnionValueChange(Type.KMS_KEY, oldValue, this.kmsKey);
        }

        @Override
        public final Builder kmsKey(KmsKeyConfiguration kmsKey) {
            KmsKeyConfiguration oldValue = this.kmsKey;
            this.kmsKey = kmsKey;
            this.handleUnionValueChange(Type.KMS_KEY, oldValue, this.kmsKey);
            return this;
        }

        public final RdsDbClusterSnapshotConfiguration.Builder getRdsDbClusterSnapshot() {
            return this.rdsDbClusterSnapshot != null ? this.rdsDbClusterSnapshot.toBuilder() : null;
        }

        public final void setRdsDbClusterSnapshot(RdsDbClusterSnapshotConfiguration.BuilderImpl rdsDbClusterSnapshot) {
            RdsDbClusterSnapshotConfiguration oldValue = this.rdsDbClusterSnapshot;
            this.rdsDbClusterSnapshot = rdsDbClusterSnapshot != null ? rdsDbClusterSnapshot.build() : null;
            this.handleUnionValueChange(Type.RDS_DB_CLUSTER_SNAPSHOT, oldValue, this.rdsDbClusterSnapshot);
        }

        @Override
        public final Builder rdsDbClusterSnapshot(RdsDbClusterSnapshotConfiguration rdsDbClusterSnapshot) {
            RdsDbClusterSnapshotConfiguration oldValue = this.rdsDbClusterSnapshot;
            this.rdsDbClusterSnapshot = rdsDbClusterSnapshot;
            this.handleUnionValueChange(Type.RDS_DB_CLUSTER_SNAPSHOT, oldValue, this.rdsDbClusterSnapshot);
            return this;
        }

        public final RdsDbSnapshotConfiguration.Builder getRdsDbSnapshot() {
            return this.rdsDbSnapshot != null ? this.rdsDbSnapshot.toBuilder() : null;
        }

        public final void setRdsDbSnapshot(RdsDbSnapshotConfiguration.BuilderImpl rdsDbSnapshot) {
            RdsDbSnapshotConfiguration oldValue = this.rdsDbSnapshot;
            this.rdsDbSnapshot = rdsDbSnapshot != null ? rdsDbSnapshot.build() : null;
            this.handleUnionValueChange(Type.RDS_DB_SNAPSHOT, oldValue, this.rdsDbSnapshot);
        }

        @Override
        public final Builder rdsDbSnapshot(RdsDbSnapshotConfiguration rdsDbSnapshot) {
            RdsDbSnapshotConfiguration oldValue = this.rdsDbSnapshot;
            this.rdsDbSnapshot = rdsDbSnapshot;
            this.handleUnionValueChange(Type.RDS_DB_SNAPSHOT, oldValue, this.rdsDbSnapshot);
            return this;
        }

        public final SecretsManagerSecretConfiguration.Builder getSecretsManagerSecret() {
            return this.secretsManagerSecret != null ? this.secretsManagerSecret.toBuilder() : null;
        }

        public final void setSecretsManagerSecret(SecretsManagerSecretConfiguration.BuilderImpl secretsManagerSecret) {
            SecretsManagerSecretConfiguration oldValue = this.secretsManagerSecret;
            this.secretsManagerSecret = secretsManagerSecret != null ? secretsManagerSecret.build() : null;
            this.handleUnionValueChange(Type.SECRETS_MANAGER_SECRET, oldValue, this.secretsManagerSecret);
        }

        @Override
        public final Builder secretsManagerSecret(SecretsManagerSecretConfiguration secretsManagerSecret) {
            SecretsManagerSecretConfiguration oldValue = this.secretsManagerSecret;
            this.secretsManagerSecret = secretsManagerSecret;
            this.handleUnionValueChange(Type.SECRETS_MANAGER_SECRET, oldValue, this.secretsManagerSecret);
            return this;
        }

        public final S3BucketConfiguration.Builder getS3Bucket() {
            return this.s3Bucket != null ? this.s3Bucket.toBuilder() : null;
        }

        public final void setS3Bucket(S3BucketConfiguration.BuilderImpl s3Bucket) {
            S3BucketConfiguration oldValue = this.s3Bucket;
            this.s3Bucket = s3Bucket != null ? s3Bucket.build() : null;
            this.handleUnionValueChange(Type.S3_BUCKET, oldValue, this.s3Bucket);
        }

        @Override
        public final Builder s3Bucket(S3BucketConfiguration s3Bucket) {
            S3BucketConfiguration oldValue = this.s3Bucket;
            this.s3Bucket = s3Bucket;
            this.handleUnionValueChange(Type.S3_BUCKET, oldValue, this.s3Bucket);
            return this;
        }

        public final SnsTopicConfiguration.Builder getSnsTopic() {
            return this.snsTopic != null ? this.snsTopic.toBuilder() : null;
        }

        public final void setSnsTopic(SnsTopicConfiguration.BuilderImpl snsTopic) {
            SnsTopicConfiguration oldValue = this.snsTopic;
            this.snsTopic = snsTopic != null ? snsTopic.build() : null;
            this.handleUnionValueChange(Type.SNS_TOPIC, oldValue, this.snsTopic);
        }

        @Override
        public final Builder snsTopic(SnsTopicConfiguration snsTopic) {
            SnsTopicConfiguration oldValue = this.snsTopic;
            this.snsTopic = snsTopic;
            this.handleUnionValueChange(Type.SNS_TOPIC, oldValue, this.snsTopic);
            return this;
        }

        public final SqsQueueConfiguration.Builder getSqsQueue() {
            return this.sqsQueue != null ? this.sqsQueue.toBuilder() : null;
        }

        public final void setSqsQueue(SqsQueueConfiguration.BuilderImpl sqsQueue) {
            SqsQueueConfiguration oldValue = this.sqsQueue;
            this.sqsQueue = sqsQueue != null ? sqsQueue.build() : null;
            this.handleUnionValueChange(Type.SQS_QUEUE, oldValue, this.sqsQueue);
        }

        @Override
        public final Builder sqsQueue(SqsQueueConfiguration sqsQueue) {
            SqsQueueConfiguration oldValue = this.sqsQueue;
            this.sqsQueue = sqsQueue;
            this.handleUnionValueChange(Type.SQS_QUEUE, oldValue, this.sqsQueue);
            return this;
        }

        public Configuration build() {
            return new Configuration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Configuration> {
        public Builder ebsSnapshot(EbsSnapshotConfiguration var1);

        default public Builder ebsSnapshot(Consumer<EbsSnapshotConfiguration.Builder> ebsSnapshot) {
            return this.ebsSnapshot((EbsSnapshotConfiguration)((EbsSnapshotConfiguration.Builder)EbsSnapshotConfiguration.builder().applyMutation(ebsSnapshot)).build());
        }

        public Builder ecrRepository(EcrRepositoryConfiguration var1);

        default public Builder ecrRepository(Consumer<EcrRepositoryConfiguration.Builder> ecrRepository) {
            return this.ecrRepository((EcrRepositoryConfiguration)((EcrRepositoryConfiguration.Builder)EcrRepositoryConfiguration.builder().applyMutation(ecrRepository)).build());
        }

        public Builder iamRole(IamRoleConfiguration var1);

        default public Builder iamRole(Consumer<IamRoleConfiguration.Builder> iamRole) {
            return this.iamRole((IamRoleConfiguration)((IamRoleConfiguration.Builder)IamRoleConfiguration.builder().applyMutation(iamRole)).build());
        }

        public Builder efsFileSystem(EfsFileSystemConfiguration var1);

        default public Builder efsFileSystem(Consumer<EfsFileSystemConfiguration.Builder> efsFileSystem) {
            return this.efsFileSystem((EfsFileSystemConfiguration)((EfsFileSystemConfiguration.Builder)EfsFileSystemConfiguration.builder().applyMutation(efsFileSystem)).build());
        }

        public Builder kmsKey(KmsKeyConfiguration var1);

        default public Builder kmsKey(Consumer<KmsKeyConfiguration.Builder> kmsKey) {
            return this.kmsKey((KmsKeyConfiguration)((KmsKeyConfiguration.Builder)KmsKeyConfiguration.builder().applyMutation(kmsKey)).build());
        }

        public Builder rdsDbClusterSnapshot(RdsDbClusterSnapshotConfiguration var1);

        default public Builder rdsDbClusterSnapshot(Consumer<RdsDbClusterSnapshotConfiguration.Builder> rdsDbClusterSnapshot) {
            return this.rdsDbClusterSnapshot((RdsDbClusterSnapshotConfiguration)((RdsDbClusterSnapshotConfiguration.Builder)RdsDbClusterSnapshotConfiguration.builder().applyMutation(rdsDbClusterSnapshot)).build());
        }

        public Builder rdsDbSnapshot(RdsDbSnapshotConfiguration var1);

        default public Builder rdsDbSnapshot(Consumer<RdsDbSnapshotConfiguration.Builder> rdsDbSnapshot) {
            return this.rdsDbSnapshot((RdsDbSnapshotConfiguration)((RdsDbSnapshotConfiguration.Builder)RdsDbSnapshotConfiguration.builder().applyMutation(rdsDbSnapshot)).build());
        }

        public Builder secretsManagerSecret(SecretsManagerSecretConfiguration var1);

        default public Builder secretsManagerSecret(Consumer<SecretsManagerSecretConfiguration.Builder> secretsManagerSecret) {
            return this.secretsManagerSecret((SecretsManagerSecretConfiguration)((SecretsManagerSecretConfiguration.Builder)SecretsManagerSecretConfiguration.builder().applyMutation(secretsManagerSecret)).build());
        }

        public Builder s3Bucket(S3BucketConfiguration var1);

        default public Builder s3Bucket(Consumer<S3BucketConfiguration.Builder> s3Bucket) {
            return this.s3Bucket((S3BucketConfiguration)((S3BucketConfiguration.Builder)S3BucketConfiguration.builder().applyMutation(s3Bucket)).build());
        }

        public Builder snsTopic(SnsTopicConfiguration var1);

        default public Builder snsTopic(Consumer<SnsTopicConfiguration.Builder> snsTopic) {
            return this.snsTopic((SnsTopicConfiguration)((SnsTopicConfiguration.Builder)SnsTopicConfiguration.builder().applyMutation(snsTopic)).build());
        }

        public Builder sqsQueue(SqsQueueConfiguration var1);

        default public Builder sqsQueue(Consumer<SqsQueueConfiguration.Builder> sqsQueue) {
            return this.sqsQueue((SqsQueueConfiguration)((SqsQueueConfiguration.Builder)SqsQueueConfiguration.builder().applyMutation(sqsQueue)).build());
        }
    }
}

