/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerClient;
import software.amazon.awssdk.services.accessanalyzer.internal.UserAgentUtils;
import software.amazon.awssdk.services.accessanalyzer.model.AccessPreviewFinding;
import software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAccessPreviewFindingsResponse;

public class ListAccessPreviewFindingsIterable
implements SdkIterable<ListAccessPreviewFindingsResponse> {
    private final AccessAnalyzerClient client;
    private final ListAccessPreviewFindingsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListAccessPreviewFindingsIterable(AccessAnalyzerClient client, ListAccessPreviewFindingsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListAccessPreviewFindingsResponseFetcher();
    }

    public Iterator<ListAccessPreviewFindingsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccessPreviewFinding> findings() {
        Function<ListAccessPreviewFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.findings() != null) {
                return response.findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListAccessPreviewFindingsResponseFetcher
    implements SyncPageFetcher<ListAccessPreviewFindingsResponse> {
        private ListAccessPreviewFindingsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessPreviewFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListAccessPreviewFindingsResponse nextPage(ListAccessPreviewFindingsResponse previousPage) {
            if (previousPage == null) {
                return ListAccessPreviewFindingsIterable.this.client.listAccessPreviewFindings(ListAccessPreviewFindingsIterable.this.firstRequest);
            }
            return ListAccessPreviewFindingsIterable.this.client.listAccessPreviewFindings((ListAccessPreviewFindingsRequest)((Object)ListAccessPreviewFindingsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

