/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.Location;
import software.amazon.awssdk.services.accessanalyzer.model.LocationListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.ValidatePolicyFindingType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ValidatePolicyFinding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ValidatePolicyFinding> {
    private static final SdkField<String> FINDING_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingDetails").getter(ValidatePolicyFinding.getter(ValidatePolicyFinding::findingDetails)).setter(ValidatePolicyFinding.setter(Builder::findingDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingDetails").build()}).build();
    private static final SdkField<String> FINDING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("findingType").getter(ValidatePolicyFinding.getter(ValidatePolicyFinding::findingTypeAsString)).setter(ValidatePolicyFinding.setter(Builder::findingType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingType").build()}).build();
    private static final SdkField<String> ISSUE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("issueCode").getter(ValidatePolicyFinding.getter(ValidatePolicyFinding::issueCode)).setter(ValidatePolicyFinding.setter(Builder::issueCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issueCode").build()}).build();
    private static final SdkField<String> LEARN_MORE_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("learnMoreLink").getter(ValidatePolicyFinding.getter(ValidatePolicyFinding::learnMoreLink)).setter(ValidatePolicyFinding.setter(Builder::learnMoreLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("learnMoreLink").build()}).build();
    private static final SdkField<List<Location>> LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("locations").getter(ValidatePolicyFinding.getter(ValidatePolicyFinding::locations)).setter(ValidatePolicyFinding.setter(Builder::locations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("locations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Location::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FINDING_DETAILS_FIELD, FINDING_TYPE_FIELD, ISSUE_CODE_FIELD, LEARN_MORE_LINK_FIELD, LOCATIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String findingDetails;
    private final String findingType;
    private final String issueCode;
    private final String learnMoreLink;
    private final List<Location> locations;

    private ValidatePolicyFinding(BuilderImpl builder) {
        this.findingDetails = builder.findingDetails;
        this.findingType = builder.findingType;
        this.issueCode = builder.issueCode;
        this.learnMoreLink = builder.learnMoreLink;
        this.locations = builder.locations;
    }

    public final String findingDetails() {
        return this.findingDetails;
    }

    public final ValidatePolicyFindingType findingType() {
        return ValidatePolicyFindingType.fromValue(this.findingType);
    }

    public final String findingTypeAsString() {
        return this.findingType;
    }

    public final String issueCode() {
        return this.issueCode;
    }

    public final String learnMoreLink() {
        return this.learnMoreLink;
    }

    public final boolean hasLocations() {
        return this.locations != null && !(this.locations instanceof SdkAutoConstructList);
    }

    public final List<Location> locations() {
        return this.locations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.findingDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.findingTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.issueCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.learnMoreLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLocations() ? this.locations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidatePolicyFinding)) {
            return false;
        }
        ValidatePolicyFinding other = (ValidatePolicyFinding)obj;
        return Objects.equals(this.findingDetails(), other.findingDetails()) && Objects.equals(this.findingTypeAsString(), other.findingTypeAsString()) && Objects.equals(this.issueCode(), other.issueCode()) && Objects.equals(this.learnMoreLink(), other.learnMoreLink()) && this.hasLocations() == other.hasLocations() && Objects.equals(this.locations(), other.locations());
    }

    public final String toString() {
        return ToString.builder((String)"ValidatePolicyFinding").add("FindingDetails", (Object)this.findingDetails()).add("FindingType", (Object)this.findingTypeAsString()).add("IssueCode", (Object)this.issueCode()).add("LearnMoreLink", (Object)this.learnMoreLink()).add("Locations", this.hasLocations() ? this.locations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "findingDetails": {
                return Optional.ofNullable(clazz.cast(this.findingDetails()));
            }
            case "findingType": {
                return Optional.ofNullable(clazz.cast(this.findingTypeAsString()));
            }
            case "issueCode": {
                return Optional.ofNullable(clazz.cast(this.issueCode()));
            }
            case "learnMoreLink": {
                return Optional.ofNullable(clazz.cast(this.learnMoreLink()));
            }
            case "locations": {
                return Optional.ofNullable(clazz.cast(this.locations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidatePolicyFinding, T> g) {
        return obj -> g.apply((ValidatePolicyFinding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String findingDetails;
        private String findingType;
        private String issueCode;
        private String learnMoreLink;
        private List<Location> locations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidatePolicyFinding model) {
            this.findingDetails(model.findingDetails);
            this.findingType(model.findingType);
            this.issueCode(model.issueCode);
            this.learnMoreLink(model.learnMoreLink);
            this.locations(model.locations);
        }

        public final String getFindingDetails() {
            return this.findingDetails;
        }

        public final void setFindingDetails(String findingDetails) {
            this.findingDetails = findingDetails;
        }

        @Override
        public final Builder findingDetails(String findingDetails) {
            this.findingDetails = findingDetails;
            return this;
        }

        public final String getFindingType() {
            return this.findingType;
        }

        public final void setFindingType(String findingType) {
            this.findingType = findingType;
        }

        @Override
        public final Builder findingType(String findingType) {
            this.findingType = findingType;
            return this;
        }

        @Override
        public final Builder findingType(ValidatePolicyFindingType findingType) {
            this.findingType(findingType == null ? null : findingType.toString());
            return this;
        }

        public final String getIssueCode() {
            return this.issueCode;
        }

        public final void setIssueCode(String issueCode) {
            this.issueCode = issueCode;
        }

        @Override
        public final Builder issueCode(String issueCode) {
            this.issueCode = issueCode;
            return this;
        }

        public final String getLearnMoreLink() {
            return this.learnMoreLink;
        }

        public final void setLearnMoreLink(String learnMoreLink) {
            this.learnMoreLink = learnMoreLink;
        }

        @Override
        public final Builder learnMoreLink(String learnMoreLink) {
            this.learnMoreLink = learnMoreLink;
            return this;
        }

        public final List<Location.Builder> getLocations() {
            List<Location.Builder> result = LocationListCopier.copyToBuilder(this.locations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLocations(Collection<Location.BuilderImpl> locations) {
            this.locations = LocationListCopier.copyFromBuilder(locations);
        }

        @Override
        public final Builder locations(Collection<Location> locations) {
            this.locations = LocationListCopier.copy(locations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Location ... locations) {
            this.locations(Arrays.asList(locations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder locations(Consumer<Location.Builder> ... locations) {
            this.locations(Stream.of(locations).map(c -> (Location)((Location.Builder)Location.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ValidatePolicyFinding build() {
            return new ValidatePolicyFinding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ValidatePolicyFinding> {
        public Builder findingDetails(String var1);

        public Builder findingType(String var1);

        public Builder findingType(ValidatePolicyFindingType var1);

        public Builder issueCode(String var1);

        public Builder learnMoreLink(String var1);

        public Builder locations(Collection<Location> var1);

        public Builder locations(Location ... var1);

        public Builder locations(Consumer<Location.Builder> ... var1);
    }
}

