/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The proposed access control configuration for an Amazon EFS file system. You can propose a configuration for a new
 * Amazon EFS file system or an existing Amazon EFS file system that you own by specifying the Amazon EFS policy. For
 * more information, see <a href="https://docs.aws.amazon.com/efs/latest/ug/using-fs.html">Using file systems in Amazon
 * EFS</a>.
 * </p>
 * <ul>
 * <li>
 * <p>
 * If the configuration is for an existing Amazon EFS file system and you do not specify the Amazon EFS policy, then the
 * access preview uses the existing Amazon EFS policy for the file system.
 * </p>
 * </li>
 * <li>
 * <p>
 * If the access preview is for a new resource and you do not specify the policy, then the access preview assumes an
 * Amazon EFS file system without a policy.
 * </p>
 * </li>
 * <li>
 * <p>
 * To propose deletion of an existing Amazon EFS file system policy, you can specify an empty string for the Amazon EFS
 * policy.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EfsFileSystemConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EfsFileSystemConfiguration.Builder, EfsFileSystemConfiguration> {
    private static final SdkField<String> FILE_SYSTEM_POLICY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileSystemPolicy").getter(getter(EfsFileSystemConfiguration::fileSystemPolicy))
            .setter(setter(Builder::fileSystemPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystemPolicy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILE_SYSTEM_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String fileSystemPolicy;

    private EfsFileSystemConfiguration(BuilderImpl builder) {
        this.fileSystemPolicy = builder.fileSystemPolicy;
    }

    /**
     * <p>
     * The JSON policy definition to apply to the Amazon EFS file system. For more information on the elements that make
     * up a file system policy, see <a href=
     * "https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies"
     * >Amazon EFS Resource-based policies</a>.
     * </p>
     * 
     * @return The JSON policy definition to apply to the Amazon EFS file system. For more information on the elements
     *         that make up a file system policy, see <a href=
     *         "https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies"
     *         >Amazon EFS Resource-based policies</a>.
     */
    public final String fileSystemPolicy() {
        return fileSystemPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EfsFileSystemConfiguration)) {
            return false;
        }
        EfsFileSystemConfiguration other = (EfsFileSystemConfiguration) obj;
        return Objects.equals(fileSystemPolicy(), other.fileSystemPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EfsFileSystemConfiguration").add("FileSystemPolicy", fileSystemPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fileSystemPolicy":
            return Optional.ofNullable(clazz.cast(fileSystemPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EfsFileSystemConfiguration, T> g) {
        return obj -> g.apply((EfsFileSystemConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EfsFileSystemConfiguration> {
        /**
         * <p>
         * The JSON policy definition to apply to the Amazon EFS file system. For more information on the elements that
         * make up a file system policy, see <a href=
         * "https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies"
         * >Amazon EFS Resource-based policies</a>.
         * </p>
         * 
         * @param fileSystemPolicy
         *        The JSON policy definition to apply to the Amazon EFS file system. For more information on the
         *        elements that make up a file system policy, see <a href=
         *        "https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies"
         *        >Amazon EFS Resource-based policies</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileSystemPolicy(String fileSystemPolicy);
    }

    static final class BuilderImpl implements Builder {
        private String fileSystemPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(EfsFileSystemConfiguration model) {
            fileSystemPolicy(model.fileSystemPolicy);
        }

        public final String getFileSystemPolicy() {
            return fileSystemPolicy;
        }

        public final void setFileSystemPolicy(String fileSystemPolicy) {
            this.fileSystemPolicy = fileSystemPolicy;
        }

        @Override
        public final Builder fileSystemPolicy(String fileSystemPolicy) {
            this.fileSystemPolicy = fileSystemPolicy;
            return this;
        }

        @Override
        public EfsFileSystemConfiguration build() {
            return new EfsFileSystemConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
