/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.JobError;
import software.amazon.awssdk.services.accessanalyzer.model.JobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class JobDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, JobDetails> {
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completedOn").getter(JobDetails.getter(JobDetails::completedOn)).setter(JobDetails.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedOn").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<JobError> JOB_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobError").getter(JobDetails.getter(JobDetails::jobError)).setter(JobDetails.setter(Builder::jobError)).constructor(JobError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobError").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(JobDetails.getter(JobDetails::jobId)).setter(JobDetails.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedOn").getter(JobDetails.getter(JobDetails::startedOn)).setter(JobDetails.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedOn").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(JobDetails.getter(JobDetails::statusAsString)).setter(JobDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETED_ON_FIELD, JOB_ERROR_FIELD, JOB_ID_FIELD, STARTED_ON_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant completedOn;
    private final JobError jobError;
    private final String jobId;
    private final Instant startedOn;
    private final String status;

    private JobDetails(BuilderImpl builder) {
        this.completedOn = builder.completedOn;
        this.jobError = builder.jobError;
        this.jobId = builder.jobId;
        this.startedOn = builder.startedOn;
        this.status = builder.status;
    }

    public final Instant completedOn() {
        return this.completedOn;
    }

    public final JobError jobError() {
        return this.jobError;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final Instant startedOn() {
        return this.startedOn;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobError());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobDetails)) {
            return false;
        }
        JobDetails other = (JobDetails)obj;
        return Objects.equals(this.completedOn(), other.completedOn()) && Objects.equals(this.jobError(), other.jobError()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"JobDetails").add("CompletedOn", (Object)this.completedOn()).add("JobError", (Object)this.jobError()).add("JobId", (Object)this.jobId()).add("StartedOn", (Object)this.startedOn()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "completedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
            case "jobError": {
                return Optional.ofNullable(clazz.cast(this.jobError()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "startedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JobDetails, T> g) {
        return obj -> g.apply((JobDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant completedOn;
        private JobError jobError;
        private String jobId;
        private Instant startedOn;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(JobDetails model) {
            this.completedOn(model.completedOn);
            this.jobError(model.jobError);
            this.jobId(model.jobId);
            this.startedOn(model.startedOn);
            this.status(model.status);
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        @Override
        @Transient
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final JobError.Builder getJobError() {
            return this.jobError != null ? this.jobError.toBuilder() : null;
        }

        public final void setJobError(JobError.BuilderImpl jobError) {
            this.jobError = jobError != null ? jobError.build() : null;
        }

        @Override
        @Transient
        public final Builder jobError(JobError jobError) {
            this.jobError = jobError;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        @Transient
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        @Override
        @Transient
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public JobDetails build() {
            return new JobDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, JobDetails> {
        public Builder completedOn(Instant var1);

        public Builder jobError(JobError var1);

        default public Builder jobError(Consumer<JobError.Builder> jobError) {
            return this.jobError((JobError)((JobError.Builder)JobError.builder().applyMutation(jobError)).build());
        }

        public Builder jobId(String var1);

        public Builder startedOn(Instant var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);
    }
}

