/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.FindingSourceDetail;
import software.amazon.awssdk.services.accessanalyzer.model.FindingSourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FindingSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FindingSource> {
    private static final SdkField<FindingSourceDetail> DETAIL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("detail").getter(FindingSource.getter(FindingSource::detail)).setter(FindingSource.setter(Builder::detail)).constructor(FindingSourceDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detail").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(FindingSource.getter(FindingSource::typeAsString)).setter(FindingSource.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DETAIL_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final FindingSourceDetail detail;
    private final String type;

    private FindingSource(BuilderImpl builder) {
        this.detail = builder.detail;
        this.type = builder.type;
    }

    public final FindingSourceDetail detail() {
        return this.detail;
    }

    public final FindingSourceType type() {
        return FindingSourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.detail());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FindingSource)) {
            return false;
        }
        FindingSource other = (FindingSource)obj;
        return Objects.equals(this.detail(), other.detail()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FindingSource").add("Detail", (Object)this.detail()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "detail": {
                return Optional.ofNullable(clazz.cast(this.detail()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FindingSource, T> g) {
        return obj -> g.apply((FindingSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private FindingSourceDetail detail;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FindingSource model) {
            this.detail(model.detail);
            this.type(model.type);
        }

        public final FindingSourceDetail.Builder getDetail() {
            return this.detail != null ? this.detail.toBuilder() : null;
        }

        public final void setDetail(FindingSourceDetail.BuilderImpl detail) {
            this.detail = detail != null ? detail.build() : null;
        }

        @Override
        public final Builder detail(FindingSourceDetail detail) {
            this.detail = detail;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FindingSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public FindingSource build() {
            return new FindingSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FindingSource> {
        public Builder detail(FindingSourceDetail var1);

        default public Builder detail(Consumer<FindingSourceDetail.Builder> detail) {
            return this.detail((FindingSourceDetail)((FindingSourceDetail.Builder)FindingSourceDetail.builder().applyMutation(detail)).build());
        }

        public Builder type(String var1);

        public Builder type(FindingSourceType var1);
    }
}

