/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerClient;
import software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListPolicyGenerationsResponse;
import software.amazon.awssdk.services.accessanalyzer.model.PolicyGeneration;

public class ListPolicyGenerationsIterable
implements SdkIterable<ListPolicyGenerationsResponse> {
    private final AccessAnalyzerClient client;
    private final ListPolicyGenerationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPolicyGenerationsIterable(AccessAnalyzerClient client, ListPolicyGenerationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPolicyGenerationsResponseFetcher();
    }

    public Iterator<ListPolicyGenerationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PolicyGeneration> policyGenerations() {
        Function<ListPolicyGenerationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyGenerations() != null) {
                return response.policyGenerations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPolicyGenerationsResponseFetcher
    implements SyncPageFetcher<ListPolicyGenerationsResponse> {
        private ListPolicyGenerationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPolicyGenerationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPolicyGenerationsResponse nextPage(ListPolicyGenerationsResponse previousPage) {
            if (previousPage == null) {
                return ListPolicyGenerationsIterable.this.client.listPolicyGenerations(ListPolicyGenerationsIterable.this.firstRequest);
            }
            return ListPolicyGenerationsIterable.this.client.listPolicyGenerations((ListPolicyGenerationsRequest)((Object)ListPolicyGenerationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

