/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.PathElement;
import software.amazon.awssdk.services.accessanalyzer.model.PathElementListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.Span;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Location
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Location> {
    private static final SdkField<List<PathElement>> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("path").getter(Location.getter(Location::path)).setter(Location.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("path").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PathElement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Span> SPAN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("span").getter(Location.getter(Location::span)).setter(Location.setter(Builder::span)).constructor(Span::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("span").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, SPAN_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<PathElement> path;
    private final Span span;

    private Location(BuilderImpl builder) {
        this.path = builder.path;
        this.span = builder.span;
    }

    public final boolean hasPath() {
        return this.path != null && !(this.path instanceof SdkAutoConstructList);
    }

    public final List<PathElement> path() {
        return this.path;
    }

    public final Span span() {
        return this.span;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPath() ? this.path() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.span());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Location)) {
            return false;
        }
        Location other = (Location)obj;
        return this.hasPath() == other.hasPath() && Objects.equals(this.path(), other.path()) && Objects.equals(this.span(), other.span());
    }

    public final String toString() {
        return ToString.builder((String)"Location").add("Path", this.hasPath() ? this.path() : null).add("Span", (Object)this.span()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "span": {
                return Optional.ofNullable(clazz.cast(this.span()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Location, T> g) {
        return obj -> g.apply((Location)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PathElement> path = DefaultSdkAutoConstructList.getInstance();
        private Span span;

        private BuilderImpl() {
        }

        private BuilderImpl(Location model) {
            this.path(model.path);
            this.span(model.span);
        }

        public final Collection<PathElement.Builder> getPath() {
            if (this.path instanceof SdkAutoConstructList) {
                return null;
            }
            return this.path != null ? (Collection)this.path.stream().map(PathElement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder path(Collection<PathElement> path) {
            this.path = PathElementListCopier.copy(path);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(PathElement ... path) {
            this.path(Arrays.asList(path));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder path(Consumer<PathElement.Builder> ... path) {
            this.path(Stream.of(path).map(c -> (PathElement)((PathElement.Builder)PathElement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPath(Collection<PathElement.BuilderImpl> path) {
            this.path = PathElementListCopier.copyFromBuilder(path);
        }

        public final Span.Builder getSpan() {
            return this.span != null ? this.span.toBuilder() : null;
        }

        @Override
        public final Builder span(Span span) {
            this.span = span;
            return this;
        }

        public final void setSpan(Span.BuilderImpl span) {
            this.span = span != null ? span.build() : null;
        }

        public Location build() {
            return new Location(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Location> {
        public Builder path(Collection<PathElement> var1);

        public Builder path(PathElement ... var1);

        public Builder path(Consumer<PathElement.Builder> ... var1);

        public Builder span(Span var1);

        default public Builder span(Consumer<Span.Builder> span) {
            return this.span((Span)((Span.Builder)Span.builder().applyMutation(span)).build());
        }
    }
}

