/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.AnalyzerStatus;
import software.amazon.awssdk.services.accessanalyzer.model.StatusReason;
import software.amazon.awssdk.services.accessanalyzer.model.TagsMapCopier;
import software.amazon.awssdk.services.accessanalyzer.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyzerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalyzerSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(AnalyzerSummary.getter(AnalyzerSummary::arn)).setter(AnalyzerSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AnalyzerSummary.getter(AnalyzerSummary::createdAt)).setter(AnalyzerSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> LAST_RESOURCE_ANALYZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastResourceAnalyzed").getter(AnalyzerSummary.getter(AnalyzerSummary::lastResourceAnalyzed)).setter(AnalyzerSummary.setter(Builder::lastResourceAnalyzed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastResourceAnalyzed").build()}).build();
    private static final SdkField<Instant> LAST_RESOURCE_ANALYZED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastResourceAnalyzedAt").getter(AnalyzerSummary.getter(AnalyzerSummary::lastResourceAnalyzedAt)).setter(AnalyzerSummary.setter(Builder::lastResourceAnalyzedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastResourceAnalyzedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(AnalyzerSummary.getter(AnalyzerSummary::name)).setter(AnalyzerSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AnalyzerSummary.getter(AnalyzerSummary::statusAsString)).setter(AnalyzerSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<StatusReason> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("statusReason").getter(AnalyzerSummary.getter(AnalyzerSummary::statusReason)).setter(AnalyzerSummary.setter(Builder::statusReason)).constructor(StatusReason::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(AnalyzerSummary.getter(AnalyzerSummary::tags)).setter(AnalyzerSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(AnalyzerSummary.getter(AnalyzerSummary::typeAsString)).setter(AnalyzerSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD, LAST_RESOURCE_ANALYZED_FIELD, LAST_RESOURCE_ANALYZED_AT_FIELD, NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, TAGS_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final Instant createdAt;
    private final String lastResourceAnalyzed;
    private final Instant lastResourceAnalyzedAt;
    private final String name;
    private final String status;
    private final StatusReason statusReason;
    private final Map<String, String> tags;
    private final String type;

    private AnalyzerSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.lastResourceAnalyzed = builder.lastResourceAnalyzed;
        this.lastResourceAnalyzedAt = builder.lastResourceAnalyzedAt;
        this.name = builder.name;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    public String arn() {
        return this.arn;
    }

    public Instant createdAt() {
        return this.createdAt;
    }

    public String lastResourceAnalyzed() {
        return this.lastResourceAnalyzed;
    }

    public Instant lastResourceAnalyzedAt() {
        return this.lastResourceAnalyzedAt;
    }

    public String name() {
        return this.name;
    }

    public AnalyzerStatus status() {
        return AnalyzerStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public StatusReason statusReason() {
        return this.statusReason;
    }

    public boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Type type() {
        return Type.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastResourceAnalyzed());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastResourceAnalyzedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzerSummary)) {
            return false;
        }
        AnalyzerSummary other = (AnalyzerSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastResourceAnalyzed(), other.lastResourceAnalyzed()) && Objects.equals(this.lastResourceAnalyzedAt(), other.lastResourceAnalyzedAt()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"AnalyzerSummary").add("Arn", (Object)this.arn()).add("CreatedAt", (Object)this.createdAt()).add("LastResourceAnalyzed", (Object)this.lastResourceAnalyzed()).add("LastResourceAnalyzedAt", (Object)this.lastResourceAnalyzedAt()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("Tags", this.tags()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastResourceAnalyzed": {
                return Optional.ofNullable(clazz.cast(this.lastResourceAnalyzed()));
            }
            case "lastResourceAnalyzedAt": {
                return Optional.ofNullable(clazz.cast(this.lastResourceAnalyzedAt()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyzerSummary, T> g) {
        return obj -> g.apply((AnalyzerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private Instant createdAt;
        private String lastResourceAnalyzed;
        private Instant lastResourceAnalyzedAt;
        private String name;
        private String status;
        private StatusReason statusReason;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzerSummary model) {
            this.arn(model.arn);
            this.createdAt(model.createdAt);
            this.lastResourceAnalyzed(model.lastResourceAnalyzed);
            this.lastResourceAnalyzedAt(model.lastResourceAnalyzedAt);
            this.name(model.name);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.tags(model.tags);
            this.type(model.type);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getLastResourceAnalyzed() {
            return this.lastResourceAnalyzed;
        }

        @Override
        public final Builder lastResourceAnalyzed(String lastResourceAnalyzed) {
            this.lastResourceAnalyzed = lastResourceAnalyzed;
            return this;
        }

        public final void setLastResourceAnalyzed(String lastResourceAnalyzed) {
            this.lastResourceAnalyzed = lastResourceAnalyzed;
        }

        public final Instant getLastResourceAnalyzedAt() {
            return this.lastResourceAnalyzedAt;
        }

        @Override
        public final Builder lastResourceAnalyzedAt(Instant lastResourceAnalyzedAt) {
            this.lastResourceAnalyzedAt = lastResourceAnalyzedAt;
            return this;
        }

        public final void setLastResourceAnalyzedAt(Instant lastResourceAnalyzedAt) {
            this.lastResourceAnalyzedAt = lastResourceAnalyzedAt;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AnalyzerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final StatusReason.Builder getStatusReason() {
            return this.statusReason != null ? this.statusReason.toBuilder() : null;
        }

        @Override
        public final Builder statusReason(StatusReason statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final void setStatusReason(StatusReason.BuilderImpl statusReason) {
            this.statusReason = statusReason != null ? statusReason.build() : null;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public AnalyzerSummary build() {
            return new AnalyzerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalyzerSummary> {
        public Builder arn(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastResourceAnalyzed(String var1);

        public Builder lastResourceAnalyzedAt(Instant var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(AnalyzerStatus var1);

        public Builder statusReason(StatusReason var1);

        default public Builder statusReason(Consumer<StatusReason.Builder> statusReason) {
            return this.statusReason((StatusReason)((StatusReason.Builder)StatusReason.builder().applyMutation(statusReason)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder type(String var1);

        public Builder type(Type var1);
    }
}

