/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.transfer;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.transfer.;
import software.amazon.awscdk.services.transfer.CfnServer;
import software.amazon.awscdk.services.transfer.CfnServerProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-transfer.CfnServer")
public class CfnServer
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnServer.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnServer(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnServer(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnServer(@NotNull Construct scope, @NotNull String id, @Nullable CfnServerProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public CfnServer(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)((Object)this), (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)((Object)this), (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrArn", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAttrServerId() {
        return (String)Kernel.get((Object)((Object)this), (String)"attrServerId", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)((Object)this), (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)Kernel.get((Object)((Object)this), (String)"tags", (NativeType)NativeType.forClass(TagManager.class));
    }

    @Nullable
    public String getCertificate() {
        return (String)Kernel.get((Object)((Object)this), (String)"certificate", (NativeType)NativeType.forClass(String.class));
    }

    public void setCertificate(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"certificate", (Object)value);
    }

    @Nullable
    public String getDomain() {
        return (String)Kernel.get((Object)((Object)this), (String)"domain", (NativeType)NativeType.forClass(String.class));
    }

    public void setDomain(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"domain", (Object)value);
    }

    @Nullable
    public Object getEndpointDetails() {
        return Kernel.get((Object)((Object)this), (String)"endpointDetails", (NativeType)NativeType.forClass(Object.class));
    }

    public void setEndpointDetails(@Nullable EndpointDetailsProperty value) {
        Kernel.set((Object)((Object)this), (String)"endpointDetails", (Object)value);
    }

    public void setEndpointDetails(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"endpointDetails", (Object)value);
    }

    @Nullable
    public String getEndpointType() {
        return (String)Kernel.get((Object)((Object)this), (String)"endpointType", (NativeType)NativeType.forClass(String.class));
    }

    public void setEndpointType(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"endpointType", (Object)value);
    }

    @Nullable
    public Object getIdentityProviderDetails() {
        return Kernel.get((Object)((Object)this), (String)"identityProviderDetails", (NativeType)NativeType.forClass(Object.class));
    }

    public void setIdentityProviderDetails(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"identityProviderDetails", (Object)value);
    }

    public void setIdentityProviderDetails(@Nullable IdentityProviderDetailsProperty value) {
        Kernel.set((Object)((Object)this), (String)"identityProviderDetails", (Object)value);
    }

    @Nullable
    public String getIdentityProviderType() {
        return (String)Kernel.get((Object)((Object)this), (String)"identityProviderType", (NativeType)NativeType.forClass(String.class));
    }

    public void setIdentityProviderType(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"identityProviderType", (Object)value);
    }

    @Nullable
    public String getLoggingRole() {
        return (String)Kernel.get((Object)((Object)this), (String)"loggingRole", (NativeType)NativeType.forClass(String.class));
    }

    public void setLoggingRole(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"loggingRole", (Object)value);
    }

    @Nullable
    public Object getProtocolDetails() {
        return Kernel.get((Object)((Object)this), (String)"protocolDetails", (NativeType)NativeType.forClass(Object.class));
    }

    public void setProtocolDetails(@Nullable IResolvable value) {
        Kernel.set((Object)((Object)this), (String)"protocolDetails", (Object)value);
    }

    public void setProtocolDetails(@Nullable ProtocolDetailsProperty value) {
        Kernel.set((Object)((Object)this), (String)"protocolDetails", (Object)value);
    }

    @Nullable
    public List<String> getProtocols() {
        return Optional.ofNullable((List)Kernel.get((Object)((Object)this), (String)"protocols", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(String.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setProtocols(@Nullable List<String> value) {
        Kernel.set((Object)((Object)this), (String)"protocols", value);
    }

    @Nullable
    public String getSecurityPolicyName() {
        return (String)Kernel.get((Object)((Object)this), (String)"securityPolicyName", (NativeType)NativeType.forClass(String.class));
    }

    public void setSecurityPolicyName(@Nullable String value) {
        Kernel.set((Object)((Object)this), (String)"securityPolicyName", (Object)value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnServer> {
        private final Construct scope;
        private final String id;
        private CfnServerProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder certificate(String certificate) {
            this.props().certificate(certificate);
            return this;
        }

        public Builder domain(String domain) {
            this.props().domain(domain);
            return this;
        }

        public Builder endpointDetails(EndpointDetailsProperty endpointDetails) {
            this.props().endpointDetails(endpointDetails);
            return this;
        }

        public Builder endpointDetails(IResolvable endpointDetails) {
            this.props().endpointDetails(endpointDetails);
            return this;
        }

        public Builder endpointType(String endpointType) {
            this.props().endpointType(endpointType);
            return this;
        }

        public Builder identityProviderDetails(IResolvable identityProviderDetails) {
            this.props().identityProviderDetails(identityProviderDetails);
            return this;
        }

        public Builder identityProviderDetails(IdentityProviderDetailsProperty identityProviderDetails) {
            this.props().identityProviderDetails(identityProviderDetails);
            return this;
        }

        public Builder identityProviderType(String identityProviderType) {
            this.props().identityProviderType(identityProviderType);
            return this;
        }

        public Builder loggingRole(String loggingRole) {
            this.props().loggingRole(loggingRole);
            return this;
        }

        public Builder protocolDetails(IResolvable protocolDetails) {
            this.props().protocolDetails(protocolDetails);
            return this;
        }

        public Builder protocolDetails(ProtocolDetailsProperty protocolDetails) {
            this.props().protocolDetails(protocolDetails);
            return this;
        }

        public Builder protocols(List<String> protocols) {
            this.props().protocols(protocols);
            return this;
        }

        public Builder securityPolicyName(String securityPolicyName) {
            this.props().securityPolicyName(securityPolicyName);
            return this;
        }

        public Builder tags(List<? extends CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        public CfnServer build() {
            return new CfnServer(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private CfnServerProps.Builder props() {
            if (this.props == null) {
                this.props = new CfnServerProps.Builder();
            }
            return this.props;
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-transfer.CfnServer.ProtocolDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ProtocolDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getPassiveIp() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ProtocolDetailsProperty> {
            private String passiveIp;

            public Builder passiveIp(String passiveIp) {
                this.passiveIp = passiveIp;
                return this;
            }

            public ProtocolDetailsProperty build() {
                return new Jsii.Proxy(this.passiveIp);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-transfer.CfnServer.IdentityProviderDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface IdentityProviderDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public String getDirectoryId() {
            return null;
        }

        @Nullable
        default public String getInvocationRole() {
            return null;
        }

        @Nullable
        default public String getUrl() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<IdentityProviderDetailsProperty> {
            private String directoryId;
            private String invocationRole;
            private String url;

            public Builder directoryId(String directoryId) {
                this.directoryId = directoryId;
                return this;
            }

            public Builder invocationRole(String invocationRole) {
                this.invocationRole = invocationRole;
                return this;
            }

            public Builder url(String url) {
                this.url = url;
                return this;
            }

            public IdentityProviderDetailsProperty build() {
                return new Jsii.Proxy(this.directoryId, this.invocationRole, this.url);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-transfer.CfnServer.EndpointDetailsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface EndpointDetailsProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getAddressAllocationIds() {
            return null;
        }

        @Nullable
        default public List<String> getSecurityGroupIds() {
            return null;
        }

        @Nullable
        default public List<String> getSubnetIds() {
            return null;
        }

        @Nullable
        default public String getVpcEndpointId() {
            return null;
        }

        @Nullable
        default public String getVpcId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<EndpointDetailsProperty> {
            private List<String> addressAllocationIds;
            private List<String> securityGroupIds;
            private List<String> subnetIds;
            private String vpcEndpointId;
            private String vpcId;

            public Builder addressAllocationIds(List<String> addressAllocationIds) {
                this.addressAllocationIds = addressAllocationIds;
                return this;
            }

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public Builder vpcEndpointId(String vpcEndpointId) {
                this.vpcEndpointId = vpcEndpointId;
                return this;
            }

            public Builder vpcId(String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            public EndpointDetailsProperty build() {
                return new Jsii.Proxy(this.addressAllocationIds, this.securityGroupIds, this.subnetIds, this.vpcEndpointId, this.vpcId);
            }
        }
    }
}

