/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.synthetics;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.FromCloudFormationOptions;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.synthetics.;
import software.amazon.awscdk.services.synthetics.CfnCanary;
import software.amazon.awscdk.services.synthetics.CfnCanaryProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-synthetics.CfnCanary")
public class CfnCanary
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnCanary.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnCanary(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCanary(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnCanary(@NotNull Construct scope, @NotNull String id, @NotNull CfnCanaryProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static CfnCanary fromCloudFormation(@NotNull Construct scope, @NotNull String id, @NotNull Object resourceAttributes, @NotNull FromCloudFormationOptions options) {
        return (CfnCanary)((Object)JsiiObject.jsiiStaticCall(CfnCanary.class, (String)"fromCloudFormation", CfnCanary.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), resourceAttributes, Objects.requireNonNull(options, "options is required")}));
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrId() {
        return (String)this.jsiiGet("attrId", String.class);
    }

    @NotNull
    public String getAttrState() {
        return (String)this.jsiiGet("attrState", String.class);
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    @NotNull
    public String getArtifactS3Location() {
        return (String)this.jsiiGet("artifactS3Location", String.class);
    }

    public void setArtifactS3Location(@NotNull String value) {
        this.jsiiSet("artifactS3Location", Objects.requireNonNull(value, "artifactS3Location is required"));
    }

    @NotNull
    public Object getCode() {
        return this.jsiiGet("code", Object.class);
    }

    public void setCode(@NotNull CodeProperty value) {
        this.jsiiSet("code", Objects.requireNonNull(value, "code is required"));
    }

    public void setCode(@NotNull IResolvable value) {
        this.jsiiSet("code", Objects.requireNonNull(value, "code is required"));
    }

    @NotNull
    public String getExecutionRoleArn() {
        return (String)this.jsiiGet("executionRoleArn", String.class);
    }

    public void setExecutionRoleArn(@NotNull String value) {
        this.jsiiSet("executionRoleArn", Objects.requireNonNull(value, "executionRoleArn is required"));
    }

    @NotNull
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(@NotNull String value) {
        this.jsiiSet("name", Objects.requireNonNull(value, "name is required"));
    }

    @NotNull
    public String getRuntimeVersion() {
        return (String)this.jsiiGet("runtimeVersion", String.class);
    }

    public void setRuntimeVersion(@NotNull String value) {
        this.jsiiSet("runtimeVersion", Objects.requireNonNull(value, "runtimeVersion is required"));
    }

    @NotNull
    public Object getSchedule() {
        return this.jsiiGet("schedule", Object.class);
    }

    public void setSchedule(@NotNull IResolvable value) {
        this.jsiiSet("schedule", Objects.requireNonNull(value, "schedule is required"));
    }

    public void setSchedule(@NotNull ScheduleProperty value) {
        this.jsiiSet("schedule", Objects.requireNonNull(value, "schedule is required"));
    }

    @NotNull
    public Object getStartCanaryAfterCreation() {
        return this.jsiiGet("startCanaryAfterCreation", Object.class);
    }

    public void setStartCanaryAfterCreation(@NotNull Boolean value) {
        this.jsiiSet("startCanaryAfterCreation", Objects.requireNonNull(value, "startCanaryAfterCreation is required"));
    }

    public void setStartCanaryAfterCreation(@NotNull IResolvable value) {
        this.jsiiSet("startCanaryAfterCreation", Objects.requireNonNull(value, "startCanaryAfterCreation is required"));
    }

    @Nullable
    public Number getFailureRetentionPeriod() {
        return (Number)this.jsiiGet("failureRetentionPeriod", Number.class);
    }

    public void setFailureRetentionPeriod(@Nullable Number value) {
        this.jsiiSet("failureRetentionPeriod", value);
    }

    @Nullable
    public Object getRunConfig() {
        return this.jsiiGet("runConfig", Object.class);
    }

    public void setRunConfig(@Nullable IResolvable value) {
        this.jsiiSet("runConfig", value);
    }

    public void setRunConfig(@Nullable RunConfigProperty value) {
        this.jsiiSet("runConfig", value);
    }

    @Nullable
    public Number getSuccessRetentionPeriod() {
        return (Number)this.jsiiGet("successRetentionPeriod", Number.class);
    }

    public void setSuccessRetentionPeriod(@Nullable Number value) {
        this.jsiiSet("successRetentionPeriod", value);
    }

    @Nullable
    public Object getVpcConfig() {
        return this.jsiiGet("vpcConfig", Object.class);
    }

    public void setVpcConfig(@Nullable IResolvable value) {
        this.jsiiSet("vpcConfig", value);
    }

    public void setVpcConfig(@Nullable VPCConfigProperty value) {
        this.jsiiSet("vpcConfig", value);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnCanary> {
        private final Construct scope;
        private final String id;
        private final CfnCanaryProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnCanaryProps.Builder();
        }

        public Builder artifactS3Location(String artifactS3Location) {
            this.props.artifactS3Location(artifactS3Location);
            return this;
        }

        public Builder code(CodeProperty code) {
            this.props.code(code);
            return this;
        }

        public Builder code(IResolvable code) {
            this.props.code(code);
            return this;
        }

        public Builder executionRoleArn(String executionRoleArn) {
            this.props.executionRoleArn(executionRoleArn);
            return this;
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder runtimeVersion(String runtimeVersion) {
            this.props.runtimeVersion(runtimeVersion);
            return this;
        }

        public Builder schedule(IResolvable schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder schedule(ScheduleProperty schedule) {
            this.props.schedule(schedule);
            return this;
        }

        public Builder startCanaryAfterCreation(Boolean startCanaryAfterCreation) {
            this.props.startCanaryAfterCreation(startCanaryAfterCreation);
            return this;
        }

        public Builder startCanaryAfterCreation(IResolvable startCanaryAfterCreation) {
            this.props.startCanaryAfterCreation(startCanaryAfterCreation);
            return this;
        }

        public Builder failureRetentionPeriod(Number failureRetentionPeriod) {
            this.props.failureRetentionPeriod(failureRetentionPeriod);
            return this;
        }

        public Builder runConfig(IResolvable runConfig) {
            this.props.runConfig(runConfig);
            return this;
        }

        public Builder runConfig(RunConfigProperty runConfig) {
            this.props.runConfig(runConfig);
            return this;
        }

        public Builder successRetentionPeriod(Number successRetentionPeriod) {
            this.props.successRetentionPeriod(successRetentionPeriod);
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        public Builder vpcConfig(IResolvable vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public Builder vpcConfig(VPCConfigProperty vpcConfig) {
            this.props.vpcConfig(vpcConfig);
            return this;
        }

        public CfnCanary build() {
            return new CfnCanary(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-synthetics.CfnCanary.VPCConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface VPCConfigProperty
    extends JsiiSerializable {
        @NotNull
        public List<String> getSecurityGroupIds();

        @NotNull
        public List<String> getSubnetIds();

        @Nullable
        default public String getVpcId() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<VPCConfigProperty> {
            private List<String> securityGroupIds;
            private List<String> subnetIds;
            private String vpcId;

            public Builder securityGroupIds(List<String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            public Builder subnetIds(List<String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            public Builder vpcId(String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            public VPCConfigProperty build() {
                return new Jsii.Proxy(this.securityGroupIds, this.subnetIds, this.vpcId, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-synthetics.CfnCanary.ScheduleProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ScheduleProperty
    extends JsiiSerializable {
        @NotNull
        public String getExpression();

        @Nullable
        default public String getDurationInSeconds() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ScheduleProperty> {
            private String expression;
            private String durationInSeconds;

            public Builder expression(String expression) {
                this.expression = expression;
                return this;
            }

            public Builder durationInSeconds(String durationInSeconds) {
                this.durationInSeconds = durationInSeconds;
                return this;
            }

            public ScheduleProperty build() {
                return new Jsii.Proxy(this.expression, this.durationInSeconds, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-synthetics.CfnCanary.RunConfigProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RunConfigProperty
    extends JsiiSerializable {
        @NotNull
        public Number getTimeoutInSeconds();

        @Nullable
        default public Number getMemoryInMb() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RunConfigProperty> {
            private Number timeoutInSeconds;
            private Number memoryInMb;

            public Builder timeoutInSeconds(Number timeoutInSeconds) {
                this.timeoutInSeconds = timeoutInSeconds;
                return this;
            }

            public Builder memoryInMb(Number memoryInMb) {
                this.memoryInMb = memoryInMb;
                return this;
            }

            public RunConfigProperty build() {
                return new Jsii.Proxy(this.timeoutInSeconds, this.memoryInMb, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-synthetics.CfnCanary.CodeProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface CodeProperty
    extends JsiiSerializable {
        @Nullable
        default public String getHandler() {
            return null;
        }

        @Nullable
        default public String getS3Bucket() {
            return null;
        }

        @Nullable
        default public String getS3Key() {
            return null;
        }

        @Nullable
        default public String getS3ObjectVersion() {
            return null;
        }

        @Nullable
        default public String getScript() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<CodeProperty> {
            private String handler;
            private String s3Bucket;
            private String s3Key;
            private String s3ObjectVersion;
            private String script;

            public Builder handler(String handler) {
                this.handler = handler;
                return this;
            }

            public Builder s3Bucket(String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            public Builder s3Key(String s3Key) {
                this.s3Key = s3Key;
                return this;
            }

            public Builder s3ObjectVersion(String s3ObjectVersion) {
                this.s3ObjectVersion = s3ObjectVersion;
                return this;
            }

            public Builder script(String script) {
                this.script = script;
                return this;
            }

            public CodeProperty build() {
                return new Jsii.Proxy(this.handler, this.s3Bucket, this.s3Key, this.s3ObjectVersion, this.script, null);
            }
        }
    }
}

