/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.synthetics.alpha;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.synthetics.alpha.;
import software.amazon.awscdk.services.synthetics.alpha.ArtifactsBucketLocation;
import software.amazon.awscdk.services.synthetics.alpha.CanaryProps;
import software.amazon.awscdk.services.synthetics.alpha.Runtime;
import software.amazon.awscdk.services.synthetics.alpha.Schedule;
import software.amazon.awscdk.services.synthetics.alpha.Test;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-synthetics-alpha.CanaryProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface CanaryProps
extends JsiiSerializable {
    @NotNull
    public Runtime getRuntime();

    @NotNull
    public Test getTest();

    @Nullable
    default public ArtifactsBucketLocation getArtifactsBucketLocation() {
        return null;
    }

    @Nullable
    default public String getCanaryName() {
        return null;
    }

    @Nullable
    default public Map<String, String> getEnvironmentVariables() {
        return null;
    }

    @Nullable
    default public Duration getFailureRetentionPeriod() {
        return null;
    }

    @Nullable
    default public IRole getRole() {
        return null;
    }

    @Nullable
    default public Schedule getSchedule() {
        return null;
    }

    @Nullable
    default public Boolean getStartAfterCreation() {
        return null;
    }

    @Nullable
    default public Duration getSuccessRetentionPeriod() {
        return null;
    }

    @Nullable
    default public Duration getTimeToLive() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CanaryProps> {
        private Runtime runtime;
        private Test test;
        private ArtifactsBucketLocation artifactsBucketLocation;
        private String canaryName;
        private Map<String, String> environmentVariables;
        private Duration failureRetentionPeriod;
        private IRole role;
        private Schedule schedule;
        private Boolean startAfterCreation;
        private Duration successRetentionPeriod;
        private Duration timeToLive;

        public Builder runtime(Runtime runtime) {
            this.runtime = runtime;
            return this;
        }

        public Builder test(Test test) {
            this.test = test;
            return this;
        }

        public Builder artifactsBucketLocation(ArtifactsBucketLocation artifactsBucketLocation) {
            this.artifactsBucketLocation = artifactsBucketLocation;
            return this;
        }

        public Builder canaryName(String canaryName) {
            this.canaryName = canaryName;
            return this;
        }

        public Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        public Builder failureRetentionPeriod(Duration failureRetentionPeriod) {
            this.failureRetentionPeriod = failureRetentionPeriod;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder schedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public Builder startAfterCreation(Boolean startAfterCreation) {
            this.startAfterCreation = startAfterCreation;
            return this;
        }

        public Builder successRetentionPeriod(Duration successRetentionPeriod) {
            this.successRetentionPeriod = successRetentionPeriod;
            return this;
        }

        public Builder timeToLive(Duration timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public CanaryProps build() {
            return new Jsii.Proxy(this.runtime, this.test, this.artifactsBucketLocation, this.canaryName, this.environmentVariables, this.failureRetentionPeriod, this.role, this.schedule, this.startAfterCreation, this.successRetentionPeriod, this.timeToLive);
        }
    }
}

