/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions;

import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask;
import software.amazon.awscdk.services.stepfunctions.TaskProps;
import software.amazon.jsii.JsiiSerializable;

public interface TaskProps
extends JsiiSerializable {
    public IStepFunctionsTask getTask();

    public String getComment();

    public String getInputPath();

    public String getOutputPath();

    public String getResultPath();

    public Duration getTimeout();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IStepFunctionsTask task;
        private String comment;
        private String inputPath;
        private String outputPath;
        private String resultPath;
        private Duration timeout;

        public Builder task(IStepFunctionsTask task) {
            this.task = task;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public TaskProps build() {
            return new Jsii.Proxy(this.task, this.comment, this.inputPath, this.outputPath, this.resultPath, this.timeout, null);
        }
    }
}

