/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import software.amazon.awscdk.services.stepfunctions.tasks.CompressionType;
import software.amazon.awscdk.services.stepfunctions.tasks.SplitType;
import software.amazon.awscdk.services.stepfunctions.tasks.TransformDataSource;
import software.amazon.awscdk.services.stepfunctions.tasks.TransformInput;
import software.amazon.jsii.JsiiSerializable;

public interface TransformInput
extends JsiiSerializable {
    public TransformDataSource getTransformDataSource();

    public CompressionType getCompressionType();

    public String getContentType();

    public SplitType getSplitType();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TransformDataSource transformDataSource;
        private CompressionType compressionType;
        private String contentType;
        private SplitType splitType;

        public Builder transformDataSource(TransformDataSource transformDataSource) {
            this.transformDataSource = transformDataSource;
            return this;
        }

        public Builder compressionType(CompressionType compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder splitType(SplitType splitType) {
            this.splitType = splitType;
            return this;
        }

        public TransformInput build() {
            return new Jsii.Proxy(this.transformDataSource, this.compressionType, this.contentType, this.splitType, null);
        }
    }
}

