/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.Map;
import software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.tasks.InvocationType;
import software.amazon.awscdk.services.stepfunctions.tasks.RunLambdaTaskProps;
import software.amazon.jsii.JsiiSerializable;

public interface RunLambdaTaskProps
extends JsiiSerializable {
    public String getClientContext();

    public ServiceIntegrationPattern getIntegrationPattern();

    public InvocationType getInvocationType();

    public Map<String, Object> getPayload();

    public String getQualifier();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String clientContext;
        private ServiceIntegrationPattern integrationPattern;
        private InvocationType invocationType;
        private Map<String, Object> payload;
        private String qualifier;

        public Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public Builder integrationPattern(ServiceIntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        public Builder invocationType(InvocationType invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        public Builder payload(Map<String, Object> payload) {
            this.payload = payload;
            return this;
        }

        public Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public RunLambdaTaskProps build() {
            return new Jsii.Proxy(this.clientContext, this.integrationPattern, this.invocationType, this.payload, this.qualifier, null);
        }
    }
}

