/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.TaskInput;
import software.amazon.awscdk.services.stepfunctions.tasks.SendToQueueProps;
import software.amazon.jsii.JsiiSerializable;

public interface SendToQueueProps
extends JsiiSerializable {
    public TaskInput getMessageBody();

    public Duration getDelay();

    public ServiceIntegrationPattern getIntegrationPattern();

    public String getMessageDeduplicationId();

    public String getMessageGroupId();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TaskInput messageBody;
        private Duration delay;
        private ServiceIntegrationPattern integrationPattern;
        private String messageDeduplicationId;
        private String messageGroupId;

        public Builder messageBody(TaskInput messageBody) {
            this.messageBody = messageBody;
            return this;
        }

        public Builder delay(Duration delay) {
            this.delay = delay;
            return this;
        }

        public Builder integrationPattern(ServiceIntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        public Builder messageDeduplicationId(String messageDeduplicationId) {
            this.messageDeduplicationId = messageDeduplicationId;
            return this;
        }

        public Builder messageGroupId(String messageGroupId) {
            this.messageGroupId = messageGroupId;
            return this;
        }

        public SendToQueueProps build() {
            return new Jsii.Proxy(this.messageBody, this.delay, this.integrationPattern, this.messageDeduplicationId, this.messageGroupId, null);
        }
    }
}

