/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig;
import software.amazon.awscdk.services.stepfunctions.tasks.S3Location;
import software.amazon.jsii.JsiiSerializable;

public interface OutputDataConfig
extends JsiiSerializable {
    public S3Location getS3OutputLocation();

    public IKey getEncryptionKey();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private S3Location s3OutputLocation;
        private IKey encryptionKey;

        public Builder s3OutputLocation(S3Location s3OutputLocation) {
            this.s3OutputLocation = s3OutputLocation;
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public OutputDataConfig build() {
            return new Jsii.Proxy(this.s3OutputLocation, this.encryptionKey, null);
        }
    }
}

