/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import software.amazon.awscdk.services.stepfunctions.tasks.Channel;
import software.amazon.awscdk.services.stepfunctions.tasks.CompressionType;
import software.amazon.awscdk.services.stepfunctions.tasks.DataSource;
import software.amazon.awscdk.services.stepfunctions.tasks.InputMode;
import software.amazon.awscdk.services.stepfunctions.tasks.RecordWrapperType;
import software.amazon.awscdk.services.stepfunctions.tasks.ShuffleConfig;
import software.amazon.jsii.JsiiSerializable;

public interface Channel
extends JsiiSerializable {
    public String getChannelName();

    public DataSource getDataSource();

    public CompressionType getCompressionType();

    public String getContentType();

    public InputMode getInputMode();

    public RecordWrapperType getRecordWrapperType();

    public ShuffleConfig getShuffleConfig();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String channelName;
        private DataSource dataSource;
        private CompressionType compressionType;
        private String contentType;
        private InputMode inputMode;
        private RecordWrapperType recordWrapperType;
        private ShuffleConfig shuffleConfig;

        public Builder channelName(String channelName) {
            this.channelName = channelName;
            return this;
        }

        public Builder dataSource(DataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public Builder compressionType(CompressionType compressionType) {
            this.compressionType = compressionType;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder inputMode(InputMode inputMode) {
            this.inputMode = inputMode;
            return this;
        }

        public Builder recordWrapperType(RecordWrapperType recordWrapperType) {
            this.recordWrapperType = recordWrapperType;
            return this;
        }

        public Builder shuffleConfig(ShuffleConfig shuffleConfig) {
            this.shuffleConfig = shuffleConfig;
            return this;
        }

        public Channel build() {
            return new Jsii.Proxy(this.channelName, this.dataSource, this.compressionType, this.contentType, this.inputMode, this.recordWrapperType, this.shuffleConfig, null);
        }
    }
}

