/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.TaskInput;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface SendToQueueProps
extends JsiiSerializable {
    public TaskInput getMessageBody();

    public Duration getDelay();

    public ServiceIntegrationPattern getIntegrationPattern();

    public String getMessageDeduplicationId();

    public String getMessageGroupId();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TaskInput _messageBody;
        @Nullable
        private Duration _delay;
        @Nullable
        private ServiceIntegrationPattern _integrationPattern;
        @Nullable
        private String _messageDeduplicationId;
        @Nullable
        private String _messageGroupId;

        public Builder withMessageBody(TaskInput value) {
            this._messageBody = Objects.requireNonNull(value, "messageBody is required");
            return this;
        }

        public Builder withDelay(@Nullable Duration value) {
            this._delay = value;
            return this;
        }

        public Builder withIntegrationPattern(@Nullable ServiceIntegrationPattern value) {
            this._integrationPattern = value;
            return this;
        }

        public Builder withMessageDeduplicationId(@Nullable String value) {
            this._messageDeduplicationId = value;
            return this;
        }

        public Builder withMessageGroupId(@Nullable String value) {
            this._messageGroupId = value;
            return this;
        }

        public SendToQueueProps build() {
            return new SendToQueueProps(){
                private final TaskInput $messageBody;
                @Nullable
                private final Duration $delay;
                @Nullable
                private final ServiceIntegrationPattern $integrationPattern;
                @Nullable
                private final String $messageDeduplicationId;
                @Nullable
                private final String $messageGroupId;
                {
                    this.$messageBody = Objects.requireNonNull(_messageBody, "messageBody is required");
                    this.$delay = _delay;
                    this.$integrationPattern = _integrationPattern;
                    this.$messageDeduplicationId = _messageDeduplicationId;
                    this.$messageGroupId = _messageGroupId;
                }

                @Override
                public TaskInput getMessageBody() {
                    return this.$messageBody;
                }

                @Override
                public Duration getDelay() {
                    return this.$delay;
                }

                @Override
                public ServiceIntegrationPattern getIntegrationPattern() {
                    return this.$integrationPattern;
                }

                @Override
                public String getMessageDeduplicationId() {
                    return this.$messageDeduplicationId;
                }

                @Override
                public String getMessageGroupId() {
                    return this.$messageGroupId;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("messageBody", om.valueToTree((Object)this.getMessageBody()));
                    if (this.getDelay() != null) {
                        obj.set("delay", om.valueToTree((Object)this.getDelay()));
                    }
                    if (this.getIntegrationPattern() != null) {
                        obj.set("integrationPattern", om.valueToTree((Object)this.getIntegrationPattern()));
                    }
                    if (this.getMessageDeduplicationId() != null) {
                        obj.set("messageDeduplicationId", om.valueToTree((Object)this.getMessageDeduplicationId()));
                    }
                    if (this.getMessageGroupId() != null) {
                        obj.set("messageGroupId", om.valueToTree((Object)this.getMessageGroupId()));
                    }
                    return obj;
                }
            };
        }
    }
}

