/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.TaskInput;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface PublishToTopicProps
extends JsiiSerializable {
    public TaskInput getMessage();

    public ServiceIntegrationPattern getIntegrationPattern();

    public Boolean getMessagePerSubscriptionType();

    public String getSubject();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private TaskInput _message;
        @Nullable
        private ServiceIntegrationPattern _integrationPattern;
        @Nullable
        private Boolean _messagePerSubscriptionType;
        @Nullable
        private String _subject;

        public Builder withMessage(TaskInput value) {
            this._message = Objects.requireNonNull(value, "message is required");
            return this;
        }

        public Builder withIntegrationPattern(@Nullable ServiceIntegrationPattern value) {
            this._integrationPattern = value;
            return this;
        }

        public Builder withMessagePerSubscriptionType(@Nullable Boolean value) {
            this._messagePerSubscriptionType = value;
            return this;
        }

        public Builder withSubject(@Nullable String value) {
            this._subject = value;
            return this;
        }

        public PublishToTopicProps build() {
            return new PublishToTopicProps(){
                private final TaskInput $message;
                @Nullable
                private final ServiceIntegrationPattern $integrationPattern;
                @Nullable
                private final Boolean $messagePerSubscriptionType;
                @Nullable
                private final String $subject;
                {
                    this.$message = Objects.requireNonNull(_message, "message is required");
                    this.$integrationPattern = _integrationPattern;
                    this.$messagePerSubscriptionType = _messagePerSubscriptionType;
                    this.$subject = _subject;
                }

                @Override
                public TaskInput getMessage() {
                    return this.$message;
                }

                @Override
                public ServiceIntegrationPattern getIntegrationPattern() {
                    return this.$integrationPattern;
                }

                @Override
                public Boolean getMessagePerSubscriptionType() {
                    return this.$messagePerSubscriptionType;
                }

                @Override
                public String getSubject() {
                    return this.$subject;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("message", om.valueToTree((Object)this.getMessage()));
                    if (this.getIntegrationPattern() != null) {
                        obj.set("integrationPattern", om.valueToTree((Object)this.getIntegrationPattern()));
                    }
                    if (this.getMessagePerSubscriptionType() != null) {
                        obj.set("messagePerSubscriptionType", om.valueToTree((Object)this.getMessagePerSubscriptionType()));
                    }
                    if (this.getSubject() != null) {
                        obj.set("subject", om.valueToTree((Object)this.getSubject()));
                    }
                    return obj;
                }
            };
        }
    }
}

