/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.List;
import java.util.Map;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.tasks.$Module;
import software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification;
import software.amazon.awscdk.services.stepfunctions.tasks.Channel;
import software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig;
import software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig;
import software.amazon.awscdk.services.stepfunctions.tasks.SagemakerTrainTaskProps;
import software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition;
import software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.SagemakerTrainTaskProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface SagemakerTrainTaskProps
extends JsiiSerializable {
    public AlgorithmSpecification getAlgorithmSpecification();

    public List<Channel> getInputDataConfig();

    public OutputDataConfig getOutputDataConfig();

    public String getTrainingJobName();

    default public Map<String, Object> getHyperparameters() {
        return null;
    }

    default public ServiceIntegrationPattern getIntegrationPattern() {
        return null;
    }

    default public ResourceConfig getResourceConfig() {
        return null;
    }

    default public IRole getRole() {
        return null;
    }

    default public StoppingCondition getStoppingCondition() {
        return null;
    }

    default public Map<String, String> getTags() {
        return null;
    }

    default public VpcConfig getVpcConfig() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AlgorithmSpecification algorithmSpecification;
        private List<Channel> inputDataConfig;
        private OutputDataConfig outputDataConfig;
        private String trainingJobName;
        private Map<String, Object> hyperparameters;
        private ServiceIntegrationPattern integrationPattern;
        private ResourceConfig resourceConfig;
        private IRole role;
        private StoppingCondition stoppingCondition;
        private Map<String, String> tags;
        private VpcConfig vpcConfig;

        public Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        public Builder inputDataConfig(List<Channel> inputDataConfig) {
            this.inputDataConfig = inputDataConfig;
            return this;
        }

        public Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public Builder hyperparameters(Map<String, Object> hyperparameters) {
            this.hyperparameters = hyperparameters;
            return this;
        }

        public Builder integrationPattern(ServiceIntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        public Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public SagemakerTrainTaskProps build() {
            return new Jsii.Proxy(this.algorithmSpecification, this.inputDataConfig, this.outputDataConfig, this.trainingJobName, this.hyperparameters, this.integrationPattern, this.resourceConfig, this.role, this.stoppingCondition, this.tags, this.vpcConfig, null);
        }
    }
}

