/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface ResourceConfig
extends JsiiSerializable {
    public Number getInstanceCount();

    public InstanceType getInstanceType();

    public Number getVolumeSizeInGb();

    public IKey getVolumeEncryptionKey();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Number _instanceCount;
        private InstanceType _instanceType;
        private Number _volumeSizeInGb;
        @Nullable
        private IKey _volumeEncryptionKey;

        public Builder withInstanceCount(Number value) {
            this._instanceCount = Objects.requireNonNull(value, "instanceCount is required");
            return this;
        }

        public Builder withInstanceType(InstanceType value) {
            this._instanceType = Objects.requireNonNull(value, "instanceType is required");
            return this;
        }

        public Builder withVolumeSizeInGb(Number value) {
            this._volumeSizeInGb = Objects.requireNonNull(value, "volumeSizeInGb is required");
            return this;
        }

        public Builder withVolumeEncryptionKey(@Nullable IKey value) {
            this._volumeEncryptionKey = value;
            return this;
        }

        public ResourceConfig build() {
            return new ResourceConfig(){
                private final Number $instanceCount;
                private final InstanceType $instanceType;
                private final Number $volumeSizeInGb;
                @Nullable
                private final IKey $volumeEncryptionKey;
                {
                    this.$instanceCount = Objects.requireNonNull(_instanceCount, "instanceCount is required");
                    this.$instanceType = Objects.requireNonNull(_instanceType, "instanceType is required");
                    this.$volumeSizeInGb = Objects.requireNonNull(_volumeSizeInGb, "volumeSizeInGb is required");
                    this.$volumeEncryptionKey = _volumeEncryptionKey;
                }

                @Override
                public Number getInstanceCount() {
                    return this.$instanceCount;
                }

                @Override
                public InstanceType getInstanceType() {
                    return this.$instanceType;
                }

                @Override
                public Number getVolumeSizeInGb() {
                    return this.$volumeSizeInGb;
                }

                @Override
                public IKey getVolumeEncryptionKey() {
                    return this.$volumeEncryptionKey;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("instanceCount", om.valueToTree((Object)this.getInstanceCount()));
                    obj.set("instanceType", om.valueToTree((Object)this.getInstanceType()));
                    obj.set("volumeSizeInGB", om.valueToTree((Object)this.getVolumeSizeInGb()));
                    if (this.getVolumeEncryptionKey() != null) {
                        obj.set("volumeEncryptionKey", om.valueToTree((Object)this.getVolumeEncryptionKey()));
                    }
                    return obj;
                }
            };
        }
    }
}

