/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.ISubnet;
import software.amazon.awscdk.services.ec2.Vpc;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface VpcConfig
extends JsiiSerializable {
    public List<ISecurityGroup> getSecurityGroups();

    public List<ISubnet> getSubnets();

    public Vpc getVpc();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private List<ISecurityGroup> _securityGroups;
        private List<ISubnet> _subnets;
        private Vpc _vpc;

        public Builder withSecurityGroups(List<ISecurityGroup> value) {
            this._securityGroups = Objects.requireNonNull(value, "securityGroups is required");
            return this;
        }

        public Builder withSubnets(List<ISubnet> value) {
            this._subnets = Objects.requireNonNull(value, "subnets is required");
            return this;
        }

        public Builder withVpc(Vpc value) {
            this._vpc = Objects.requireNonNull(value, "vpc is required");
            return this;
        }

        public VpcConfig build() {
            return new VpcConfig(){
                private final List<ISecurityGroup> $securityGroups;
                private final List<ISubnet> $subnets;
                private final Vpc $vpc;
                {
                    this.$securityGroups = Objects.requireNonNull(_securityGroups, "securityGroups is required");
                    this.$subnets = Objects.requireNonNull(_subnets, "subnets is required");
                    this.$vpc = Objects.requireNonNull(_vpc, "vpc is required");
                }

                @Override
                public List<ISecurityGroup> getSecurityGroups() {
                    return this.$securityGroups;
                }

                @Override
                public List<ISubnet> getSubnets() {
                    return this.$subnets;
                }

                @Override
                public Vpc getVpc() {
                    return this.$vpc;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("securityGroups", om.valueToTree(this.getSecurityGroups()));
                    obj.set("subnets", om.valueToTree(this.getSubnets()));
                    obj.set("vpc", om.valueToTree((Object)this.getVpc()));
                    return obj;
                }
            };
        }
    }
}

