/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.stepfunctions.tasks.AlgorithmSpecification;
import software.amazon.awscdk.services.stepfunctions.tasks.Channel;
import software.amazon.awscdk.services.stepfunctions.tasks.OutputDataConfig;
import software.amazon.awscdk.services.stepfunctions.tasks.ResourceConfig;
import software.amazon.awscdk.services.stepfunctions.tasks.StoppingCondition;
import software.amazon.awscdk.services.stepfunctions.tasks.VpcConfig;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface SagemakerTrainProps
extends JsiiSerializable {
    public AlgorithmSpecification getAlgorithmSpecification();

    public List<Channel> getInputDataConfig();

    public OutputDataConfig getOutputDataConfig();

    public String getTrainingJobName();

    public Map<String, Object> getHyperparameters();

    public ResourceConfig getResourceConfig();

    public IRole getRole();

    public StoppingCondition getStoppingCondition();

    public Boolean getSynchronous();

    public Map<String, Object> getTags();

    public VpcConfig getVpcConfig();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AlgorithmSpecification _algorithmSpecification;
        private List<Channel> _inputDataConfig;
        private OutputDataConfig _outputDataConfig;
        private String _trainingJobName;
        @Nullable
        private Map<String, Object> _hyperparameters;
        @Nullable
        private ResourceConfig _resourceConfig;
        @Nullable
        private IRole _role;
        @Nullable
        private StoppingCondition _stoppingCondition;
        @Nullable
        private Boolean _synchronous;
        @Nullable
        private Map<String, Object> _tags;
        @Nullable
        private VpcConfig _vpcConfig;

        public Builder withAlgorithmSpecification(AlgorithmSpecification value) {
            this._algorithmSpecification = Objects.requireNonNull(value, "algorithmSpecification is required");
            return this;
        }

        public Builder withInputDataConfig(List<Channel> value) {
            this._inputDataConfig = Objects.requireNonNull(value, "inputDataConfig is required");
            return this;
        }

        public Builder withOutputDataConfig(OutputDataConfig value) {
            this._outputDataConfig = Objects.requireNonNull(value, "outputDataConfig is required");
            return this;
        }

        public Builder withTrainingJobName(String value) {
            this._trainingJobName = Objects.requireNonNull(value, "trainingJobName is required");
            return this;
        }

        public Builder withHyperparameters(@Nullable Map<String, Object> value) {
            this._hyperparameters = value;
            return this;
        }

        public Builder withResourceConfig(@Nullable ResourceConfig value) {
            this._resourceConfig = value;
            return this;
        }

        public Builder withRole(@Nullable IRole value) {
            this._role = value;
            return this;
        }

        public Builder withStoppingCondition(@Nullable StoppingCondition value) {
            this._stoppingCondition = value;
            return this;
        }

        public Builder withSynchronous(@Nullable Boolean value) {
            this._synchronous = value;
            return this;
        }

        public Builder withTags(@Nullable Map<String, Object> value) {
            this._tags = value;
            return this;
        }

        public Builder withVpcConfig(@Nullable VpcConfig value) {
            this._vpcConfig = value;
            return this;
        }

        public SagemakerTrainProps build() {
            return new SagemakerTrainProps(){
                private final AlgorithmSpecification $algorithmSpecification;
                private final List<Channel> $inputDataConfig;
                private final OutputDataConfig $outputDataConfig;
                private final String $trainingJobName;
                @Nullable
                private final Map<String, Object> $hyperparameters;
                @Nullable
                private final ResourceConfig $resourceConfig;
                @Nullable
                private final IRole $role;
                @Nullable
                private final StoppingCondition $stoppingCondition;
                @Nullable
                private final Boolean $synchronous;
                @Nullable
                private final Map<String, Object> $tags;
                @Nullable
                private final VpcConfig $vpcConfig;
                {
                    this.$algorithmSpecification = Objects.requireNonNull(_algorithmSpecification, "algorithmSpecification is required");
                    this.$inputDataConfig = Objects.requireNonNull(_inputDataConfig, "inputDataConfig is required");
                    this.$outputDataConfig = Objects.requireNonNull(_outputDataConfig, "outputDataConfig is required");
                    this.$trainingJobName = Objects.requireNonNull(_trainingJobName, "trainingJobName is required");
                    this.$hyperparameters = _hyperparameters;
                    this.$resourceConfig = _resourceConfig;
                    this.$role = _role;
                    this.$stoppingCondition = _stoppingCondition;
                    this.$synchronous = _synchronous;
                    this.$tags = _tags;
                    this.$vpcConfig = _vpcConfig;
                }

                @Override
                public AlgorithmSpecification getAlgorithmSpecification() {
                    return this.$algorithmSpecification;
                }

                @Override
                public List<Channel> getInputDataConfig() {
                    return this.$inputDataConfig;
                }

                @Override
                public OutputDataConfig getOutputDataConfig() {
                    return this.$outputDataConfig;
                }

                @Override
                public String getTrainingJobName() {
                    return this.$trainingJobName;
                }

                @Override
                public Map<String, Object> getHyperparameters() {
                    return this.$hyperparameters;
                }

                @Override
                public ResourceConfig getResourceConfig() {
                    return this.$resourceConfig;
                }

                @Override
                public IRole getRole() {
                    return this.$role;
                }

                @Override
                public StoppingCondition getStoppingCondition() {
                    return this.$stoppingCondition;
                }

                @Override
                public Boolean getSynchronous() {
                    return this.$synchronous;
                }

                @Override
                public Map<String, Object> getTags() {
                    return this.$tags;
                }

                @Override
                public VpcConfig getVpcConfig() {
                    return this.$vpcConfig;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("algorithmSpecification", om.valueToTree((Object)this.getAlgorithmSpecification()));
                    obj.set("inputDataConfig", om.valueToTree(this.getInputDataConfig()));
                    obj.set("outputDataConfig", om.valueToTree((Object)this.getOutputDataConfig()));
                    obj.set("trainingJobName", om.valueToTree((Object)this.getTrainingJobName()));
                    if (this.getHyperparameters() != null) {
                        obj.set("hyperparameters", om.valueToTree(this.getHyperparameters()));
                    }
                    if (this.getResourceConfig() != null) {
                        obj.set("resourceConfig", om.valueToTree((Object)this.getResourceConfig()));
                    }
                    if (this.getRole() != null) {
                        obj.set("role", om.valueToTree((Object)this.getRole()));
                    }
                    if (this.getStoppingCondition() != null) {
                        obj.set("stoppingCondition", om.valueToTree((Object)this.getStoppingCondition()));
                    }
                    if (this.getSynchronous() != null) {
                        obj.set("synchronous", om.valueToTree((Object)this.getSynchronous()));
                    }
                    if (this.getTags() != null) {
                        obj.set("tags", om.valueToTree(this.getTags()));
                    }
                    if (this.getVpcConfig() != null) {
                        obj.set("vpcConfig", om.valueToTree((Object)this.getVpcConfig()));
                    }
                    return obj;
                }
            };
        }
    }
}

