/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.ssm.;
import software.amazon.awscdk.services.ssm.IParameter;
import software.amazon.awscdk.services.ssm.IStringParameter;
import software.amazon.awscdk.services.ssm.ParameterTier;
import software.amazon.awscdk.services.ssm.ParameterType;
import software.amazon.awscdk.services.ssm.SecureStringParameterAttributes;
import software.amazon.awscdk.services.ssm.StringParameterAttributes;
import software.amazon.awscdk.services.ssm.StringParameterProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-ssm.StringParameter")
public class StringParameter
extends Resource
implements IStringParameter,
IParameter {
    protected StringParameter(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StringParameter(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public StringParameter(@NotNull software.constructs.Construct scope, @NotNull String id, @NotNull StringParameterProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IStringParameter fromSecureStringParameterAttributes(@NotNull software.constructs.Construct scope, @NotNull String id, @NotNull SecureStringParameterAttributes attrs) {
        return (IStringParameter)JsiiObject.jsiiStaticCall(StringParameter.class, (String)"fromSecureStringParameterAttributes", IStringParameter.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IStringParameter fromStringParameterAttributes(@NotNull software.constructs.Construct scope, @NotNull String id, @NotNull StringParameterAttributes attrs) {
        return (IStringParameter)JsiiObject.jsiiStaticCall(StringParameter.class, (String)"fromStringParameterAttributes", IStringParameter.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @NotNull
    public static IStringParameter fromStringParameterName(@NotNull software.constructs.Construct scope, @NotNull String id, @NotNull String stringParameterName) {
        return (IStringParameter)JsiiObject.jsiiStaticCall(StringParameter.class, (String)"fromStringParameterName", IStringParameter.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(stringParameterName, "stringParameterName is required")});
    }

    @NotNull
    public static String valueForSecureStringParameter(@NotNull software.constructs.Construct scope, @NotNull String parameterName, @NotNull Number version) {
        return (String)JsiiObject.jsiiStaticCall(StringParameter.class, (String)"valueForSecureStringParameter", String.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(parameterName, "parameterName is required"), Objects.requireNonNull(version, "version is required")});
    }

    @NotNull
    public static String valueForStringParameter(@NotNull software.constructs.Construct scope, @NotNull String parameterName, @Nullable Number version) {
        return (String)JsiiObject.jsiiStaticCall(StringParameter.class, (String)"valueForStringParameter", String.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(parameterName, "parameterName is required"), version});
    }

    @NotNull
    public static String valueForStringParameter(@NotNull software.constructs.Construct scope, @NotNull String parameterName) {
        return (String)JsiiObject.jsiiStaticCall(StringParameter.class, (String)"valueForStringParameter", String.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(parameterName, "parameterName is required")});
    }

    @NotNull
    public static String valueForTypedStringParameter(@NotNull software.constructs.Construct scope, @NotNull String parameterName, @Nullable ParameterType type, @Nullable Number version) {
        return (String)JsiiObject.jsiiStaticCall(StringParameter.class, (String)"valueForTypedStringParameter", String.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(parameterName, "parameterName is required"), type, version});
    }

    @NotNull
    public static String valueForTypedStringParameter(@NotNull software.constructs.Construct scope, @NotNull String parameterName, @Nullable ParameterType type) {
        return (String)JsiiObject.jsiiStaticCall(StringParameter.class, (String)"valueForTypedStringParameter", String.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(parameterName, "parameterName is required"), type});
    }

    @NotNull
    public static String valueForTypedStringParameter(@NotNull software.constructs.Construct scope, @NotNull String parameterName) {
        return (String)JsiiObject.jsiiStaticCall(StringParameter.class, (String)"valueForTypedStringParameter", String.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(parameterName, "parameterName is required")});
    }

    @NotNull
    public static String valueFromLookup(@NotNull Construct scope, @NotNull String parameterName) {
        return (String)JsiiObject.jsiiStaticCall(StringParameter.class, (String)"valueFromLookup", String.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(parameterName, "parameterName is required")});
    }

    @Override
    @NotNull
    public Grant grantRead(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantRead", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public Grant grantWrite(@NotNull IGrantable grantee) {
        return (Grant)this.jsiiCall("grantWrite", Grant.class, new Object[]{Objects.requireNonNull(grantee, "grantee is required")});
    }

    @Override
    @NotNull
    public String getParameterArn() {
        return (String)this.jsiiGet("parameterArn", String.class);
    }

    @Override
    @NotNull
    public String getParameterName() {
        return (String)this.jsiiGet("parameterName", String.class);
    }

    @Override
    @NotNull
    public String getParameterType() {
        return (String)this.jsiiGet("parameterType", String.class);
    }

    @Override
    @NotNull
    public String getStringValue() {
        return (String)this.jsiiGet("stringValue", String.class);
    }

    @Nullable
    public IKey getEncryptionKey() {
        return (IKey)this.jsiiGet("encryptionKey", IKey.class);
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<StringParameter> {
        private final software.constructs.Construct scope;
        private final String id;
        private final StringParameterProps.Builder props;

        public static Builder create(software.constructs.Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(software.constructs.Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new StringParameterProps.Builder();
        }

        public Builder allowedPattern(String allowedPattern) {
            this.props.allowedPattern(allowedPattern);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder parameterName(String parameterName) {
            this.props.parameterName(parameterName);
            return this;
        }

        public Builder simpleName(Boolean simpleName) {
            this.props.simpleName(simpleName);
            return this;
        }

        public Builder tier(ParameterTier tier) {
            this.props.tier(tier);
            return this;
        }

        public Builder stringValue(String stringValue) {
            this.props.stringValue(stringValue);
            return this;
        }

        public Builder type(ParameterType type) {
            this.props.type(type);
            return this;
        }

        public StringParameter build() {
            return new StringParameter(this.scope, this.id, this.props.build());
        }
    }
}

