/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.ssm.CfnMaintenanceWindowTask;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnMaintenanceWindowTaskProps
extends JsiiSerializable {
    public String getMaxConcurrency();

    public String getMaxErrors();

    public Number getPriority();

    public Object getTargets();

    public String getTaskArn();

    public String getTaskType();

    public String getWindowId();

    public String getDescription();

    public Object getLoggingInfo();

    public String getName();

    public String getServiceRoleArn();

    public Object getTaskInvocationParameters();

    public Object getTaskParameters();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _maxConcurrency;
        private String _maxErrors;
        private Number _priority;
        private Object _targets;
        private String _taskArn;
        private String _taskType;
        private String _windowId;
        @Nullable
        private String _description;
        @Nullable
        private Object _loggingInfo;
        @Nullable
        private String _name;
        @Nullable
        private String _serviceRoleArn;
        @Nullable
        private Object _taskInvocationParameters;
        @Nullable
        private Object _taskParameters;

        public Builder withMaxConcurrency(String value) {
            this._maxConcurrency = Objects.requireNonNull(value, "maxConcurrency is required");
            return this;
        }

        public Builder withMaxErrors(String value) {
            this._maxErrors = Objects.requireNonNull(value, "maxErrors is required");
            return this;
        }

        public Builder withPriority(Number value) {
            this._priority = Objects.requireNonNull(value, "priority is required");
            return this;
        }

        public Builder withTargets(IResolvable value) {
            this._targets = Objects.requireNonNull(value, "targets is required");
            return this;
        }

        public Builder withTargets(List<Object> value) {
            this._targets = Objects.requireNonNull(value, "targets is required");
            return this;
        }

        public Builder withTaskArn(String value) {
            this._taskArn = Objects.requireNonNull(value, "taskArn is required");
            return this;
        }

        public Builder withTaskType(String value) {
            this._taskType = Objects.requireNonNull(value, "taskType is required");
            return this;
        }

        public Builder withWindowId(String value) {
            this._windowId = Objects.requireNonNull(value, "windowId is required");
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withLoggingInfo(@Nullable IResolvable value) {
            this._loggingInfo = value;
            return this;
        }

        public Builder withLoggingInfo(@Nullable CfnMaintenanceWindowTask.LoggingInfoProperty value) {
            this._loggingInfo = value;
            return this;
        }

        public Builder withName(@Nullable String value) {
            this._name = value;
            return this;
        }

        public Builder withServiceRoleArn(@Nullable String value) {
            this._serviceRoleArn = value;
            return this;
        }

        public Builder withTaskInvocationParameters(@Nullable IResolvable value) {
            this._taskInvocationParameters = value;
            return this;
        }

        public Builder withTaskInvocationParameters(@Nullable CfnMaintenanceWindowTask.TaskInvocationParametersProperty value) {
            this._taskInvocationParameters = value;
            return this;
        }

        public Builder withTaskParameters(@Nullable Object value) {
            this._taskParameters = value;
            return this;
        }

        public CfnMaintenanceWindowTaskProps build() {
            return new CfnMaintenanceWindowTaskProps(){
                private final String $maxConcurrency;
                private final String $maxErrors;
                private final Number $priority;
                private final Object $targets;
                private final String $taskArn;
                private final String $taskType;
                private final String $windowId;
                @Nullable
                private final String $description;
                @Nullable
                private final Object $loggingInfo;
                @Nullable
                private final String $name;
                @Nullable
                private final String $serviceRoleArn;
                @Nullable
                private final Object $taskInvocationParameters;
                @Nullable
                private final Object $taskParameters;
                {
                    this.$maxConcurrency = Objects.requireNonNull(_maxConcurrency, "maxConcurrency is required");
                    this.$maxErrors = Objects.requireNonNull(_maxErrors, "maxErrors is required");
                    this.$priority = Objects.requireNonNull(_priority, "priority is required");
                    this.$targets = Objects.requireNonNull(_targets, "targets is required");
                    this.$taskArn = Objects.requireNonNull(_taskArn, "taskArn is required");
                    this.$taskType = Objects.requireNonNull(_taskType, "taskType is required");
                    this.$windowId = Objects.requireNonNull(_windowId, "windowId is required");
                    this.$description = _description;
                    this.$loggingInfo = _loggingInfo;
                    this.$name = _name;
                    this.$serviceRoleArn = _serviceRoleArn;
                    this.$taskInvocationParameters = _taskInvocationParameters;
                    this.$taskParameters = _taskParameters;
                }

                @Override
                public String getMaxConcurrency() {
                    return this.$maxConcurrency;
                }

                @Override
                public String getMaxErrors() {
                    return this.$maxErrors;
                }

                @Override
                public Number getPriority() {
                    return this.$priority;
                }

                @Override
                public Object getTargets() {
                    return this.$targets;
                }

                @Override
                public String getTaskArn() {
                    return this.$taskArn;
                }

                @Override
                public String getTaskType() {
                    return this.$taskType;
                }

                @Override
                public String getWindowId() {
                    return this.$windowId;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public Object getLoggingInfo() {
                    return this.$loggingInfo;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public String getServiceRoleArn() {
                    return this.$serviceRoleArn;
                }

                @Override
                public Object getTaskInvocationParameters() {
                    return this.$taskInvocationParameters;
                }

                @Override
                public Object getTaskParameters() {
                    return this.$taskParameters;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("maxConcurrency", om.valueToTree((Object)this.getMaxConcurrency()));
                    obj.set("maxErrors", om.valueToTree((Object)this.getMaxErrors()));
                    obj.set("priority", om.valueToTree((Object)this.getPriority()));
                    obj.set("targets", om.valueToTree(this.getTargets()));
                    obj.set("taskArn", om.valueToTree((Object)this.getTaskArn()));
                    obj.set("taskType", om.valueToTree((Object)this.getTaskType()));
                    obj.set("windowId", om.valueToTree((Object)this.getWindowId()));
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getLoggingInfo() != null) {
                        obj.set("loggingInfo", om.valueToTree(this.getLoggingInfo()));
                    }
                    if (this.getName() != null) {
                        obj.set("name", om.valueToTree((Object)this.getName()));
                    }
                    if (this.getServiceRoleArn() != null) {
                        obj.set("serviceRoleArn", om.valueToTree((Object)this.getServiceRoleArn()));
                    }
                    if (this.getTaskInvocationParameters() != null) {
                        obj.set("taskInvocationParameters", om.valueToTree(this.getTaskInvocationParameters()));
                    }
                    if (this.getTaskParameters() != null) {
                        obj.set("taskParameters", om.valueToTree(this.getTaskParameters()));
                    }
                    return obj;
                }
            };
        }
    }
}

