/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import software.amazon.awscdk.services.kms.IKey;
import software.amazon.awscdk.services.ssm.SecureStringParameterAttributes;
import software.amazon.jsii.JsiiSerializable;

public interface SecureStringParameterAttributes
extends JsiiSerializable {
    public String getParameterName();

    public Number getVersion();

    public IKey getEncryptionKey();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String parameterName;
        private Number version;
        private IKey encryptionKey;

        public Builder parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        public Builder version(Number version) {
            this.version = version;
            return this;
        }

        public Builder encryptionKey(IKey encryptionKey) {
            this.encryptionKey = encryptionKey;
            return this;
        }

        public SecureStringParameterAttributes build() {
            return new Jsii.Proxy(this.parameterName, this.version, this.encryptionKey, null);
        }
    }
}

