/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.ssm;

import java.util.List;
import software.amazon.awscdk.core.CfnTag;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.ssm.CfnPatchBaseline;
import software.amazon.awscdk.services.ssm.CfnPatchBaselineProps;
import software.amazon.jsii.JsiiSerializable;

public interface CfnPatchBaselineProps
extends JsiiSerializable {
    public String getName();

    public Object getApprovalRules();

    public List<String> getApprovedPatches();

    public String getApprovedPatchesComplianceLevel();

    public Object getApprovedPatchesEnableNonSecurity();

    public String getDescription();

    public Object getGlobalFilters();

    public String getOperatingSystem();

    public List<String> getPatchGroups();

    public List<String> getRejectedPatches();

    public String getRejectedPatchesAction();

    public Object getSources();

    public List<CfnTag> getTags();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private Object approvalRules;
        private List<String> approvedPatches;
        private String approvedPatchesComplianceLevel;
        private Object approvedPatchesEnableNonSecurity;
        private String description;
        private Object globalFilters;
        private String operatingSystem;
        private List<String> patchGroups;
        private List<String> rejectedPatches;
        private String rejectedPatchesAction;
        private Object sources;
        private List<CfnTag> tags;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder approvalRules(IResolvable approvalRules) {
            this.approvalRules = approvalRules;
            return this;
        }

        public Builder approvalRules(CfnPatchBaseline.RuleGroupProperty approvalRules) {
            this.approvalRules = approvalRules;
            return this;
        }

        public Builder approvedPatches(List<String> approvedPatches) {
            this.approvedPatches = approvedPatches;
            return this;
        }

        public Builder approvedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
            return this;
        }

        public Builder approvedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity) {
            this.approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity;
            return this;
        }

        public Builder approvedPatchesEnableNonSecurity(IResolvable approvedPatchesEnableNonSecurity) {
            this.approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder globalFilters(IResolvable globalFilters) {
            this.globalFilters = globalFilters;
            return this;
        }

        public Builder globalFilters(CfnPatchBaseline.PatchFilterGroupProperty globalFilters) {
            this.globalFilters = globalFilters;
            return this;
        }

        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        public Builder patchGroups(List<String> patchGroups) {
            this.patchGroups = patchGroups;
            return this;
        }

        public Builder rejectedPatches(List<String> rejectedPatches) {
            this.rejectedPatches = rejectedPatches;
            return this;
        }

        public Builder rejectedPatchesAction(String rejectedPatchesAction) {
            this.rejectedPatchesAction = rejectedPatchesAction;
            return this;
        }

        public Builder sources(IResolvable sources) {
            this.sources = sources;
            return this;
        }

        public Builder sources(List<Object> sources) {
            this.sources = sources;
            return this;
        }

        public Builder tags(List<CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        public CfnPatchBaselineProps build() {
            return new Jsii.Proxy(this.name, this.approvalRules, this.approvedPatches, this.approvedPatchesComplianceLevel, this.approvedPatchesEnableNonSecurity, this.description, this.globalFilters, this.operatingSystem, this.patchGroups, this.rejectedPatches, this.rejectedPatchesAction, this.sources, this.tags, null);
        }
    }
}

